/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.BinaryParserConfig;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CDescriptorEvent;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorListener;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.Archive;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.Binary;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.BinaryRunner;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelCache;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.DeltaProcessor;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.core.model.NullBinaryParser;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.SourceMapper;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;

public class CModelManager
implements IResourceChangeListener,
ICDescriptorListener {
    public static boolean VERBOSE = false;
    final CModel cModel = new CModel();
    public static HashSet OptionNames = new HashSet(20);
    public static final int DEFAULT_CHANGE_EVENT = 0;
    protected DeltaProcessor fDeltaProcessor = new DeltaProcessor();
    List fCModelDeltas = Collections.synchronizedList(new ArrayList());
    HashMap reconcileDeltas = new HashMap();
    protected boolean fFire = true;
    protected List fElementChangedListeners = Collections.synchronizedList(new ArrayList());
    public Map sharedWorkingCopies = new HashMap();
    protected Map elementsOutOfSynchWithBuffers = new HashMap(11);
    private ThreadLocal temporaryCache = new ThreadLocal();
    protected CModelCache cache = new CModelCache();
    public ICProject[] cProjectsCache;
    private HashMap binaryRunners = new HashMap();
    private HashMap binaryParsersMap = new HashMap();
    private HashMap sourceMappers = new HashMap();
    public static final IWorkingCopy[] NoWorkingCopy = new IWorkingCopy[0];
    static CModelManager factory = null;

    private CModelManager() {
    }

    public static CModelManager getDefault() {
        if (factory == null) {
            factory = new CModelManager();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)factory, 7);
            CCorePlugin.getDefault().getCDescriptorManager().addDescriptorListener(factory);
        }
        return factory;
    }

    public ICModel getCModel(IWorkspaceRoot iWorkspaceRoot) {
        return this.getCModel();
    }

    public CModel getCModel() {
        return this.cModel;
    }

    public ICElement create(IPath iPath) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember(iPath);
        if (iResource == null) {
            IPath iPath2 = iWorkspaceRoot.getLocation();
            if (iPath.equals((Object)iPath2)) {
                return this.getCModel(iWorkspaceRoot);
            }
            iResource = iWorkspaceRoot.getContainerForLocation(iPath);
            if (iResource == null || !iResource.exists()) {
                iResource = iWorkspaceRoot.getFileForLocation(iPath);
            }
            if (iResource != null && !iResource.exists()) {
                iResource = null;
            }
        }
        return this.create(iResource, null);
    }

    public ICElement create(IResource iResource, ICProject iCProject) {
        if (iResource == null) {
            return null;
        }
        int n = iResource.getType();
        switch (n) {
            case 4: {
                return this.create((IProject)iResource);
            }
            case 1: {
                return this.create((IFile)iResource, iCProject);
            }
            case 2: {
                return this.create((IFolder)iResource, iCProject);
            }
            case 8: {
                return this.getCModel((IWorkspaceRoot)iResource);
            }
        }
        return null;
    }

    public ICProject create(IProject iProject) {
        if (iProject == null) {
            return null;
        }
        return this.cModel.getCProject((IResource)iProject);
    }

    public ICContainer create(IFolder iFolder, ICProject iCProject) {
        if (iFolder == null) {
            return null;
        }
        if (iCProject == null) {
            iCProject = this.create(iFolder.getProject());
        }
        ISourceRoot iSourceRoot = null;
        IPath iPath = iFolder.getFullPath();
        try {
            ISourceRoot[] iSourceRootArray = iCProject.getAllSourceRoots();
            int n = 0;
            while (n < iSourceRootArray.length) {
                ISourceRoot iSourceRoot2 = iSourceRootArray[n];
                IPath iPath2 = iSourceRoot2.getPath();
                if (iPath2.equals((Object)iPath)) {
                    iSourceRoot = iSourceRoot2;
                    break;
                }
                if (iSourceRoot2.isOnSourceEntry((IResource)iFolder)) {
                    IPath iPath3 = iPath.removeFirstSegments(iPath2.segmentCount());
                    String[] stringArray = iPath3.segments();
                    ICContainer iCContainer = iSourceRoot2;
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        iCContainer = iCContainer.getCContainer(stringArray[n2]);
                        ++n2;
                    }
                    iSourceRoot = iCContainer;
                }
                ++n;
            }
        }
        catch (CModelException cModelException) {}
        return iSourceRoot;
    }

    public ICElement create(IFile iFile, ICProject iCProject) {
        if (iFile == null) {
            return null;
        }
        if (iCProject == null) {
            iCProject = this.create(iFile.getProject());
        }
        boolean bl = false;
        ICElement iCElement = null;
        try {
            IBinaryParser.IBinaryFile iBinaryFile;
            ICElement iCElement2;
            ISourceRoot[] iSourceRootArray = iCProject.getAllSourceRoots();
            int n = 0;
            while (n < iSourceRootArray.length) {
                iCElement2 = iSourceRootArray[n];
                if (iCElement2.isOnSourceEntry((IResource)iFile)) {
                    IPath iPath = iCElement2.getPath();
                    IPath iPath2 = iFile.getFullPath();
                    IPath iPath3 = iPath2.removeFirstSegments(iPath.segmentCount());
                    String string = iPath3.lastSegment();
                    iPath3 = iPath3.removeLastSegments(1);
                    String[] stringArray = iPath3.segments();
                    ICElement iCElement3 = iCElement2;
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        iCElement3 = iCElement3.getCContainer(stringArray[n2]);
                        ++n2;
                    }
                    if (CoreModel.isValidTranslationUnitName(iCProject.getProject(), string)) {
                        iCElement = iCElement3.getTranslationUnit(string);
                        break;
                    }
                    if (!iCProject.isOnOutputEntry((IResource)iFile)) break;
                    IBinaryParser.IBinaryFile iBinaryFile2 = this.createBinaryFile(iFile);
                    if (iBinaryFile2 != null) {
                        if (iBinaryFile2.getType() == 8) {
                            iCElement = new Archive(iCElement3, iFile, (IBinaryParser.IBinaryArchive)iBinaryFile2);
                            ArchiveContainer archiveContainer = (ArchiveContainer)iCProject.getArchiveContainer();
                            archiveContainer.addChild(iCElement);
                        } else {
                            iCElement = new Binary(iCElement3, iFile, (IBinaryParser.IBinaryObject)iBinaryFile2);
                            BinaryContainer binaryContainer = (BinaryContainer)iCProject.getBinaryContainer();
                            binaryContainer.addChild(iCElement);
                        }
                    }
                    bl = true;
                    break;
                }
                ++n;
            }
            if (iCElement == null && !bl && iCProject.isOnOutputEntry((IResource)iFile) && (iBinaryFile = this.createBinaryFile(iFile)) != null) {
                if (iBinaryFile.getType() == 8) {
                    iCElement2 = (ArchiveContainer)iCProject.getArchiveContainer();
                    iCElement = new Archive(iCElement2, iFile, (IBinaryParser.IBinaryArchive)iBinaryFile);
                    ((Parent)iCElement2).addChild(iCElement);
                } else {
                    iCElement2 = (BinaryContainer)iCProject.getBinaryContainer();
                    iCElement = new Binary(iCElement2, iFile, (IBinaryParser.IBinaryObject)iBinaryFile);
                    ((Parent)iCElement2).addChild(iCElement);
                }
            }
        }
        catch (CModelException cModelException) {}
        return iCElement;
    }

    public ICElement create(IFile iFile, IBinaryParser.IBinaryFile iBinaryFile, ICProject iCProject) {
        if (iFile == null) {
            return null;
        }
        if (iBinaryFile == null) {
            return this.create(iFile, iCProject);
        }
        if (iCProject == null) {
            iCProject = this.create(iFile.getProject());
        }
        Openable openable = null;
        try {
            ISourceRoot[] iSourceRootArray = iCProject.getAllSourceRoots();
            int n = 0;
            while (n < iSourceRootArray.length) {
                ISourceRoot iSourceRoot = iSourceRootArray[n];
                if (iSourceRoot.isOnSourceEntry((IResource)iFile)) {
                    IPath iPath = iSourceRoot.getPath();
                    IPath iPath2 = iFile.getFullPath();
                    IPath iPath3 = iPath2.removeFirstSegments(iPath.segmentCount());
                    iPath3 = iPath3.removeLastSegments(1);
                    String[] stringArray = iPath3.segments();
                    ICContainer iCContainer = iSourceRoot;
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        iCContainer = iCContainer.getCContainer(stringArray[n2]);
                        ++n2;
                    }
                    if (iBinaryFile.getType() == 8) {
                        openable = new Archive((ICElement)iCContainer, iFile, (IBinaryParser.IBinaryArchive)iBinaryFile);
                        ArchiveContainer archiveContainer = (ArchiveContainer)iCProject.getArchiveContainer();
                        archiveContainer.addChild(openable);
                        break;
                    }
                    openable = new Binary((ICElement)iCContainer, iFile, (IBinaryParser.IBinaryObject)iBinaryFile);
                    BinaryContainer binaryContainer = (BinaryContainer)iCProject.getBinaryContainer();
                    binaryContainer.addChild(openable);
                    break;
                }
                ++n;
            }
            if (openable == null) {
                if (iBinaryFile.getType() == 8) {
                    ArchiveContainer archiveContainer = (ArchiveContainer)iCProject.getArchiveContainer();
                    openable = new Archive((ICElement)archiveContainer, iFile, (IBinaryParser.IBinaryArchive)iBinaryFile);
                    archiveContainer.addChild(openable);
                } else {
                    BinaryContainer binaryContainer = (BinaryContainer)iCProject.getBinaryContainer();
                    openable = new Binary((ICElement)binaryContainer, iFile, (IBinaryParser.IBinaryObject)iBinaryFile);
                    binaryContainer.addChild(openable);
                }
            }
        }
        catch (CModelException cModelException) {}
        return openable;
    }

    public ITranslationUnit createTranslationUnitFrom(ICProject iCProject, IPath iPath) {
        if (iPath == null || iCProject == null) {
            return null;
        }
        if (iPath.isAbsolute()) {
            File file = iPath.toFile();
            if (file == null || !file.isFile()) {
                return null;
            }
            try {
                IIncludeReference[] iIncludeReferenceArray = iCProject.getIncludeReferences();
                int n = 0;
                while (n < iIncludeReferenceArray.length) {
                    if (iIncludeReferenceArray[n].isOnIncludeEntry(iPath)) {
                        return new ExternalTranslationUnit((ICElement)iIncludeReferenceArray[n], iPath);
                    }
                    ++n;
                }
            }
            catch (CModelException cModelException) {}
        } else {
            try {
                IIncludeReference[] iIncludeReferenceArray = iCProject.getIncludeReferences();
                int n = 0;
                while (n < iIncludeReferenceArray.length) {
                    IPath iPath2 = iIncludeReferenceArray[n].getPath().append(iPath);
                    File file = iPath2.toFile();
                    if (file != null && file.isFile()) {
                        return new ExternalTranslationUnit((ICElement)iIncludeReferenceArray[n], iPath2);
                    }
                    ++n;
                }
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    public void releaseCElement(ICElement iCElement) {
        if (iCElement == null) {
            return;
        }
        if (iCElement instanceof IParent) {
            Object object;
            CElementInfo cElementInfo = (CElementInfo)this.peekAtInfo(iCElement);
            if (cElementInfo != null) {
                object = cElementInfo.getChildren();
                int n = 0;
                while (n < ((ICElement[])object).length) {
                    this.releaseCElement(object[n]);
                    ++n;
                }
            }
            if (iCElement instanceof CElement) {
                try {
                    ((CElement)iCElement).closing(cElementInfo);
                }
                catch (CModelException cModelException) {}
            }
            if (iCElement.getElementType() == 12) {
                int n;
                ICElement[] iCElementArray;
                object = iCElement.getCProject();
                CProjectInfo cProjectInfo = (CProjectInfo)this.peekAtInfo((ICElement)object);
                ArrayList<ICElement> arrayList = new ArrayList<ICElement>(5);
                if (cProjectInfo != null && cProjectInfo.vBin != null && this.peekAtInfo(cProjectInfo.vBin) != null) {
                    try {
                        iCElementArray = cProjectInfo.vBin.getChildren();
                        n = 0;
                        while (n < iCElementArray.length) {
                            if (iCElement.getPath().isPrefixOf(iCElementArray[n].getPath())) {
                                arrayList.add(iCElementArray[n]);
                            }
                            ++n;
                        }
                    }
                    catch (CModelException cModelException) {}
                }
                if (cProjectInfo != null && cProjectInfo.vLib != null && this.peekAtInfo(cProjectInfo.vLib) != null) {
                    try {
                        iCElementArray = cProjectInfo.vLib.getChildren();
                        n = 0;
                        while (n < iCElementArray.length) {
                            if (iCElement.getPath().isPrefixOf(iCElementArray[n].getPath())) {
                                arrayList.add(iCElementArray[n]);
                            }
                            ++n;
                        }
                    }
                    catch (CModelException cModelException) {}
                }
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    ICElement iCElement2 = (ICElement)arrayList.get(n2);
                    this.releaseCElement(iCElement2);
                    ++n2;
                }
            }
        }
        this.removeInfo(iCElement);
    }

    public BinaryParserConfig[] getBinaryParser(IProject iProject) {
        BinaryParserConfig[] binaryParserConfigArray;
        try {
            binaryParserConfigArray = (BinaryParserConfig[])this.binaryParsersMap.get(iProject);
            if (binaryParserConfigArray == null) {
                binaryParserConfigArray = CCorePlugin.getDefault().getBinaryParserConfigs(iProject);
            }
            if (binaryParserConfigArray != null) {
                this.binaryParsersMap.put(iProject, binaryParserConfigArray);
                return binaryParserConfigArray;
            }
        }
        catch (CoreException coreException) {}
        binaryParserConfigArray = new NullBinaryParser();
        BinaryParserConfig binaryParserConfig = new BinaryParserConfig((IBinaryParser)binaryParserConfigArray, "");
        BinaryParserConfig[] binaryParserConfigArray2 = new BinaryParserConfig[]{binaryParserConfig};
        return binaryParserConfigArray2;
    }

    public IBinaryParser.IBinaryFile createBinaryFile(IFile iFile) {
        Object object;
        int n;
        Object object2;
        BinaryParserConfig[] binaryParserConfigArray = this.getBinaryParser(iFile.getProject());
        int n2 = 0;
        int n3 = 0;
        while (n3 < binaryParserConfigArray.length) {
            object2 = binaryParserConfigArray[n3].getBinaryParser();
            if (object2.getHintBufferSize() > n2) {
                n2 = object2.getHintBufferSize();
            }
            ++n3;
        }
        byte[] byArray = new byte[n2];
        if (n2 > 0) {
            try {
                object2 = iFile.getContents();
                n = ((InputStream)object2).read(byArray);
                ((InputStream)object2).close();
                if (n > 0 && n < byArray.length) {
                    object = new byte[n];
                    System.arraycopy(byArray, 0, object, 0, n);
                    byArray = object;
                }
            }
            catch (CoreException coreException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        object2 = iFile.getLocation();
        n = 0;
        while (n < binaryParserConfigArray.length) {
            try {
                object = binaryParserConfigArray[n].getBinaryParser().getBinary(byArray, (IPath)object2);
                if (object != null) {
                    return object;
                }
            }
            catch (IOException iOException) {}
            ++n;
        }
        return null;
    }

    public void resetBinaryParser(IProject iProject) {
        ICProject iCProject;
        if (iProject != null && (iCProject = this.create(iProject)) != null) {
            try {
                iCProject.close();
            }
            catch (CModelException cModelException) {
                cModelException.printStackTrace();
            }
            this.binaryParsersMap.remove(iProject);
            CElementDelta cElementDelta = new CElementDelta(this.getCModel());
            cElementDelta.binaryParserChanged(iCProject);
            this.registerCModelDelta(cElementDelta);
            this.fire(1);
        }
    }

    public BinaryRunner getBinaryRunner(ICProject iCProject, boolean bl) {
        BinaryRunner binaryRunner = null;
        HashMap hashMap = this.binaryRunners;
        synchronized (hashMap) {
            binaryRunner = (BinaryRunner)this.binaryRunners.get(iCProject.getProject());
            if (binaryRunner == null) {
                binaryRunner = new BinaryRunner(iCProject.getProject());
                this.binaryRunners.put(iCProject.getProject(), binaryRunner);
                if (bl) {
                    binaryRunner.start();
                }
            }
        }
        return binaryRunner;
    }

    public void removeBinaryRunner(ICProject iCProject) {
        this.removeBinaryRunner(iCProject.getProject());
    }

    public void removeBinaryRunner(IProject iProject) {
        BinaryRunner binaryRunner = (BinaryRunner)this.binaryRunners.remove(iProject);
        if (binaryRunner != null) {
            binaryRunner.stop();
        }
    }

    public SourceMapper getSourceMapper(ICProject iCProject) {
        SourceMapper sourceMapper = null;
        HashMap hashMap = this.sourceMappers;
        synchronized (hashMap) {
            sourceMapper = (SourceMapper)this.sourceMappers.get(iCProject);
            if (sourceMapper == null) {
                sourceMapper = new SourceMapper(iCProject);
                this.sourceMappers.put(iCProject, sourceMapper);
            }
        }
        return sourceMapper;
    }

    public void addElementChangedListener(IElementChangedListener iElementChangedListener) {
        List list = this.fElementChangedListeners;
        synchronized (list) {
            if (!this.fElementChangedListeners.contains(iElementChangedListener)) {
                this.fElementChangedListeners.add(iElementChangedListener);
            }
        }
    }

    public void removeElementChangedListener(IElementChangedListener iElementChangedListener) {
        List list = this.fElementChangedListeners;
        synchronized (list) {
            int n = this.fElementChangedListeners.indexOf(iElementChangedListener);
            if (n != -1) {
                this.fElementChangedListeners.remove(n);
            }
        }
    }

    public void registerCModelDelta(ICElementDelta iCElementDelta) {
        this.fCModelDeltas.add(iCElementDelta);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (iResourceChangeEvent.getSource() instanceof IWorkspace) {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            IResource iResource = iResourceChangeEvent.getResource();
            switch (iResourceChangeEvent.getType()) {
                case 4: {
                    try {
                        if (iResource.getType() != 4 || !((IProject)iResource).hasNature("org.eclipse.cdt.core.cnature") && !((IProject)iResource).hasNature("org.eclipse.cdt.core.ccnature")) break;
                        this.deleting((IProject)iResource);
                    }
                    catch (CoreException coreException) {}
                    break;
                }
                case 1: {
                    try {
                        if (iResourceDelta == null) break;
                        ICElementDelta[] iCElementDeltaArray = this.fDeltaProcessor.processResourceDelta(iResourceDelta);
                        if (iCElementDeltaArray.length > 0) {
                            int n = 0;
                            while (n < iCElementDeltaArray.length) {
                                this.registerCModelDelta(iCElementDeltaArray[n]);
                                ++n;
                            }
                        }
                        this.fire(1);
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    public void descriptorChanged(CDescriptorEvent cDescriptorEvent) {
        block6: {
            ICDescriptor iCDescriptor;
            int n = cDescriptorEvent.getFlags();
            if ((n & 0x20) != 0 && (iCDescriptor = cDescriptorEvent.getDescriptor()) != null) {
                IProject iProject = iCDescriptor.getProject();
                try {
                    String[] stringArray = CCorePlugin.getDefault().getBinaryParserIds(iProject);
                    BinaryParserConfig[] binaryParserConfigArray = this.getBinaryParser(iProject);
                    if (stringArray.length != binaryParserConfigArray.length) {
                        this.resetBinaryParser(iProject);
                        break block6;
                    }
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        String string = stringArray[n2];
                        if (!string.equals(binaryParserConfigArray[n2].getId())) {
                            this.resetBinaryParser(iProject);
                            break;
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
    }

    public void fire(int n) {
        this.fire(null, n);
    }

    public void fire(ICElementDelta iCElementDelta, int n) {
        if (this.fFire) {
            int[] nArray;
            int n2;
            IElementChangedListener[] iElementChangedListenerArray;
            ICElementDelta iCElementDelta2 = iCElementDelta == null ? this.mergeDeltas(this.fCModelDeltas) : iCElementDelta;
            List list = this.fElementChangedListeners;
            synchronized (list) {
                iElementChangedListenerArray = new IElementChangedListener[this.fElementChangedListeners.size()];
                this.fElementChangedListeners.toArray(iElementChangedListenerArray);
                n2 = iElementChangedListenerArray.length;
                nArray = null;
            }
            switch (n) {
                case 0: {
                    this.firePreAutoBuildDelta(iCElementDelta2, iElementChangedListenerArray, nArray, n2);
                    this.firePostChangeDelta(iCElementDelta2, iElementChangedListenerArray, nArray, n2);
                    this.fireReconcileDelta(iElementChangedListenerArray, nArray, n2);
                    break;
                }
                case 2: {
                    this.firePreAutoBuildDelta(iCElementDelta2, iElementChangedListenerArray, nArray, n2);
                    break;
                }
                case 1: {
                    this.firePostChangeDelta(iCElementDelta2, iElementChangedListenerArray, nArray, n2);
                    this.fireReconcileDelta(iElementChangedListenerArray, nArray, n2);
                    break;
                }
                case 4: {
                    this.fireReconcileDelta(iElementChangedListenerArray, nArray, n2);
                }
            }
        }
    }

    private void firePreAutoBuildDelta(ICElementDelta iCElementDelta, IElementChangedListener[] iElementChangedListenerArray, int[] nArray, int n) {
        if (VERBOSE) {
            System.out.println("FIRING PRE_AUTO_BUILD Delta [" + Thread.currentThread() + "]:");
            System.out.println(iCElementDelta == null ? "<NONE>" : iCElementDelta.toString());
        }
        if (iCElementDelta != null) {
            this.notifyListeners(iCElementDelta, 2, iElementChangedListenerArray, nArray, n);
        }
    }

    private void firePostChangeDelta(ICElementDelta iCElementDelta, IElementChangedListener[] iElementChangedListenerArray, int[] nArray, int n) {
        if (VERBOSE) {
            System.out.println("FIRING POST_CHANGE Delta [" + Thread.currentThread() + "]:");
            System.out.println(iCElementDelta == null ? "<NONE>" : iCElementDelta.toString());
        }
        if (iCElementDelta != null) {
            this.flush();
            this.notifyListeners(iCElementDelta, 1, iElementChangedListenerArray, nArray, n);
        }
    }

    private void fireReconcileDelta(IElementChangedListener[] iElementChangedListenerArray, int[] nArray, int n) {
        ICElementDelta iCElementDelta = this.mergeDeltas(this.reconcileDeltas.values());
        if (VERBOSE) {
            System.out.println("FIRING POST_RECONCILE Delta [" + Thread.currentThread() + "]:");
            System.out.println(iCElementDelta == null ? "<NONE>" : iCElementDelta.toString());
        }
        if (iCElementDelta != null) {
            this.reconcileDeltas = new HashMap();
            this.notifyListeners(iCElementDelta, 4, iElementChangedListenerArray, nArray, n);
        }
    }

    public void notifyListeners(ICElementDelta iCElementDelta, int n, IElementChangedListener[] iElementChangedListenerArray, int[] nArray, int n2) {
        final ElementChangedEvent elementChangedEvent = new ElementChangedEvent(iCElementDelta, n);
        int n3 = 0;
        while (n3 < n2) {
            if (nArray == null || (nArray[n3] & n) != 0) {
                final IElementChangedListener iElementChangedListener = iElementChangedListenerArray[n3];
                long l = -1L;
                if (VERBOSE) {
                    System.out.print("Listener #" + (n3 + 1) + "=" + iElementChangedListener.toString());
                    l = System.currentTimeMillis();
                }
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable throwable) {
                        CCorePlugin.log(throwable);
                    }

                    public void run() throws Exception {
                        iElementChangedListener.elementChanged(elementChangedEvent);
                    }
                });
                if (VERBOSE) {
                    System.out.println(" -> " + (System.currentTimeMillis() - l) + "ms");
                }
            }
            ++n3;
        }
    }

    protected void flush() {
        this.fCModelDeltas.clear();
    }

    private ICElementDelta mergeDeltas(Collection collection) {
        Collection collection2 = collection;
        synchronized (collection2) {
            if (collection.size() == 0) {
                return null;
            }
            if (collection.size() == 1) {
                return (ICElementDelta)collection.iterator().next();
            }
            if (collection.size() <= 1) {
                return null;
            }
            Iterator iterator = collection.iterator();
            CModel cModel = this.getCModel();
            CElementDelta cElementDelta = new CElementDelta(cModel);
            boolean bl = false;
            while (iterator.hasNext()) {
                CElementDelta cElementDelta2 = (CElementDelta)iterator.next();
                ICElement iCElement = cElementDelta2.getElement();
                if (((Object)cModel).equals(iCElement)) {
                    ICElementDelta[] iCElementDeltaArray = cElementDelta2.getAffectedChildren();
                    int n = 0;
                    while (n < iCElementDeltaArray.length) {
                        CElementDelta cElementDelta3 = (CElementDelta)iCElementDeltaArray[n];
                        cElementDelta.insertDeltaTree(cElementDelta3.getElement(), cElementDelta3);
                        bl = true;
                        ++n;
                    }
                    continue;
                }
                cElementDelta.insertDeltaTree(iCElement, cElementDelta2);
                bl = true;
            }
            if (bl) {
                return cElementDelta;
            }
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public void runOperation(CModelOperation var1_1, IProgressMonitor var2_2) throws CModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 155->159)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Map getElementsOutOfSynchWithBuffers() {
        return this.elementsOutOfSynchWithBuffers;
    }

    public synchronized Object getInfo(ICElement iCElement) {
        Object v;
        HashMap hashMap = (HashMap)this.temporaryCache.get();
        if (hashMap != null && (v = hashMap.get(iCElement)) != null) {
            return v;
        }
        return this.cache.getInfo(iCElement);
    }

    protected synchronized Object peekAtInfo(ICElement iCElement) {
        Object v;
        HashMap hashMap = (HashMap)this.temporaryCache.get();
        if (hashMap != null && (v = hashMap.get(iCElement)) != null) {
            return v;
        }
        return this.cache.peekAtInfo(iCElement);
    }

    protected synchronized void putInfos(ICElement iCElement, Map map) {
        ICElement[] iCElementArray;
        Object object = this.cache.peekAtInfo(iCElement);
        if (iCElement instanceof IParent && object instanceof CElementInfo) {
            iCElementArray = ((CElementInfo)object).getChildren();
            int n = 0;
            int n2 = iCElementArray.length;
            while (n < n2) {
                CElement cElement = (CElement)iCElementArray[n];
                try {
                    cElement.close();
                }
                catch (CModelException cModelException) {}
                ++n;
            }
        }
        iCElementArray = map.keySet().iterator();
        while (iCElementArray.hasNext()) {
            ICElement iCElement2 = (ICElement)iCElementArray.next();
            Object v = map.get(iCElement2);
            this.cache.putInfo(iCElement2, v);
        }
    }

    protected synchronized void removeChildrenInfo(ICElement iCElement) {
        Object object = this.cache.peekAtInfo(iCElement);
        if (iCElement instanceof IParent && object instanceof CElementInfo) {
            ICElement[] iCElementArray = ((CElementInfo)object).getChildren();
            int n = 0;
            int n2 = iCElementArray.length;
            while (n < n2) {
                CElement cElement = (CElement)iCElementArray[n];
                try {
                    cElement.close();
                }
                catch (CModelException cModelException) {}
                ++n;
            }
        }
    }

    protected synchronized void removeInfo(ICElement iCElement) {
        this.cache.removeInfo(iCElement);
    }

    public HashMap getTemporaryCache() {
        HashMap hashMap = (HashMap)this.temporaryCache.get();
        if (hashMap == null) {
            hashMap = new HashMap();
            this.temporaryCache.set(hashMap);
        }
        return hashMap;
    }

    public boolean hasTemporaryCache() {
        return this.temporaryCache.get() != null;
    }

    public void resetTemporaryCache() {
        this.temporaryCache.set(null);
    }

    public void startup() {
    }

    public void shutdown() {
        if (this.fDeltaProcessor.indexManager != null) {
            this.fDeltaProcessor.indexManager.shutdown();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)factory);
        BinaryRunner[] binaryRunnerArray = this.binaryRunners.values().toArray(new BinaryRunner[0]);
        int n = 0;
        while (n < binaryRunnerArray.length) {
            binaryRunnerArray[n].stop();
            ++n;
        }
    }

    public IndexManager getIndexManager() {
        return this.fDeltaProcessor.indexManager;
    }

    public void deleting(IProject iProject) {
        this.getIndexManager().discardJobs(iProject.getName());
        this.removeBinaryRunner(iProject);
    }
}

