/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.BinaryParserConfig;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.IncludeReference;
import org.eclipse.cdt.internal.core.model.LibraryReference;
import org.eclipse.cdt.internal.core.model.LibraryReferenceArchive;
import org.eclipse.cdt.internal.core.model.LibraryReferenceShared;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.cdt.internal.core.model.SourceRoot;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;

public class CProject
extends Openable
implements ICProject {
    private static final String CUSTOM_DEFAULT_OPTION_VALUE = "#\r\n\r#custom-non-empty-default-value#\r\n\r#";

    public CProject(ICElement iCElement, IProject iProject) {
        super(iCElement, (IResource)iProject, 11);
    }

    public IBinaryContainer getBinaryContainer() throws CModelException {
        return ((CProjectInfo)this.getElementInfo()).getBinaryContainer();
    }

    public IArchiveContainer getArchiveContainer() throws CModelException {
        return ((CProjectInfo)this.getElementInfo()).getArchiveContainer();
    }

    public IProject getProject() {
        return this.getUnderlyingResource().getProject();
    }

    public ICElement findElement(IPath iPath) throws CModelException {
        Object object;
        ICElement iCElement = null;
        if (iPath.isAbsolute()) {
            iCElement = CModelManager.getDefault().create(iPath);
        } else {
            object = this.getProject();
            if (object != null) {
                IPath iPath2 = object.getFullPath().append(iPath);
                iCElement = CModelManager.getDefault().create(iPath2);
            }
        }
        if (iCElement == null) {
            object = new CModelStatus(979, iPath);
            throw new CModelException((ICModelStatus)object);
        }
        return iCElement;
    }

    public static boolean hasCNature(IProject iProject) {
        try {
            return iProject.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean hasCCNature(IProject iProject) {
        try {
            return iProject.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean isCProject() {
        return CProject.hasCNature(this.getProject()) || CProject.hasCCNature(this.getProject());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CProject)) {
            return false;
        }
        CProject cProject = (CProject)object;
        return this.getProject().equals((Object)cProject.getProject());
    }

    protected CElementInfo createElementInfo() {
        return new CProjectInfo(this);
    }

    public int hashCode() {
        return this.getProject().hashCode();
    }

    public IIncludeReference[] getIncludeReferences() throws CModelException {
        CProjectInfo cProjectInfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(this);
        IIncludeReference[] iIncludeReferenceArray = null;
        if (cProjectInfo != null) {
            iIncludeReferenceArray = cProjectInfo.incReferences;
        }
        if (iIncludeReferenceArray == null) {
            IPathEntry[] iPathEntryArray = this.getResolvedPathEntries();
            ArrayList<IncludeReference> arrayList = new ArrayList<IncludeReference>(iPathEntryArray.length);
            int n = 0;
            while (n < iPathEntryArray.length) {
                IIncludeEntry iIncludeEntry;
                IncludeReference includeReference;
                if (iPathEntryArray[n].getEntryKind() == 4 && (includeReference = new IncludeReference(this, iIncludeEntry = (IIncludeEntry)iPathEntryArray[n])) != null) {
                    arrayList.add(includeReference);
                }
                ++n;
            }
            iIncludeReferenceArray = arrayList.toArray(new IIncludeReference[0]);
            if (cProjectInfo != null) {
                cProjectInfo.incReferences = iIncludeReferenceArray;
            }
        }
        return iIncludeReferenceArray;
    }

    public ILibraryReference[] getLibraryReferences() throws CModelException {
        CProjectInfo cProjectInfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(this);
        ILibraryReference[] iLibraryReferenceArray = null;
        if (cProjectInfo != null) {
            iLibraryReferenceArray = cProjectInfo.libReferences;
        }
        if (iLibraryReferenceArray == null) {
            BinaryParserConfig[] binaryParserConfigArray = CModelManager.getDefault().getBinaryParser(this.getProject());
            IPathEntry[] iPathEntryArray = this.getResolvedPathEntries();
            ArrayList<ILibraryReference> arrayList = new ArrayList<ILibraryReference>(iPathEntryArray.length);
            int n = 0;
            while (n < iPathEntryArray.length) {
                ILibraryEntry iLibraryEntry;
                ILibraryReference iLibraryReference;
                if (iPathEntryArray[n].getEntryKind() == 1 && (iLibraryReference = CProject.getLibraryReference(this, binaryParserConfigArray, iLibraryEntry = (ILibraryEntry)iPathEntryArray[n])) != null) {
                    arrayList.add(iLibraryReference);
                }
                ++n;
            }
            iLibraryReferenceArray = arrayList.toArray(new ILibraryReference[0]);
            if (cProjectInfo != null) {
                cProjectInfo.libReferences = iLibraryReferenceArray;
            }
        }
        return iLibraryReferenceArray;
    }

    private static ILibraryReference getLibraryReference(ICProject iCProject, BinaryParserConfig[] binaryParserConfigArray, ILibraryEntry iLibraryEntry) {
        if (binaryParserConfigArray == null) {
            binaryParserConfigArray = CModelManager.getDefault().getBinaryParser(iCProject.getProject());
        }
        Parent parent = null;
        if (binaryParserConfigArray != null) {
            int n = 0;
            while (n < binaryParserConfigArray.length) {
                try {
                    IBinaryParser.IBinaryFile iBinaryFile = binaryParserConfigArray[n].getBinaryParser().getBinary(iLibraryEntry.getFullLibraryPath());
                    if (iBinaryFile != null) {
                        if (iBinaryFile.getType() == 8) {
                            parent = new LibraryReferenceArchive((ICElement)iCProject, iLibraryEntry, (IBinaryParser.IBinaryArchive)iBinaryFile);
                            break;
                        }
                        if (!(iBinaryFile instanceof IBinaryParser.IBinaryObject)) break;
                        parent = new LibraryReferenceShared((ICElement)iCProject, iLibraryEntry, (IBinaryParser.IBinaryObject)iBinaryFile);
                        break;
                    }
                }
                catch (IOException iOException) {}
                ++n;
            }
        }
        if (parent == null) {
            parent = new LibraryReference(iCProject, iLibraryEntry);
        }
        return parent;
    }

    public String[] getRequiredProjectNames() throws CModelException {
        return this.projectPrerequisites(this.getResolvedPathEntries());
    }

    public String[] projectPrerequisites(IPathEntry[] iPathEntryArray) throws CModelException {
        return PathEntryManager.getDefault().projectPrerequisites(iPathEntryArray);
    }

    public String getOption(String string, boolean bl) {
        if (CModelManager.OptionNames.contains(string)) {
            Preferences preferences = this.getPreferences();
            if (preferences == null || preferences.isDefault(string)) {
                return bl ? CCorePlugin.getOption(string) : null;
            }
            return preferences.getString(string).trim();
        }
        return null;
    }

    public Map getOptions(boolean bl) {
        String string;
        int n;
        String[] stringArray;
        HashMap hashMap = bl ? CCorePlugin.getOptions() : new HashMap(5);
        Preferences preferences = this.getPreferences();
        if (preferences == null) {
            return hashMap;
        }
        HashSet hashSet = CModelManager.OptionNames;
        if (bl) {
            stringArray = preferences.defaultPropertyNames();
            n = 0;
            while (n < stringArray.length) {
                string = stringArray[n];
                if (hashSet.contains(string)) {
                    hashMap.put(string, preferences.getDefaultString(string).trim());
                }
                ++n;
            }
        }
        stringArray = preferences.propertyNames();
        n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            if (hashSet.contains(string)) {
                hashMap.put(string, preferences.getString(string).trim());
            }
            ++n;
        }
        return hashMap;
    }

    public void setOption(String string, String string2) {
        if (!CModelManager.OptionNames.contains(string)) {
            return;
        }
        Preferences preferences = this.getPreferences();
        preferences.setDefault(string, CUSTOM_DEFAULT_OPTION_VALUE);
        preferences.setValue(string, string2);
        this.savePreferences(preferences);
    }

    public void setOptions(Map map) {
        Preferences preferences = new Preferences();
        this.setPreferences(preferences);
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!CModelManager.OptionNames.contains(string)) continue;
                String string2 = (String)map.get(string);
                preferences.setDefault(string, CUSTOM_DEFAULT_OPTION_VALUE);
                preferences.setValue(string, string2);
            }
        }
        this.savePreferences(preferences);
    }

    private Preferences getPreferences() {
        if (!this.isCProject()) {
            return null;
        }
        Preferences preferences = new Preferences();
        Iterator iterator = CModelManager.OptionNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = string.substring("org.eclipse.cdt.core".length() + 1);
            String string3 = null;
            try {
                string3 = this.resource.getPersistentProperty(new QualifiedName("org.eclipse.cdt.core", string2));
            }
            catch (CoreException coreException) {}
            if (string3 == null) continue;
            preferences.setValue(string, string3);
        }
        return preferences;
    }

    private void savePreferences(Preferences preferences) {
        if (preferences == null) {
            return;
        }
        if (!this.isCProject()) {
            return;
        }
        Iterator iterator = CModelManager.OptionNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = string.substring("org.eclipse.cdt.core".length() + 1);
            String string3 = null;
            try {
                string3 = preferences.getString(string);
                if (string3 != null && !string3.equals(preferences.getDefaultString(string))) {
                    this.resource.setPersistentProperty(new QualifiedName("org.eclipse.cdt.core", string2), string3);
                    continue;
                }
                this.resource.setPersistentProperty(new QualifiedName("org.eclipse.cdt.core", string2), null);
            }
            catch (CoreException coreException) {}
        }
    }

    private void setPreferences(Preferences preferences) {
        if (!this.isCProject()) {
            return;
        }
    }

    public IPathEntry[] getResolvedPathEntries() throws CModelException {
        return CoreModel.getResolvedPathEntries(this);
    }

    public IPathEntry[] getRawPathEntries() throws CModelException {
        return CoreModel.getRawPathEntries(this);
    }

    public void setRawPathEntries(IPathEntry[] iPathEntryArray, IProgressMonitor iProgressMonitor) throws CModelException {
        CoreModel.setRawPathEntries(this, iPathEntryArray, iProgressMonitor);
    }

    public ISourceRoot getSourceRoot(ISourceEntry iSourceEntry) throws CModelException {
        IPath iPath;
        IPath iPath2 = this.getPath();
        if (iPath2.isPrefixOf(iPath = iSourceEntry.getPath())) {
            int n = iPath.matchingFirstSegments(iPath2);
            iPath = iPath.removeFirstSegments(n);
            Object object = null;
            object = iPath.isEmpty() ? this.getProject() : this.getProject().findMember(iPath);
            if (object != null) {
                return new SourceRoot((ICElement)this, (IResource)object, iSourceEntry);
            }
        }
        return null;
    }

    public ISourceRoot[] getSourceRoots() throws CModelException {
        ICElement[] iCElementArray = this.getChildren();
        int n = iCElementArray.length;
        ISourceRoot[] iSourceRootArray = new ISourceRoot[n];
        System.arraycopy(iCElementArray, 0, iSourceRootArray, 0, n);
        return iSourceRootArray;
    }

    public ISourceRoot[] getAllSourceRoots() throws CModelException {
        CProjectInfo cProjectInfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(this);
        ISourceRoot[] iSourceRootArray = null;
        if (cProjectInfo != null) {
            if (cProjectInfo.sourceRoots != null) {
                iSourceRootArray = cProjectInfo.sourceRoots;
            } else {
                List list = this.computeSourceRoots();
                cProjectInfo.sourceRoots = list.toArray(new ISourceRoot[list.size()]);
                iSourceRootArray = cProjectInfo.sourceRoots;
            }
        } else {
            List list = this.computeSourceRoots();
            iSourceRootArray = list.toArray(new ISourceRoot[list.size()]);
        }
        return iSourceRootArray;
    }

    public IOutputEntry[] getOutputEntries() throws CModelException {
        CProjectInfo cProjectInfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(this);
        IOutputEntry[] iOutputEntryArray = null;
        if (cProjectInfo != null) {
            if (cProjectInfo.outputEntries != null) {
                iOutputEntryArray = cProjectInfo.outputEntries;
            } else {
                IPathEntry[] iPathEntryArray = this.getResolvedPathEntries();
                cProjectInfo.outputEntries = this.getOutputEntries(iPathEntryArray);
                iOutputEntryArray = cProjectInfo.outputEntries;
            }
        } else {
            IPathEntry[] iPathEntryArray = this.getResolvedPathEntries();
            iOutputEntryArray = this.getOutputEntries(iPathEntryArray);
        }
        return iOutputEntryArray;
    }

    public IOutputEntry[] getOutputEntries(IPathEntry[] iPathEntryArray) throws CModelException {
        ArrayList<IPathEntry> arrayList = new ArrayList<IPathEntry>(iPathEntryArray.length);
        int n = 0;
        while (n < iPathEntryArray.length) {
            if (iPathEntryArray[n].getEntryKind() == 7) {
                arrayList.add(iPathEntryArray[n]);
            }
            ++n;
        }
        IOutputEntry[] iOutputEntryArray = new IOutputEntry[arrayList.size()];
        arrayList.toArray(iOutputEntryArray);
        return iOutputEntryArray;
    }

    public boolean isOnOutputEntry(IResource iResource) {
        IPath iPath = iResource.getFullPath();
        if (iResource.getType() == 2 || iResource.getType() == 4) {
            iPath = iPath.append("*");
        }
        try {
            IOutputEntry[] iOutputEntryArray = this.getOutputEntries();
            int n = 0;
            while (n < iOutputEntryArray.length) {
                boolean bl = this.isOnOutputEntry(iOutputEntryArray[n], iPath);
                if (bl) {
                    return bl;
                }
                ++n;
            }
        }
        catch (CModelException cModelException) {}
        return false;
    }

    private boolean isOnOutputEntry(IOutputEntry iOutputEntry, IPath iPath) {
        return iOutputEntry.getPath().isPrefixOf(iPath) && !CoreModelUtil.isExcluded(iPath, iOutputEntry.fullExclusionPatternChars());
    }

    /*
     * Exception decompiling
     */
    protected boolean buildStructure(OpenableInfo var1_1, IProgressMonitor var2_2, Map var3_3, IResource var4_4) throws CModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 68->71)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected List computeSourceRoots() throws CModelException {
        IPathEntry[] iPathEntryArray = this.getResolvedPathEntries();
        ArrayList<ISourceRoot> arrayList = new ArrayList<ISourceRoot>(iPathEntryArray.length);
        int n = 0;
        while (n < iPathEntryArray.length) {
            ISourceEntry iSourceEntry;
            ISourceRoot iSourceRoot;
            if (iPathEntryArray[n].getEntryKind() == 3 && (iSourceRoot = this.getSourceRoot(iSourceEntry = (ISourceEntry)iPathEntryArray[n])) != null) {
                arrayList.add(iSourceRoot);
            }
            ++n;
        }
        return arrayList;
    }

    protected boolean computeSourceRoots(OpenableInfo openableInfo, IResource iResource) throws CModelException {
        openableInfo.setChildren(this.computeSourceRoots());
        if (openableInfo instanceof CProjectInfo) {
            CProjectInfo cProjectInfo = (CProjectInfo)openableInfo;
            cProjectInfo.setNonCResources(null);
        }
        return true;
    }

    public boolean isOnSourceRoot(ICElement iCElement) {
        try {
            ISourceRoot[] iSourceRootArray = this.getSourceRoots();
            int n = 0;
            while (n < iSourceRootArray.length) {
                if (iSourceRootArray[n].isOnSourceEntry(iCElement)) {
                    return true;
                }
                ++n;
            }
        }
        catch (CModelException cModelException) {}
        return false;
    }

    public boolean isOnSourceRoot(IResource iResource) {
        try {
            ISourceRoot[] iSourceRootArray = this.getSourceRoots();
            int n = 0;
            while (n < iSourceRootArray.length) {
                if (iSourceRootArray[n].isOnSourceEntry(iResource)) {
                    return true;
                }
                ++n;
            }
        }
        catch (CModelException cModelException) {}
        return false;
    }

    public boolean exists() {
        if (!this.isCProject()) {
            return false;
        }
        return super.exists();
    }

    public Object[] getNonCResources() throws CModelException {
        return ((CProjectInfo)this.getElementInfo()).getNonCResources(this.getResource());
    }

    protected void closing(Object object) throws CModelException {
        if (object instanceof CProjectInfo) {
            CProjectInfo cProjectInfo = (CProjectInfo)object;
            if (cProjectInfo.vBin != null) {
                cProjectInfo.vBin.close();
            }
            if (cProjectInfo.vLib != null) {
                cProjectInfo.vLib.close();
            }
            cProjectInfo.resetCaches();
            CModelManager.getDefault().removeBinaryRunner(this);
        }
        super.closing(object);
    }

    public void resetCaches() {
        CProjectInfo cProjectInfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(this);
        if (cProjectInfo != null) {
            cProjectInfo.resetCaches();
        }
    }
}

