/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.MultiOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CopyResourceElementsOperation
extends MultiOperation {
    protected ArrayList fCreatedElements;
    protected Map fDeltasPerProject = new HashMap(1);

    public CopyResourceElementsOperation(ICElement[] iCElementArray, ICElement[] iCElementArray2, boolean bl) {
        super(iCElementArray, iCElementArray2, bl);
    }

    private CElementDelta getDeltaFor(ICProject iCProject) {
        CElementDelta cElementDelta = (CElementDelta)this.fDeltasPerProject.get(iCProject);
        if (cElementDelta == null) {
            cElementDelta = new CElementDelta(iCProject);
            this.fDeltasPerProject.put(iCProject, cElementDelta);
        }
        return cElementDelta;
    }

    protected String getMainTaskName() {
        return "operation.copyResourceProgress";
    }

    protected void prepareDeltas(ICElement iCElement, ICElement iCElement2) {
        ICProject iCProject = iCElement2.getCProject();
        if (this.isMove()) {
            ICProject iCProject2 = iCElement.getCProject();
            this.getDeltaFor(iCProject2).movedFrom(iCElement, iCElement2);
            this.getDeltaFor(iCProject).movedTo(iCElement2, iCElement);
        } else {
            this.getDeltaFor(iCProject).added(iCElement2);
        }
    }

    protected void processDeltas() {
        Iterator iterator = this.fDeltasPerProject.values().iterator();
        while (iterator.hasNext()) {
            this.addDelta((ICElementDelta)iterator.next());
        }
    }

    private void processResource(ICElement iCElement, ICElement iCElement2) throws CModelException {
        String string = this.getNewNameFor(iCElement);
        String string2 = string != null ? string : iCElement.getElementName();
        IFile iFile = (IFile)iCElement.getResource();
        IContainer iContainer = (IContainer)iCElement2.getResource();
        IFile iFile2 = iContainer.getFile((IPath)new Path(string2));
        if (!iFile2.equals((Object)iFile)) {
            try {
                if (iFile2.exists()) {
                    if (this.fForce) {
                        this.deleteResource((IResource)iFile2, false);
                    } else {
                        throw new CModelException(new CModelStatus(977));
                    }
                }
                if (this.isMove()) {
                    iFile.move(iFile2.getFullPath(), this.fForce, true, this.getSubProgressMonitor(1));
                } else {
                    iFile.copy(iFile2.getFullPath(), this.fForce, this.getSubProgressMonitor(1));
                }
                this.hasModifiedResource = true;
            }
            catch (CModelException cModelException) {
                throw cModelException;
            }
            catch (CoreException coreException) {
                throw new CModelException(coreException);
            }
            ICElement iCElement3 = CModelManager.getDefault().create(iFile2, null);
            this.prepareDeltas(iCElement, iCElement3);
            this.fCreatedElements.add(iCElement3);
        } else if (!this.fForce) {
            throw new CModelException(new CModelStatus(977));
        }
    }

    protected void processElement(ICElement iCElement) throws CModelException {
        ICElement iCElement2 = this.getDestinationParent(iCElement);
        if (iCElement.getElementType() > 60) {
            throw new CModelException(new CModelStatus(967, iCElement));
        }
        this.processResource(iCElement, iCElement2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processElements() throws CModelException {
        this.fCreatedElements = new ArrayList(this.fElementsToProcess.length);
        try {
            super.processElements();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.fResultElements = new ICElement[this.fCreatedElements.size()];
            this.fCreatedElements.toArray(this.fResultElements);
            this.processDeltas();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.fResultElements = new ICElement[this.fCreatedElements.size()];
        this.fCreatedElements.toArray(this.fResultElements);
        this.processDeltas();
    }

    protected ICModelStatus verify() {
        ICModelStatus iCModelStatus = super.verify();
        if (!iCModelStatus.isOK()) {
            return iCModelStatus;
        }
        if (this.fRenamingsList != null && this.fRenamingsList.length != this.fElementsToProcess.length) {
            return new CModelStatus(980);
        }
        return CModelStatus.VERIFIED_OK;
    }

    protected void verify(ICElement iCElement) throws CModelException {
        if (iCElement == null || !iCElement.exists()) {
            this.error(969, iCElement);
        }
        if (iCElement.isReadOnly() && (this.isRename() || this.isMove())) {
            this.error(976, iCElement);
        }
        CElement cElement = (CElement)this.getDestinationParent(iCElement);
        this.verifyDestination(iCElement, cElement);
        if (this.fRenamings != null) {
            this.verifyRenaming(iCElement);
        }
    }
}

