/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CDescriptorEvent;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorListener;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.resources.IPathEntryStore;
import org.eclipse.cdt.core.resources.IPathEntryStoreListener;
import org.eclipse.cdt.core.resources.PathEntryStoreChangedEvent;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.model.APathEntry;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.PathEntry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultPathEntryStore
implements IPathEntryStore,
ICDescriptorListener {
    static String PATH_ENTRY = "pathentry";
    static String PATH_ENTRY_ID = "org.eclipse.cdt.core.pathentry";
    static String ATTRIBUTE_KIND = "kind";
    static String ATTRIBUTE_PATH = "path";
    static String ATTRIBUTE_BASE_PATH = "base-path";
    static String ATTRIBUTE_BASE_REF = "base-ref";
    static String ATTRIBUTE_EXPORTED = "exported";
    static String ATTRIBUTE_SOURCEPATH = "sourcepath";
    static String ATTRIBUTE_ROOTPATH = "roopath";
    static String ATTRIBUTE_PREFIXMAPPING = "prefixmapping";
    static String ATTRIBUTE_EXCLUDING = "excluding";
    static String ATTRIBUTE_INCLUDE = "include";
    static String ATTRIBUTE_LIBRARY = "library";
    static String ATTRIBUTE_SYSTEM = "system";
    static String ATTRIBUTE_NAME = "name";
    static String ATTRIBUTE_VALUE = "value";
    static String VALUE_TRUE = "true";
    static final IPathEntry[] NO_PATHENTRIES = new IPathEntry[0];
    List listeners;
    IProject fProject;

    public DefaultPathEntryStore(IProject iProject) {
        this.fProject = iProject;
        this.listeners = Collections.synchronizedList(new ArrayList());
        CCorePlugin.getDefault().getCDescriptorManager().addDescriptorListener(this);
    }

    public IPathEntry[] getRawPathEntries() throws CoreException {
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(this.fProject, false);
        if (iCDescriptor != null) {
            ArrayList<IPathEntry> arrayList = new ArrayList<IPathEntry>();
            Element element = iCDescriptor.getProjectData(PATH_ENTRY_ID);
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1 && node.getNodeName().equals(PATH_ENTRY)) {
                    arrayList.add(DefaultPathEntryStore.decodePathEntry(this.fProject, (Element)node));
                }
                ++n;
            }
            IPathEntry[] iPathEntryArray = new IPathEntry[arrayList.size()];
            arrayList.toArray(iPathEntryArray);
            return iPathEntryArray;
        }
        return NO_PATHENTRIES;
    }

    public void setRawPathEntries(IPathEntry[] iPathEntryArray) throws CoreException {
        if (Arrays.equals(iPathEntryArray, this.getRawPathEntries())) {
            return;
        }
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(this.fProject, true);
        Element element = iCDescriptor.getProjectData(PATH_ENTRY_ID);
        Node node = element.getFirstChild();
        while (node != null) {
            element.removeChild(node);
            node = element.getFirstChild();
        }
        if (iPathEntryArray != null && iPathEntryArray.length > 0) {
            Document document = element.getOwnerDocument();
            DefaultPathEntryStore.encodePathEntries(this.fProject.getFullPath(), document, element, iPathEntryArray);
        }
        iCDescriptor.saveProjectData();
    }

    static IPathEntry decodePathEntry(IProject iProject, Element element) throws CModelException {
        Object object;
        boolean bl;
        Path path;
        IPath iPath = iProject.getFullPath();
        String string = element.getAttribute(ATTRIBUTE_KIND);
        int n = PathEntry.kindFromString(string);
        boolean bl2 = false;
        if (element.hasAttribute(ATTRIBUTE_EXPORTED)) {
            bl2 = element.getAttribute(ATTRIBUTE_EXPORTED).equals(VALUE_TRUE);
        }
        if (!(path = element.hasAttribute(ATTRIBUTE_PATH) ? new Path(element.getAttribute(ATTRIBUTE_PATH)) : new Path("")).isAbsolute()) {
            path = iPath.append((IPath)path);
        }
        Path path2 = new Path(element.getAttribute(ATTRIBUTE_BASE_PATH));
        Path path3 = new Path(element.getAttribute(ATTRIBUTE_BASE_REF));
        String string2 = element.getAttribute(ATTRIBUTE_EXCLUDING);
        IPath[] iPathArray = APathEntry.NO_EXCLUSION_PATTERNS;
        if (string2 != null && string2.length() > 0 && (bl = ((Object)(object = (Object)CharOperation.splitOn('|', string2.toCharArray()))).length) > false) {
            iPathArray = new IPath[bl];
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                iPathArray[n2] = new Path(new String((char[])object[n2]));
                ++n2;
            }
        }
        switch (n) {
            case 2: {
                return CoreModel.newProjectEntry((IPath)path, bl2);
            }
            case 1: {
                Path path4;
                object = new Path(element.getAttribute(ATTRIBUTE_LIBRARY));
                Path path5 = element.hasAttribute(ATTRIBUTE_SOURCEPATH) ? new Path(element.getAttribute(ATTRIBUTE_SOURCEPATH)) : null;
                Path path6 = element.hasAttribute(ATTRIBUTE_ROOTPATH) ? new Path(element.getAttribute(ATTRIBUTE_ROOTPATH)) : null;
                Path path7 = path4 = element.hasAttribute(ATTRIBUTE_PREFIXMAPPING) ? new Path(element.getAttribute(ATTRIBUTE_PREFIXMAPPING)) : null;
                if (path3 != null && !path3.isEmpty()) {
                    return CoreModel.newLibraryRefEntry((IPath)path, (IPath)path3, (IPath)object);
                }
                return CoreModel.newLibraryEntry((IPath)path, (IPath)path2, (IPath)object, (IPath)path5, (IPath)path6, (IPath)path4, bl2);
            }
            case 3: {
                object = path.segment(0);
                if (object != null && ((String)object).equals(iProject.getName())) {
                    return CoreModel.newSourceEntry((IPath)path, iPathArray);
                }
                return CoreModel.newProjectEntry((IPath)path, bl2);
            }
            case 7: {
                return CoreModel.newOutputEntry((IPath)path, iPathArray);
            }
            case 4: {
                object = new Path(element.getAttribute(ATTRIBUTE_INCLUDE));
                bl = false;
                if (element.hasAttribute(ATTRIBUTE_SYSTEM)) {
                    bl = element.getAttribute(ATTRIBUTE_SYSTEM).equals(VALUE_TRUE);
                }
                if (path3 != null && !path3.isEmpty()) {
                    return CoreModel.newIncludeRefEntry((IPath)path, (IPath)path3, (IPath)object);
                }
                return CoreModel.newIncludeEntry((IPath)path, (IPath)path2, (IPath)object, bl, iPathArray, bl2);
            }
            case 6: {
                object = element.getAttribute(ATTRIBUTE_NAME);
                String string3 = element.getAttribute(ATTRIBUTE_VALUE);
                if (path3 != null && !path3.isEmpty()) {
                    return CoreModel.newMacroRefEntry((IPath)path, (IPath)path3, (String)object);
                }
                return CoreModel.newMacroEntry((IPath)path, (String)object, string3, iPathArray, bl2);
            }
            case 5: {
                object = new Path(element.getAttribute(ATTRIBUTE_PATH));
                return CoreModel.newContainerEntry((IPath)object, bl2);
            }
        }
        object = new CModelStatus(4, "PathEntry: unknown kind (" + string + ")");
        throw new CModelException((ICModelStatus)object);
    }

    static void encodePathEntries(IPath iPath, Document document, Element element, IPathEntry[] iPathEntryArray) {
        int n = 0;
        while (n < iPathEntryArray.length) {
            IPath iPath2;
            IPath iPath3;
            IPathEntry iPathEntry;
            Element element2 = document.createElement(PATH_ENTRY);
            element.appendChild(element2);
            int n2 = iPathEntryArray[n].getEntryKind();
            element2.setAttribute(ATTRIBUTE_KIND, PathEntry.kindToString(n2));
            IPath iPath4 = iPathEntryArray[n].getPath();
            if (iPath4 == null) {
                iPath4 = new Path("");
            }
            if (n2 != 5 && iPath4.isAbsolute() && iPath != null && iPath.isPrefixOf(iPath4)) {
                if (iPath4.segment(0).equals(iPath.segment(0))) {
                    iPath4 = iPath4.removeFirstSegments(1);
                    iPath4 = iPath4.makeRelative();
                } else {
                    iPath4 = iPath4.makeAbsolute();
                }
            }
            element2.setAttribute(ATTRIBUTE_PATH, iPath4.toString());
            switch (n2) {
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    break;
                }
                case 1: {
                    iPathEntry = (ILibraryEntry)iPathEntryArray[n];
                    iPath3 = iPathEntry.getLibraryPath();
                    element2.setAttribute(ATTRIBUTE_LIBRARY, iPath3.toString());
                    iPath2 = iPathEntry.getSourceAttachmentPath();
                    if (iPath2 != null) {
                        if (iPath != null && iPath.isPrefixOf(iPath2) && iPath2.segment(0).equals(iPath.segment(0))) {
                            iPath2 = iPath2.removeFirstSegments(1);
                            iPath2 = iPath2.makeRelative();
                        }
                        element2.setAttribute(ATTRIBUTE_SOURCEPATH, iPath2.toString());
                    }
                    if (iPathEntry.getSourceAttachmentRootPath() != null) {
                        element2.setAttribute(ATTRIBUTE_ROOTPATH, iPathEntry.getSourceAttachmentRootPath().toString());
                    }
                    if (iPathEntry.getSourceAttachmentPrefixMapping() == null) break;
                    element2.setAttribute(ATTRIBUTE_PREFIXMAPPING, iPathEntry.getSourceAttachmentPrefixMapping().toString());
                    break;
                }
                case 4: {
                    iPathEntry = (IIncludeEntry)iPathEntryArray[n];
                    iPath3 = iPathEntry.getIncludePath();
                    element2.setAttribute(ATTRIBUTE_INCLUDE, iPath3.toString());
                    if (!iPathEntry.isSystemInclude()) break;
                    element2.setAttribute(ATTRIBUTE_SYSTEM, VALUE_TRUE);
                    break;
                }
                case 6: {
                    iPathEntry = (IMacroEntry)iPathEntryArray[n];
                    element2.setAttribute(ATTRIBUTE_NAME, iPathEntry.getMacroName());
                    element2.setAttribute(ATTRIBUTE_VALUE, iPathEntry.getMacroValue());
                }
            }
            if (iPathEntryArray[n] instanceof APathEntry) {
                iPathEntry = (APathEntry)iPathEntryArray[n];
                iPath3 = ((APathEntry)iPathEntry).getBasePath();
                iPath2 = ((APathEntry)iPathEntry).getBaseReference();
                if (iPath3 != null && !iPath3.isEmpty()) {
                    element2.setAttribute(ATTRIBUTE_BASE_PATH, iPath3.toString());
                } else if (iPath2 != null && !iPath2.isEmpty()) {
                    element2.setAttribute(ATTRIBUTE_BASE_REF, iPath2.toString());
                }
                IPath[] iPathArray = ((APathEntry)iPathEntry).getExclusionPatterns();
                if (iPathArray.length > 0) {
                    StringBuffer stringBuffer = new StringBuffer(10);
                    int n3 = 0;
                    int n4 = iPathArray.length;
                    while (n3 < n4) {
                        if (n3 > 0) {
                            stringBuffer.append('|');
                        }
                        stringBuffer.append(iPathArray[n3]);
                        ++n3;
                    }
                    element2.setAttribute(ATTRIBUTE_EXCLUDING, stringBuffer.toString());
                }
            }
            if (iPathEntryArray[n].isExported()) {
                element2.setAttribute(ATTRIBUTE_EXPORTED, VALUE_TRUE);
            }
            ++n;
        }
    }

    public void descriptorChanged(CDescriptorEvent cDescriptorEvent) {
        ICDescriptor iCDescriptor;
        if (cDescriptorEvent.getType() == 1 && (iCDescriptor = cDescriptorEvent.getDescriptor()) != null && iCDescriptor.getProject() == this.fProject) {
            this.fireContentChangedEvent(this.fProject);
        }
    }

    public void addPathEntryStoreListener(IPathEntryStoreListener iPathEntryStoreListener) {
        this.listeners.add(iPathEntryStoreListener);
    }

    public void removePathEntryStoreListener(IPathEntryStoreListener iPathEntryStoreListener) {
        this.listeners.remove(iPathEntryStoreListener);
    }

    private void fireContentChangedEvent(IProject iProject) {
        PathEntryStoreChangedEvent pathEntryStoreChangedEvent = new PathEntryStoreChangedEvent(this, iProject, 1);
        IPathEntryStoreListener[] iPathEntryStoreListenerArray = new IPathEntryStoreListener[this.listeners.size()];
        this.listeners.toArray(iPathEntryStoreListenerArray);
        int n = 0;
        while (n < iPathEntryStoreListenerArray.length) {
            iPathEntryStoreListenerArray[n].pathEntryStoreChanged(pathEntryStoreChangedEvent);
            ++n;
        }
    }

    public void close() {
        PathEntryStoreChangedEvent pathEntryStoreChangedEvent = new PathEntryStoreChangedEvent(this, this.fProject, 2);
        IPathEntryStoreListener[] iPathEntryStoreListenerArray = new IPathEntryStoreListener[this.listeners.size()];
        this.listeners.toArray(iPathEntryStoreListenerArray);
        int n = 0;
        while (n < iPathEntryStoreListenerArray.length) {
            iPathEntryStoreListenerArray[n].pathEntryStoreChanged(pathEntryStoreChangedEvent);
            ++n;
        }
        CCorePlugin.getDefault().getCDescriptorManager().removeDescriptorListener(this);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public ICExtensionReference getExtensionReference() {
        return null;
    }
}

