/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.internal.core.model.CContainerInfo;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;

public class DeltaProcessor {
    protected CElementDelta fCurrentDelta;
    protected IndexManager indexManager = new IndexManager();
    ICElement currentElement;
    static final ICElementDelta[] NO_DELTA = new ICElementDelta[0];
    public static boolean VERBOSE = false;
    ICElement movedFromElement = null;

    protected ICElement createElement(IResource iResource) {
        IResource iResource2;
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (iResource == null) {
            return null;
        }
        CModelManager cModelManager = CModelManager.getDefault();
        boolean bl = true;
        if (!(iResource instanceof IWorkspaceRoot || CoreModel.hasCNature((IProject)(object4 = iResource.getProject())) || CoreModel.hasCCNature((IProject)object4))) {
            bl = false;
            object3 = cModelManager.getCModel();
            object2 = (CModelInfo)cModelManager.peekAtInfo((ICElement)object3);
            if (object2 != null) {
                object = ((CElementInfo)object2).getChildren();
                n = 0;
                while (n < ((ICElement[])object).length) {
                    iResource2 = object[n].getResource();
                    if (object4.equals((Object)iResource2)) {
                        bl = true;
                    }
                    ++n;
                }
            }
        }
        if (!bl) {
            return null;
        }
        object4 = cModelManager.create(iResource, null);
        try {
            if (object4 == null && iResource.getType() == 1 && (object2 = cModelManager.create(iResource.getProject())) != null && object2.isOpen() && (object = object2.getBinaryContainer()).isOpen()) {
                object3 = ((CElement)object).getElementInfo().getChildren();
                n = 0;
                while (n < ((ICElement[])object3).length) {
                    iResource2 = object3[n].getResource();
                    if (iResource.equals((Object)iResource2)) {
                        object4 = object3[n];
                        break;
                    }
                    ++n;
                }
            }
            if (object4 == null && iResource.getType() == 1 && (object2 = cModelManager.create(iResource.getProject())) != null && object2.isOpen() && (object = object2.getArchiveContainer()).isOpen()) {
                object3 = ((CElement)object).getElementInfo().getChildren();
                n = 0;
                while (n < ((ICElement[])object3).length) {
                    iResource2 = object3[n].getResource();
                    if (iResource.equals((Object)iResource2)) {
                        object4 = object3[n];
                        break;
                    }
                    ++n;
                }
            }
            if (object4 != null && iResource.getType() == 1 && ((object3 = object4.getParent()) instanceof IArchiveContainer || object3 instanceof IBinaryContainer)) {
                this.releaseCElement((ICElement)object4);
                object4 = null;
            }
        }
        catch (CModelException cModelException) {
            return null;
        }
        return object4;
    }

    protected void addToParentInfo(Openable openable) throws CModelException {
        CElementInfo cElementInfo;
        Openable openable2 = (Openable)openable.getParent();
        if (openable2 != null && openable2.isOpen() && !(cElementInfo = openable2.getElementInfo()).includesChild(openable)) {
            cElementInfo.addChild(openable);
        }
    }

    private void removeFromParentInfo(ICElement iCElement) throws CModelException {
        CModelManager cModelManager = CModelManager.getDefault();
        ICElement iCElement2 = iCElement.getParent();
        if (iCElement2 != null && iCElement2 instanceof Parent && cModelManager.peekAtInfo(iCElement2) != null) {
            ((Parent)iCElement2).removeChild(iCElement);
        }
    }

    protected void releaseCElement(ICElement iCElement) throws CModelException {
        CModelManager cModelManager = CModelManager.getDefault();
        int n = iCElement.getElementType();
        if (n == 18) {
            ICProject iCProject = iCElement.getCProject();
            IArchiveContainer iArchiveContainer = iCProject.getArchiveContainer();
            this.fCurrentDelta.changed(iArchiveContainer, 4);
        } else if (n == 14) {
            ICProject iCProject = iCElement.getCProject();
            IBinaryContainer iBinaryContainer = iCProject.getBinaryContainer();
            this.fCurrentDelta.changed(iBinaryContainer, 4);
        } else {
            int n2;
            ICElement[] iCElementArray;
            ICProject iCProject = iCElement.getCProject();
            CProjectInfo cProjectInfo = (CProjectInfo)cModelManager.peekAtInfo(iCProject);
            if (cProjectInfo != null && cProjectInfo.vBin != null && cModelManager.peekAtInfo(cProjectInfo.vBin) != null) {
                iCElementArray = cProjectInfo.vBin.getChildren();
                n2 = 0;
                while (n2 < iCElementArray.length) {
                    if (iCElement.getPath().isPrefixOf(iCElementArray[n2].getPath())) {
                        this.fCurrentDelta.changed(cProjectInfo.vBin, 4);
                    }
                    ++n2;
                }
            }
            if (cProjectInfo != null && cProjectInfo.vLib != null && cModelManager.peekAtInfo(cProjectInfo.vLib) != null) {
                iCElementArray = cProjectInfo.vLib.getChildren();
                n2 = 0;
                while (n2 < iCElementArray.length) {
                    if (iCElement.getPath().isPrefixOf(iCElementArray[n2].getPath())) {
                        this.fCurrentDelta.changed(cProjectInfo.vBin, 4);
                    }
                    ++n2;
                }
            }
        }
        this.removeFromParentInfo(iCElement);
        cModelManager.releaseCElement(iCElement);
    }

    protected ICElement createElement(IPath iPath) {
        return CModelManager.getDefault().create(iPath);
    }

    protected void elementAdded(ICElement iCElement, IResourceDelta iResourceDelta) throws CModelException {
        if (iCElement instanceof Openable) {
            this.addToParentInfo((Openable)iCElement);
        }
        if ((iResourceDelta.getFlags() & 0x1000) != 0) {
            if (this.movedFromElement == null) {
                this.movedFromElement = this.createElement(iResourceDelta.getMovedFromPath());
            }
            this.fCurrentDelta.movedTo(iCElement, this.movedFromElement);
            this.movedFromElement = null;
        } else {
            this.fCurrentDelta.added(iCElement);
        }
    }

    protected void elementClosed(ICElement iCElement, IResourceDelta iResourceDelta) throws CModelException {
        if (iCElement.getElementType() == 11) {
            this.elementRemoved(iCElement, iResourceDelta);
            CModelInfo cModelInfo = (CModelInfo)CModelManager.getDefault().getCModel().getElementInfo();
            cModelInfo.setNonCResources(null);
        } else {
            this.fCurrentDelta.closed(iCElement);
        }
    }

    protected void elementOpened(ICElement iCElement, IResourceDelta iResourceDelta) throws CModelException {
        if (iCElement.getElementType() == 11) {
            if (this.hasCNature(iResourceDelta.getResource())) {
                this.elementAdded(iCElement, iResourceDelta);
            }
            CModelInfo cModelInfo = (CModelInfo)CModelManager.getDefault().getCModel().getElementInfo();
            cModelInfo.setNonCResources(null);
        } else {
            this.fCurrentDelta.opened(iCElement);
        }
    }

    private void close(Openable openable) {
        try {
            openable.close();
        }
        catch (CModelException cModelException) {}
    }

    protected void elementChanged(ICElement iCElement, IResourceDelta iResourceDelta) {
        if (iCElement instanceof Openable) {
            this.close((Openable)iCElement);
        }
        this.fCurrentDelta.changed(iCElement, 1);
    }

    protected void elementRemoved(ICElement iCElement, IResourceDelta iResourceDelta) throws CModelException {
        if ((iResourceDelta.getFlags() & 0x2000) != 0) {
            IPath iPath = iResourceDelta.getMovedToPath();
            ICElement iCElement2 = this.createElement(iPath);
            if (iCElement2 == null) {
                this.fCurrentDelta.removed(iCElement);
            } else {
                this.movedFromElement = iCElement;
                this.fCurrentDelta.movedFrom(iCElement, iCElement2);
            }
        } else {
            this.fCurrentDelta.removed(iCElement);
        }
        this.releaseCElement(iCElement);
    }

    protected ICElementDelta[] filterRealDeltas(ICElementDelta[] iCElementDeltaArray) {
        int n = iCElementDeltaArray.length;
        ICElementDelta[] iCElementDeltaArray2 = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            CElementDelta cElementDelta = (CElementDelta)iCElementDeltaArray[n3];
            if (cElementDelta != null && (cElementDelta.getAffectedChildren().length > 0 || cElementDelta.getKind() == 1 || cElementDelta.getKind() == 2 || (cElementDelta.getFlags() & 0x80) != 0 || (cElementDelta.getFlags() & 0x40) != 0 || cElementDelta.resourceDeltasCounter > 0)) {
                if (iCElementDeltaArray2 == null) {
                    iCElementDeltaArray2 = new ICElementDelta[n];
                }
                iCElementDeltaArray2[n2++] = cElementDelta;
            }
            ++n3;
        }
        if (n2 > 0) {
            ICElementDelta[] iCElementDeltaArray3 = new ICElementDelta[n2];
            System.arraycopy(iCElementDeltaArray2, 0, iCElementDeltaArray3, 0, n2);
            return iCElementDeltaArray3;
        }
        return NO_DELTA;
    }

    protected boolean hasCNature(IResource iResource) {
        IProject iProject = iResource.getProject();
        if (iProject.isOpen()) {
            return CoreModel.hasCNature(iProject);
        }
        return false;
    }

    public ICElementDelta[] processResourceDelta(IResourceDelta iResourceDelta) {
        CModel cModel = CModelManager.getDefault().getCModel();
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
        ICElementDelta[] iCElementDeltaArray = new CElementDelta[iResourceDeltaArray.length];
        int n = 0;
        while (n < iResourceDeltaArray.length) {
            IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
            this.fCurrentDelta = new CElementDelta(cModel);
            this.traverseDelta(cModel, iResourceDelta2);
            iCElementDeltaArray[n] = this.fCurrentDelta;
            ++n;
        }
        return this.filterRealDeltas(iCElementDeltaArray);
    }

    protected void traverseDelta(ICElement iCElement, IResourceDelta iResourceDelta) {
        IResourceDelta[] iResourceDeltaArray;
        boolean bl = true;
        try {
            iResourceDeltaArray = iResourceDelta.getResource();
            ICElement iCElement2 = this.createElement((IResource)iResourceDeltaArray);
            bl = this.updateCurrentDeltaAndIndex(iCElement2, iResourceDelta);
            if (iCElement2 == null || iCElement2 instanceof ISourceRoot) {
                this.nonCResourcesChanged(iCElement, iResourceDelta);
            } else if (iCElement2 instanceof ICProject) {
                ICProject iCProject = (ICProject)iCElement2;
                CModel cModel = CModelManager.getDefault().getCModel();
                if (!iCProject.getProject().isOpen() || cModel.findCProject(iCProject.getProject()) == null) {
                    this.nonCResourcesChanged(iCElement, iResourceDelta);
                }
            }
            if (iCElement2 != null) {
                iCElement = iCElement2;
            }
        }
        catch (CModelException cModelException) {}
        if (bl) {
            iResourceDeltaArray = iResourceDelta.getAffectedChildren();
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                this.traverseDelta(iCElement, iResourceDeltaArray[n]);
                ++n;
            }
        }
    }

    protected void nonCResourcesChanged(ICElement iCElement, IResourceDelta iResourceDelta) throws CModelException {
        Object object;
        if (iCElement instanceof Openable && ((Openable)iCElement).isOpen()) {
            object = ((Openable)iCElement).getElementInfo();
            switch (iCElement.getElementType()) {
                case 10: {
                    ((CModelInfo)object).setNonCResources(null);
                    this.fCurrentDelta.addResourceDelta(iResourceDelta);
                    return;
                }
                case 11: {
                    ((CProjectInfo)object).setNonCResources(null);
                    break;
                }
                case 12: {
                    ((CContainerInfo)object).setNonCResources(null);
                }
            }
        }
        if ((object = this.fCurrentDelta.find(iCElement)) == null) {
            this.fCurrentDelta.changed(iCElement, 1);
            object = this.fCurrentDelta.find(iCElement);
            if (object != null) {
                ((CElementDelta)object).addResourceDelta(iResourceDelta);
            }
        } else {
            ((CElementDelta)object).addResourceDelta(iResourceDelta);
        }
    }

    private boolean updateCurrentDeltaAndIndex(ICElement iCElement, IResourceDelta iResourceDelta) throws CModelException {
        IResource iResource = iResourceDelta.getResource();
        switch (iResourceDelta.getKind()) {
            case 1: {
                if (iCElement != null) {
                    this.updateIndexAddResource(iCElement, iResourceDelta);
                    this.elementAdded(iCElement, iResourceDelta);
                }
                return false;
            }
            case 2: {
                if (iCElement != null) {
                    this.updateIndexRemoveResource(iCElement, iResourceDelta);
                    this.elementRemoved(iCElement, iResourceDelta);
                }
                return false;
            }
            case 4: {
                int n = iResourceDelta.getFlags();
                if ((n & 0x100) != 0) {
                    if (iCElement != null) {
                        this.elementChanged(iCElement, iResourceDelta);
                        this.updateIndexAddResource(iCElement, iResourceDelta);
                        this.updateDependencies(iCElement);
                    }
                } else if (iResource.getType() == 4) {
                    IProject iProject;
                    if ((n & 0x4000) != 0) {
                        iProject = (IProject)iResource;
                        if (iCElement != null) {
                            if (iProject.isOpen()) {
                                this.elementOpened(iCElement, iResourceDelta);
                                this.updateIndexAddResource(iCElement, iResourceDelta);
                                return false;
                            }
                            this.elementClosed(iCElement, iResourceDelta);
                            this.updateIndexRemoveResource(iCElement, iResourceDelta);
                            return false;
                        }
                    }
                    if ((n & 0x80000) != 0) {
                        boolean bl;
                        iProject = (IProject)iResourceDelta.getResource();
                        CModel cModel = CModelManager.getDefault().getCModel();
                        boolean bl2 = cModel.findCProject(iProject) != null;
                        if (bl2 != (bl = CProject.hasCNature(iProject)) && iCElement != null) {
                            if (bl) {
                                this.elementAdded(iCElement, iResourceDelta);
                                this.updateIndexAddResource(iCElement, iResourceDelta);
                            } else {
                                this.elementRemoved(iCElement, iResourceDelta);
                                this.updateIndexRemoveResource(iCElement, iResourceDelta);
                            }
                            return true;
                        }
                    }
                }
                return true;
            }
        }
        return true;
    }

    protected void updateIndexAddResource(ICElement iCElement, IResourceDelta iResourceDelta) {
        if (this.indexManager == null) {
            return;
        }
        switch (iCElement.getElementType()) {
            case 11: {
                this.indexManager.indexAll(iCElement.getCProject().getProject());
                break;
            }
            case 12: {
                this.indexManager.indexSourceFolder(iCElement.getCProject().getProject(), iCElement.getPath(), null);
                break;
            }
            case 60: {
                IFile iFile = (IFile)iResourceDelta.getResource();
                IProject iProject = iFile.getProject();
                this.indexManager.addSource(iFile, iProject.getFullPath(), false);
            }
        }
    }

    protected void updateIndexRemoveResource(ICElement iCElement, IResourceDelta iResourceDelta) {
        if (this.indexManager == null) {
            return;
        }
        switch (iCElement.getElementType()) {
            case 11: {
                IPath iPath = iCElement.getCProject().getProject().getFullPath();
                if (iResourceDelta.getKind() == 4) {
                    this.indexManager.discardJobs(iPath.segment(0));
                }
                this.indexManager.removeIndexFamily(iPath);
                break;
            }
            case 12: {
                this.indexManager.removeSourceFolderFromIndex(iCElement.getCProject().getProject(), iCElement.getPath(), null);
                break;
            }
            case 60: {
                IFile iFile = (IFile)iResourceDelta.getResource();
                this.indexManager.remove(iFile.getFullPath().toString(), iFile.getProject().getFullPath());
            }
        }
    }

    private void updateDependencies(ICElement iCElement) {
        IResource iResource = iCElement.getResource();
        if (iResource == null) {
            return;
        }
        String string = iResource.getName();
        if (CoreModel.isValidHeaderUnitName(iResource.getProject(), string)) {
            this.indexManager.updateDependencies(iResource);
        }
    }
}

