/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExternalTranslationUnit
extends TranslationUnit {
    IPath fPath;

    public ExternalTranslationUnit(ICElement iCElement, IPath iPath) {
        super(iCElement, iPath);
        this.fPath = iPath;
    }

    protected IBuffer openBuffer(IProgressMonitor iProgressMonitor) throws CModelException {
        BufferManager bufferManager = this.getBufferManager();
        IBuffer iBuffer = this.getBufferFactory().createBuffer(this);
        if (iBuffer == null) {
            return null;
        }
        if (iBuffer.getCharacters() == null) {
            IPath iPath = this.getPath();
            File file = iPath.toFile();
            if (file != null && file.isFile()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    iBuffer.setContents(Util.getInputStreamAsCharArray(fileInputStream, (int)file.length(), null));
                }
                catch (IOException iOException) {
                    iBuffer.setContents(new char[0]);
                }
            } else {
                iBuffer.setContents(new char[0]);
            }
        }
        bufferManager.addBuffer(iBuffer);
        iBuffer.addBufferChangedListener(this);
        return iBuffer;
    }

    public IPath getPath() {
        return this.fPath;
    }
}

