/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.internal.core.model.APathEntry;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IncludeEntry
extends APathEntry
implements IIncludeEntry {
    IPath includePath;
    boolean isSystemInclude;

    public IncludeEntry(IPath iPath, IPath iPath2, IPath iPath3, IPath iPath4, boolean bl, IPath[] iPathArray, boolean bl2) {
        super(4, iPath2, iPath3, iPath, iPathArray, bl2);
        this.includePath = iPath4 == null ? Path.EMPTY : iPath4;
        this.isSystemInclude = bl;
    }

    public IPath getIncludePath() {
        return this.includePath;
    }

    public boolean isSystemInclude() {
        return this.isSystemInclude;
    }

    public boolean equals(Object object) {
        if (object instanceof IIncludeEntry) {
            IIncludeEntry iIncludeEntry = (IIncludeEntry)object;
            if (!super.equals(iIncludeEntry)) {
                return false;
            }
            if (this.path == null ? iIncludeEntry.getPath() != null : !this.path.toString().equals(iIncludeEntry.getPath().toString())) {
                return false;
            }
            if (this.includePath == null ? iIncludeEntry.getIncludePath() != null : !this.includePath.toString().equals(iIncludeEntry.getIncludePath().toString())) {
                return false;
            }
            return this.isSystemInclude == iIncludeEntry.isSystemInclude();
        }
        return super.equals(object);
    }

    public IPath getFullIncludePath() {
        IPath iPath = this.getIncludePath();
        if (!this.basePath.isEmpty()) {
            IResource iResource;
            IPath iPath2 = this.basePath;
            if (!iPath2.isAbsolute() && (iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath2)) != null) {
                iPath2 = iResource.getLocation();
            }
            IPath iPath3 = iPath2.append(iPath);
            return iPath3;
        }
        IPath iPath4 = iPath;
        if (!iPath4.isAbsolute()) {
            IPath iPath5 = this.getPath();
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath5);
            if (iResource != null) {
                IPath iPath6;
                if (iResource.getType() == 1) {
                    iResource = iResource.getParent();
                }
                if ((iPath6 = iResource.getLocation()) != null) {
                    iPath4 = iPath6.append(iPath4);
                }
            }
        }
        return iPath4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        if (this.isSystemInclude) {
            stringBuffer.append(" isSystemInclude:").append(this.isSystemInclude);
        }
        if (this.includePath != null && !this.includePath.isEmpty()) {
            stringBuffer.append(" includePath:").append(this.includePath);
        }
        return stringBuffer.toString();
    }
}

