/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class IncludeReference
extends Openable
implements IIncludeReference {
    IIncludeEntry fIncludeEntry;
    IPath fPath;

    public IncludeReference(ICProject iCProject, IIncludeEntry iIncludeEntry) {
        this((ICElement)iCProject, iIncludeEntry, iIncludeEntry.getFullIncludePath());
    }

    public IncludeReference(ICElement iCElement, IIncludeEntry iIncludeEntry, IPath iPath) {
        super(iCElement, null, iPath.toString(), 30);
        this.fIncludeEntry = iIncludeEntry;
        this.fPath = iPath;
    }

    public IResource getResource() {
        return null;
    }

    protected CElementInfo createElementInfo() {
        return new OpenableInfo(this);
    }

    public IIncludeEntry getIncludeEntry() {
        return this.fIncludeEntry;
    }

    protected boolean buildStructure(OpenableInfo openableInfo, IProgressMonitor iProgressMonitor, Map map, IResource iResource) throws CModelException {
        return this.computeChildren(openableInfo, iResource);
    }

    public IPath getAffectedPath() {
        return this.fIncludeEntry.getPath();
    }

    protected boolean computeChildren(OpenableInfo openableInfo, IResource iResource) throws CModelException {
        ArrayList<IncludeReference> arrayList = new ArrayList<IncludeReference>();
        File file = null;
        if (this.fPath != null) {
            file = this.fPath.toFile();
        } else if (this.fIncludeEntry != null) {
            file = this.fIncludeEntry.getFullIncludePath().toFile();
        }
        String[] stringArray = null;
        if (file != null && file.isDirectory()) {
            stringArray = file.list();
        }
        if (stringArray != null) {
            Path path = new Path(file.getAbsolutePath());
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                Openable openable = null;
                if (file2.isDirectory()) {
                    openable = new IncludeReference((ICElement)this, this.fIncludeEntry, (IPath)new Path(file2.getAbsolutePath()));
                } else if (CoreModel.isValidTranslationUnitName(this.getCProject().getProject(), stringArray[n]) && file2.isFile()) {
                    openable = new ExternalTranslationUnit((ICElement)this, path.append(stringArray[n]));
                }
                if (openable != null) {
                    arrayList.add((IncludeReference)openable);
                }
                ++n;
            }
        }
        openableInfo.setChildren(arrayList);
        return true;
    }

    public boolean isOnIncludeEntry(IPath iPath) {
        return this.fIncludeEntry.getIncludePath().isPrefixOf(iPath) && !CoreModelUtil.isExcluded(iPath, this.fIncludeEntry.fullExclusionPatternChars());
    }

    public IPath getPath() {
        return this.fPath;
    }
}

