/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.internal.core.model.APathEntry;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LibraryEntry
extends APathEntry
implements ILibraryEntry {
    IPath libraryPath;
    IPath sourceAttachmentPath;
    IPath sourceAttachmentRootPath;
    IPath sourceAttachmentPrefixMapping;

    public LibraryEntry(IPath iPath, IPath iPath2, IPath iPath3, IPath iPath4, IPath iPath5, IPath iPath6, IPath iPath7, boolean bl) {
        super(1, iPath2, iPath3, iPath, APathEntry.NO_EXCLUSION_PATTERNS, bl);
        this.libraryPath = iPath4 == null ? Path.EMPTY : iPath4;
        this.sourceAttachmentPath = iPath5;
        this.sourceAttachmentRootPath = iPath6;
        this.sourceAttachmentPrefixMapping = iPath7;
    }

    public IPath getSourceAttachmentPath() {
        return this.sourceAttachmentPath;
    }

    public IPath getSourceAttachmentRootPath() {
        return this.sourceAttachmentRootPath;
    }

    public IPath getSourceAttachmentPrefixMapping() {
        return this.sourceAttachmentPrefixMapping;
    }

    public boolean equals(Object object) {
        if (object instanceof ILibraryEntry) {
            ILibraryEntry iLibraryEntry = (ILibraryEntry)object;
            if (!super.equals(object)) {
                return false;
            }
            IPath iPath = iLibraryEntry.getLibraryPath();
            if (this.libraryPath == null ? iPath != null : !this.libraryPath.equals((Object)iPath)) {
                return false;
            }
            iPath = iLibraryEntry.getSourceAttachmentPath();
            if (this.sourceAttachmentPath == null ? iPath != null : !this.sourceAttachmentPath.equals((Object)iPath)) {
                return false;
            }
            iPath = iLibraryEntry.getSourceAttachmentRootPath();
            return !(this.sourceAttachmentRootPath == null ? iPath != null : !this.sourceAttachmentRootPath.equals((Object)iPath));
        }
        return super.equals(object);
    }

    public IPath getFullLibraryPath() {
        IPath iPath = this.getLibraryPath();
        if (!this.basePath.isEmpty()) {
            IResource iResource;
            IPath iPath2 = this.basePath;
            if (!iPath2.isAbsolute() && (iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath2)) != null) {
                iPath2 = iResource.getLocation();
            }
            IPath iPath3 = iPath2.append(iPath);
            return iPath3;
        }
        IPath iPath4 = iPath;
        if (!iPath4.isAbsolute()) {
            IPath iPath5 = this.getPath();
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath5);
            if (iResource != null) {
                IPath iPath6;
                if (iResource.getType() == 1) {
                    iResource = iResource.getParent();
                }
                if ((iPath6 = iResource.getLocation()) != null) {
                    iPath4 = iPath6.append(iPath4);
                }
            }
        }
        return iPath4;
    }

    public IPath getLibraryPath() {
        return this.libraryPath;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        if (this.libraryPath != null && !this.libraryPath.isEmpty()) {
            stringBuffer.append(" librarypath:").append(this.libraryPath.toString());
        }
        return stringBuffer.toString();
    }
}

