/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Enumeration;
import java.util.Map;
import org.eclipse.cdt.core.model.BufferChangedEvent;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.IBufferChangedListener;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.SourceRoot;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class Openable
extends Parent
implements IOpenable,
IBufferChangedListener {
    protected IResource resource;

    public Openable(ICElement iCElement, IPath iPath, int n) {
        this(iCElement, (IResource)ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(iPath), iPath.lastSegment(), n);
    }

    public Openable(ICElement iCElement, IResource iResource, int n) {
        this(iCElement, iResource, iResource.getName(), n);
    }

    public Openable(ICElement iCElement, IResource iResource, String string, int n) {
        super(iCElement, string, n);
        this.resource = iResource;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void bufferChanged(BufferChangedEvent bufferChangedEvent) {
        if (bufferChangedEvent.getBuffer().isClosed()) {
            CModelManager.getDefault().getElementsOutOfSynchWithBuffers().remove(this);
            this.getBufferManager().removeBuffer(bufferChangedEvent.getBuffer());
        } else {
            CModelManager.getDefault().getElementsOutOfSynchWithBuffers().put(this, this);
        }
    }

    protected abstract boolean buildStructure(OpenableInfo var1, IProgressMonitor var2, Map var3, IResource var4) throws CModelException;

    protected void closeBuffer() {
        if (!this.hasBuffer()) {
            return;
        }
        IBuffer iBuffer = null;
        iBuffer = this.getBufferManager().getBuffer(this);
        if (iBuffer != null) {
            iBuffer.close();
            iBuffer.removeBufferChangedListener(this);
        }
    }

    protected void closing(Object object) throws CModelException {
        this.closeBuffer();
    }

    public IBuffer getBuffer() throws CModelException {
        if (this.hasBuffer()) {
            IBuffer iBuffer;
            if (!this.isOpen()) {
                this.getElementInfo();
            }
            if ((iBuffer = this.getBufferManager().getBuffer(this)) == null) {
                iBuffer = this.openBuffer(null);
            }
            return iBuffer;
        }
        return null;
    }

    public IBufferFactory getBufferFactory() {
        return this.getBufferManager().getDefaultBufferFactory();
    }

    protected BufferManager getBufferManager() {
        return BufferManager.getDefaultBufferManager();
    }

    protected boolean hasBuffer() {
        return false;
    }

    public boolean hasUnsavedChanges() throws CModelException {
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        IBuffer iBuffer = this.getBuffer();
        if (iBuffer != null && iBuffer.hasUnsavedChanges()) {
            return true;
        }
        if (this.fType == 10 || this.fType == 11) {
            Enumeration enumeration = this.getBufferManager().getOpenBuffers();
            while (enumeration.hasMoreElements()) {
                ICElement iCElement;
                IBuffer iBuffer2 = (IBuffer)enumeration.nextElement();
                if (!iBuffer2.hasUnsavedChanges() || !this.isAncestorOf(iCElement = (ICElement)((Object)iBuffer2.getOwner()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConsistent() throws CModelException {
        return true;
    }

    public boolean isOpen() {
        return CModelManager.getDefault().getInfo(this) != null;
    }

    protected boolean isSourceElement() {
        return false;
    }

    public void makeConsistent(IProgressMonitor iProgressMonitor) throws CModelException {
        this.makeConsistent(iProgressMonitor, false);
    }

    /*
     * Exception decompiling
     */
    public void makeConsistent(IProgressMonitor var1_1, boolean var2_2) throws CModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 140->144)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void open(IProgressMonitor iProgressMonitor) throws CModelException {
        this.getElementInfo(iProgressMonitor);
    }

    protected IBuffer openBuffer(IProgressMonitor iProgressMonitor) throws CModelException {
        return null;
    }

    protected void openParent(Object object, Map map, IProgressMonitor iProgressMonitor) throws CModelException {
        Openable openable = (Openable)this.getOpenableParent();
        if (openable != null && !openable.isOpen()) {
            openable.generateInfos(openable.createElementInfo(), map, iProgressMonitor);
        }
    }

    protected void generateInfos(Object object, Map map, IProgressMonitor iProgressMonitor) throws CModelException {
        if (CModelManager.VERBOSE) {
            System.out.println("OPENING Element (" + Thread.currentThread() + "): " + this);
        }
        this.openParent(object, map, iProgressMonitor);
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return;
        }
        map.put(this, object);
        try {
            OpenableInfo openableInfo = (OpenableInfo)object;
            boolean bl = this.buildStructure(openableInfo, iProgressMonitor, map, this.getResource());
            openableInfo.setIsStructureKnown(bl);
        }
        catch (CModelException cModelException) {
            map.remove(this);
            throw cModelException;
        }
        CModelManager.getDefault().getElementsOutOfSynchWithBuffers().remove(this);
    }

    public void save(IProgressMonitor iProgressMonitor, boolean bl) throws CModelException {
        if (this.isReadOnly() || this.getResource().isReadOnly()) {
            throw new CModelException(new CModelStatus(976, this));
        }
        IBuffer iBuffer = this.getBuffer();
        if (iBuffer != null) {
            iBuffer.save(iProgressMonitor, bl);
            this.makeConsistent(iProgressMonitor);
        }
    }

    public SourceRoot getSourceRoot() {
        ICElement iCElement = this;
        do {
            if (!(iCElement instanceof SourceRoot)) continue;
            return (SourceRoot)iCElement;
        } while ((iCElement = iCElement.getParent()) != null);
        return null;
    }
}

