/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PathEntry
implements IPathEntry {
    protected int entryKind;
    protected boolean isExported;
    protected IPath path;

    public PathEntry(int n, IPath iPath, boolean bl) {
        this.path = iPath == null ? Path.EMPTY : iPath;
        this.entryKind = n;
        this.isExported = bl;
    }

    public IPath getPath() {
        return this.path;
    }

    public int getEntryKind() {
        return this.entryKind;
    }

    public boolean isExported() {
        return this.isExported;
    }

    public boolean equals(Object object) {
        if (object instanceof IPathEntry) {
            IPathEntry iPathEntry = (IPathEntry)object;
            if (!this.path.equals((Object)iPathEntry.getPath())) {
                return false;
            }
            if (this.entryKind != iPathEntry.getEntryKind()) {
                return false;
            }
            return this.isExported == iPathEntry.isExported();
        }
        return super.equals(object);
    }

    static int kindFromString(String string) {
        if (string.equalsIgnoreCase("prj")) {
            return 2;
        }
        if (string.equalsIgnoreCase("src")) {
            return 3;
        }
        if (string.equalsIgnoreCase("lib")) {
            return 1;
        }
        if (string.equalsIgnoreCase("inc")) {
            return 4;
        }
        if (string.equalsIgnoreCase("mac")) {
            return 6;
        }
        if (string.equalsIgnoreCase("con")) {
            return 5;
        }
        if (string.equalsIgnoreCase("out")) {
            return 7;
        }
        return -1;
    }

    static String kindToString(int n) {
        switch (n) {
            case 2: {
                return "prj";
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 4: {
                return "inc";
            }
            case 6: {
                return "mac";
            }
            case 5: {
                return "con";
            }
            case 7: {
                return "out";
            }
        }
        return "unknown";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.path != null && !this.path.isEmpty()) {
            stringBuffer.append(this.path.toString()).append(' ');
        }
        stringBuffer.append('[');
        switch (this.getEntryKind()) {
            case 1: {
                stringBuffer.append("CDT_LIBRARY");
                break;
            }
            case 2: {
                stringBuffer.append("CDT_PROJECT");
                break;
            }
            case 3: {
                stringBuffer.append("CDT_SOURCE");
                break;
            }
            case 7: {
                stringBuffer.append("CDT_OUTPUT");
                break;
            }
            case 4: {
                stringBuffer.append("CDT_INCLUDE");
                break;
            }
            case 6: {
                stringBuffer.append("CDT_MACRO");
                break;
            }
            case 5: {
                stringBuffer.append("CDT_CONTAINER");
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

