/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.model.IProjectEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.PathEntryContainerInitializer;
import org.eclipse.cdt.core.resources.IPathEntryStore;
import org.eclipse.cdt.core.resources.IPathEntryStoreListener;
import org.eclipse.cdt.core.resources.PathEntryStoreChangedEvent;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.DefaultPathEntryStore;
import org.eclipse.cdt.internal.core.model.SetPathEntriesOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class PathEntryManager
implements IPathEntryStoreListener,
IElementChangedListener {
    public static final String PATHENTRY_STORE_ID = "PathEntryStore";
    public static final String PATHENTRY_STORE_UNIQ_ID = "org.eclipse.cdt.core.PathEntryStore";
    static String CONTAINER_INITIALIZER_EXTPOINT_ID = "PathEntryContainerInitializer";
    static final String[] NO_PREREQUISITES = new String[0];
    private static HashMap Containers = new HashMap(5);
    static final IPathEntry[] NO_PATHENTRIES = new IPathEntry[0];
    private Map resolvedMap = new Hashtable();
    private Map storeMap = new HashMap();
    private static PathEntryManager pathEntryManager;

    private PathEntryManager() {
    }

    public static synchronized PathEntryManager getDefault() {
        if (pathEntryManager == null) {
            pathEntryManager = new PathEntryManager();
            CoreModel.getDefault().addElementChangedListener(pathEntryManager);
        }
        return pathEntryManager;
    }

    public IPathEntry[] getResolvedPathEntries(ICProject iCProject) throws CModelException {
        boolean bl = iCProject.getProject().getWorkspace().isTreeLocked();
        return this.getResolvedPathEntries(iCProject, !bl);
    }

    public IPathEntry[] getResolvedPathEntries(ICProject iCProject, boolean bl) throws CModelException {
        IPathEntry[] iPathEntryArray;
        HashSet<Object> hashSet = (HashSet<Object>)this.resolvedMap.get(iCProject);
        if (hashSet == null) {
            IPathEntry iPathEntry;
            IPathEntry[] iPathEntryArray2;
            IPath iPath = iCProject.getPath();
            IPathEntry[] iPathEntryArray3 = this.getRawPathEntries(iCProject);
            hashSet = new HashSet<Object>();
            int n = 0;
            while (n < iPathEntryArray3.length) {
                Object object;
                iPathEntryArray2 = iPathEntryArray3[n];
                if (iPathEntryArray2.getEntryKind() == 5) {
                    IPathEntry[] iPathEntryArray4;
                    iPathEntry = (IContainerEntry)iPathEntryArray2;
                    object = this.getPathEntryContainer((IContainerEntry)iPathEntry, iCProject);
                    if (object != null && (iPathEntryArray4 = object.getPathEntries()) != null) {
                        int n2 = 0;
                        while (n2 < iPathEntryArray4.length) {
                            IPathEntry iPathEntry2 = this.cloneEntry(iPath, iPathEntryArray4[n2]);
                            hashSet.add(iPathEntry2);
                            ++n2;
                        }
                    }
                } else {
                    iPathEntry = this.cloneEntry(iPath, (IPathEntry)iPathEntryArray2);
                    object = this.getExpandedPathEntry(iPathEntry, iCProject);
                    if (object != null) {
                        hashSet.add(object);
                    }
                }
                ++n;
            }
            iPathEntryArray = hashSet.toArray(NO_PATHENTRIES);
            if (bl) {
                final ICProject iCProject2 = iCProject;
                iPathEntryArray2 = hashSet.toArray(NO_PATHENTRIES);
                iPathEntry = new Job("PathEntry Marker Job"){

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        IProject iProject = iCProject2.getProject();
                        PathEntryManager.this.flushPathEntryProblemMarkers(iProject);
                        ICModelStatus iCModelStatus = PathEntryManager.this.validatePathEntry(iCProject2, iPathEntryArray2);
                        if (!iCModelStatus.isOK()) {
                            PathEntryManager.this.createPathEntryProblemMarker(iProject, iCModelStatus);
                        }
                        int n = 0;
                        while (n < iPathEntryArray2.length) {
                            iCModelStatus = PathEntryManager.this.validatePathEntry(iCProject2, iPathEntryArray2[n], true, false);
                            if (!iCModelStatus.isOK()) {
                                PathEntryManager.this.createPathEntryProblemMarker(iProject, iCModelStatus);
                            }
                            ++n;
                        }
                        return CModelStatus.OK_STATUS;
                    }
                };
                iPathEntry.schedule();
            }
            this.resolvedMap.put(iCProject, hashSet);
        } else {
            iPathEntryArray = hashSet.toArray(NO_PATHENTRIES);
        }
        return iPathEntryArray;
    }

    private IPathEntry getExpandedPathEntry(IPathEntry iPathEntry, ICProject iCProject) throws CModelException {
        switch (iPathEntry.getEntryKind()) {
            case 4: {
                IIncludeEntry iIncludeEntry = (IIncludeEntry)iPathEntry;
                IPath iPath = iIncludeEntry.getBaseReference();
                if (iPath == null || iPath.isEmpty()) break;
                IPath iPath2 = iIncludeEntry.getIncludePath();
                if (iPath.isAbsolute()) {
                    ICProject iCProject2;
                    IProject iProject;
                    IResource iResource = iCProject.getCModel().getWorkspace().getRoot().findMember(iPath);
                    if (iResource == null || iResource.getType() != 4 || !CoreModel.hasCNature(iProject = (IProject)iResource) && !CoreModel.hasCCNature(iProject) || (iCProject2 = CoreModel.getDefault().create(iProject)) == null) break;
                    IPathEntry[] iPathEntryArray = this.getResolvedPathEntries(iCProject2);
                    int n = 0;
                    while (n < iPathEntryArray.length) {
                        IIncludeEntry iIncludeEntry2;
                        if (iPathEntryArray[n].getEntryKind() == 4 && (iIncludeEntry2 = (IIncludeEntry)iPathEntryArray[n]).getIncludePath().equals((Object)iPath2)) {
                            IPath iPath3 = iIncludeEntry2.getBasePath();
                            if (!iPath3.isAbsolute() && !iPath2.isAbsolute()) {
                                IResource iResource2;
                                if (!iPath3.isEmpty()) {
                                    iResource2 = iCProject.getCModel().getWorkspace().getRoot().findMember(iPath3);
                                } else {
                                    IPath iPath4 = iIncludeEntry2.getPath();
                                    iResource2 = iCProject.getCModel().getWorkspace().getRoot().findMember(iPath4);
                                }
                                if (iResource2 != null) {
                                    if (iResource2.getType() == 1) {
                                        iResource2 = iResource2.getParent();
                                    }
                                    iPath3 = iResource2.getLocation().append(iPath3);
                                }
                            }
                            return CoreModel.newIncludeEntry(iIncludeEntry.getPath(), iPath3, iPath2);
                        }
                        ++n;
                    }
                } else {
                    IPathEntryContainer iPathEntryContainer = this.getPathEntryContainer(iPath, iCProject);
                    if (iPathEntryContainer == null) break;
                    IPathEntry[] iPathEntryArray = iPathEntryContainer.getPathEntries();
                    int n = 0;
                    while (n < iPathEntryArray.length) {
                        IIncludeEntry iIncludeEntry3;
                        if (iPathEntryArray[n].getEntryKind() == 4 && (iIncludeEntry3 = (IIncludeEntry)iPathEntryArray[n]).getIncludePath().equals((Object)iPath2)) {
                            IPath iPath5 = iIncludeEntry3.getBasePath();
                            return CoreModel.newIncludeEntry(iIncludeEntry.getPath(), iPath5, iPath2);
                        }
                        ++n;
                    }
                }
                break;
            }
            case 6: {
                IMacroEntry iMacroEntry = (IMacroEntry)iPathEntry;
                IPath iPath = iMacroEntry.getBaseReference();
                if (iPath == null || iPath.isEmpty()) break;
                String string = iMacroEntry.getMacroName();
                if (iPath.isAbsolute()) {
                    ICProject iCProject3;
                    IProject iProject;
                    IResource iResource = iCProject.getCModel().getWorkspace().getRoot().findMember(iPath);
                    if (iResource == null || iResource.getType() != 4 || !CoreModel.hasCNature(iProject = (IProject)iResource) && !CoreModel.hasCCNature(iProject) || (iCProject3 = CoreModel.getDefault().create(iProject)) == null) break;
                    IPathEntry[] iPathEntryArray = this.getResolvedPathEntries(iCProject3);
                    int n = 0;
                    while (n < iPathEntryArray.length) {
                        IMacroEntry iMacroEntry2;
                        if (iPathEntryArray[n].getEntryKind() == 6 && (iMacroEntry2 = (IMacroEntry)iPathEntryArray[n]).getMacroName().equals(string)) {
                            String string2 = iMacroEntry2.getMacroValue();
                            return CoreModel.newMacroEntry(iMacroEntry.getPath(), string, string2);
                        }
                        ++n;
                    }
                } else {
                    IPathEntryContainer iPathEntryContainer = this.getPathEntryContainer(iPath, iCProject);
                    if (iPathEntryContainer == null) break;
                    IPathEntry[] iPathEntryArray = iPathEntryContainer.getPathEntries();
                    int n = 0;
                    while (n < iPathEntryArray.length) {
                        IMacroEntry iMacroEntry3;
                        if (iPathEntryArray[n].getEntryKind() == 6 && (iMacroEntry3 = (IMacroEntry)iPathEntryArray[n]).getMacroName().equals(string)) {
                            String string3 = iMacroEntry3.getMacroValue();
                            return CoreModel.newMacroEntry(iMacroEntry.getPath(), string, string3);
                        }
                        ++n;
                    }
                }
                break;
            }
            case 1: {
                ILibraryEntry iLibraryEntry = (ILibraryEntry)iPathEntry;
                IPath iPath = iLibraryEntry.getBaseReference();
                if (iPath == null || iPath.isEmpty()) break;
                IPath iPath6 = iLibraryEntry.getLibraryPath();
                if (iPath.isAbsolute()) {
                    ICProject iCProject4;
                    IProject iProject;
                    IResource iResource = iCProject.getCModel().getWorkspace().getRoot().findMember(iPath);
                    if (iResource == null || iResource.getType() != 4 || !CoreModel.hasCNature(iProject = (IProject)iResource) && !CoreModel.hasCCNature(iProject) || (iCProject4 = CoreModel.getDefault().create(iProject)) == null) break;
                    IPathEntry[] iPathEntryArray = this.getResolvedPathEntries(iCProject4);
                    int n = 0;
                    while (n < iPathEntryArray.length) {
                        ILibraryEntry iLibraryEntry2;
                        if (iPathEntryArray[n].getEntryKind() == 1 && (iLibraryEntry2 = (ILibraryEntry)iPathEntryArray[n]).getLibraryPath().equals((Object)iPath6)) {
                            IPath iPath7 = iLibraryEntry2.getBasePath();
                            if (!iPath7.isAbsolute() && !iPath6.isAbsolute()) {
                                IResource iResource3;
                                if (!iPath7.isEmpty()) {
                                    iResource3 = iCProject.getCModel().getWorkspace().getRoot().findMember(iPath7);
                                } else {
                                    IPath iPath8 = iLibraryEntry2.getPath();
                                    iResource3 = iCProject.getCModel().getWorkspace().getRoot().findMember(iPath8);
                                }
                                if (iResource3 != null) {
                                    if (iResource3.getType() == 1) {
                                        iResource3 = iResource3.getParent();
                                    }
                                    iPath7 = iResource3.getLocation().append(iPath7);
                                }
                            }
                            return CoreModel.newLibraryEntry(iPathEntry.getPath(), iPath7, iLibraryEntry2.getLibraryPath(), iLibraryEntry2.getSourceAttachmentPath(), iLibraryEntry2.getSourceAttachmentRootPath(), iLibraryEntry2.getSourceAttachmentPrefixMapping(), false);
                        }
                        ++n;
                    }
                } else {
                    IPathEntryContainer iPathEntryContainer = this.getPathEntryContainer(iPath, iCProject);
                    if (iPathEntryContainer == null) break;
                    IPathEntry[] iPathEntryArray = iPathEntryContainer.getPathEntries();
                    int n = 0;
                    while (n < iPathEntryArray.length) {
                        ILibraryEntry iLibraryEntry3;
                        if (iPathEntryArray[n].getEntryKind() == 1 && (iLibraryEntry3 = (ILibraryEntry)iPathEntryArray[n]).getPath().equals((Object)iPath6)) {
                            return CoreModel.newLibraryEntry(iPathEntry.getPath(), iLibraryEntry3.getBasePath(), iLibraryEntry3.getLibraryPath(), iLibraryEntry3.getSourceAttachmentPath(), iLibraryEntry3.getSourceAttachmentRootPath(), iLibraryEntry3.getSourceAttachmentPrefixMapping(), false);
                        }
                        ++n;
                    }
                }
                break;
            }
        }
        return iPathEntry;
    }

    public void setRawPathEntries(ICProject iCProject, IPathEntry[] iPathEntryArray, IProgressMonitor iProgressMonitor) throws CModelException {
        try {
            IPathEntry[] iPathEntryArray2 = null;
            Set set = (Set)this.resolvedMap.get(iCProject);
            if (set != null) {
                iPathEntryArray2 = set.toArray(NO_PATHENTRIES);
            }
            SetPathEntriesOperation setPathEntriesOperation = new SetPathEntriesOperation(iCProject, iPathEntryArray2, iPathEntryArray);
            CModelManager.getDefault().runOperation(setPathEntriesOperation, iProgressMonitor);
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
    }

    public IPathEntry[] getRawPathEntries(ICProject iCProject) throws CModelException {
        IPathEntry[] iPathEntryArray;
        IProject iProject = iCProject.getProject();
        if (!CoreModel.hasCNature(iProject) && !CoreModel.hasCCNature(iProject)) {
            throw new CModelException(new CModelStatus(969));
        }
        try {
            IPathEntryStore iPathEntryStore = this.getPathEntryStore(iProject, true);
            iPathEntryArray = iPathEntryStore.getRawPathEntries();
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < iPathEntryArray.length) {
            IPathEntry iPathEntry = iPathEntryArray[n];
            if (iPathEntry.getEntryKind() == 3) {
                bl = true;
            }
            if (iPathEntry.getEntryKind() == 7) {
                bl2 = true;
            }
            ++n;
        }
        if (!bl) {
            IPathEntry[] iPathEntryArray2 = new IPathEntry[iPathEntryArray.length + 1];
            System.arraycopy(iPathEntryArray, 0, iPathEntryArray2, 0, iPathEntryArray.length);
            iPathEntryArray2[iPathEntryArray.length] = CoreModel.newSourceEntry(iCProject.getPath());
            iPathEntryArray = iPathEntryArray2;
        }
        if (!bl2) {
            IPathEntry[] iPathEntryArray3 = new IPathEntry[iPathEntryArray.length + 1];
            System.arraycopy(iPathEntryArray, 0, iPathEntryArray3, 0, iPathEntryArray.length);
            iPathEntryArray3[iPathEntryArray.length] = CoreModel.newOutputEntry(iCProject.getPath());
            iPathEntryArray = iPathEntryArray3;
        }
        return iPathEntryArray;
    }

    public void setPathEntryContainer(ICProject[] iCProjectArray, IPathEntryContainer iPathEntryContainer, IProgressMonitor iProgressMonitor) throws CModelException {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return;
        }
        Path path = iPathEntryContainer == null ? new Path("") : iPathEntryContainer.getPath();
        final int n = iCProjectArray.length;
        final ICProject[] iCProjectArray2 = new ICProject[n];
        System.arraycopy(iCProjectArray, 0, iCProjectArray2, 0, n);
        final IPathEntry[][] iPathEntryArray = new IPathEntry[n][];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                return;
            }
            ICProject iCProject = iCProjectArray[n3];
            boolean bl = false;
            IPathEntry[] iPathEntryArray2 = this.getRawPathEntries(iCProject);
            int n4 = 0;
            int n5 = iPathEntryArray2.length;
            while (n4 < n5) {
                IContainerEntry iContainerEntry;
                IPathEntry iPathEntry = iPathEntryArray2[n4];
                if (iPathEntry.getEntryKind() == 5 && (iContainerEntry = (IContainerEntry)iPathEntry).getPath().equals((Object)path)) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                iCProjectArray2[n3] = null;
                this.containerPut(iCProject, (IPath)path, iPathEntryContainer);
            } else {
                IPathEntryContainer iPathEntryContainer2 = this.containerGet(iCProject, (IPath)path);
                if (iPathEntryContainer2 != null && iPathEntryContainer != null && iPathEntryContainer2.equals(iPathEntryContainer)) {
                    iCProjectArray2[n3] = null;
                } else {
                    ++n2;
                    Set set = (Set)this.resolvedMap.remove(iCProject);
                    iPathEntryArray[n3] = set != null ? set.toArray(NO_PATHENTRIES) : null;
                    this.containerPut(iCProject, (IPath)path, iPathEntryContainer);
                }
            }
            ++n3;
        }
        if (n2 == 0) {
            return;
        }
        try {
            CoreModel.run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    boolean bl = false;
                    CModelManager cModelManager = CModelManager.getDefault();
                    int n3 = 0;
                    while (n3 < n) {
                        IPathEntry[] iPathEntryArray2;
                        ICElementDelta[] iCElementDeltaArray;
                        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                            return;
                        }
                        ICProject iCProject = iCProjectArray2[n3];
                        if (iCProject != null && iPathEntryArray[n3] != null && (iCElementDeltaArray = PathEntryManager.this.generatePathEntryDeltas(iCProject, iPathEntryArray[n3], iPathEntryArray2 = PathEntryManager.this.getResolvedPathEntries(iCProject))).length > 0) {
                            iCProject.close();
                            bl = true;
                            int n2 = 0;
                            while (n2 < iCElementDeltaArray.length) {
                                cModelManager.registerCModelDelta(iCElementDeltaArray[n2]);
                                ++n2;
                            }
                        }
                        ++n3;
                    }
                    if (bl) {
                        cModelManager.fire(1);
                    }
                }
            }, iProgressMonitor);
        }
        catch (CoreException coreException) {}
    }

    public IPathEntryContainer getPathEntryContainer(IContainerEntry iContainerEntry, ICProject iCProject) throws CModelException {
        return this.getPathEntryContainer(iContainerEntry.getPath(), iCProject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IPathEntryContainer getPathEntryContainer(IPath iPath, ICProject iCProject) throws CModelException {
        IPathEntryContainer iPathEntryContainer = this.containerGet(iCProject, iPath);
        if (!(iPathEntryContainer instanceof PathEntryContainerLock)) return iPathEntryContainer;
        boolean bl = false;
        PathEntryContainerLock pathEntryContainerLock = (PathEntryContainerLock)iPathEntryContainer;
        Object object = pathEntryContainerLock;
        synchronized (object) {
            if (!pathEntryContainerLock.isContainerInitialize()) {
                bl = true;
                pathEntryContainerLock.setContainerInitialize(bl);
            } else {
                while (this.containerGet(iCProject, iPath) instanceof PathEntryContainerLock) {
                    try {
                        pathEntryContainerLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (!bl) return this.containerGet(iCProject, iPath);
        object = this.getPathEntryContainerInitializer(iPath.segment(0));
        boolean[] blArray = new boolean[1];
        if (object != null) {
            Platform.run((ISafeRunnable)new ISafeRunnable((PathEntryContainerInitializer)object, iPath, iCProject, blArray){
                private final /* synthetic */ PathEntryContainerInitializer val$initializer;
                private final /* synthetic */ IPath val$containerPath;
                private final /* synthetic */ ICProject val$project;
                private final /* synthetic */ boolean[] val$ok;
                {
                    this.val$initializer = pathEntryContainerInitializer;
                    this.val$containerPath = iPath;
                    this.val$project = iCProject;
                    this.val$ok = blArray;
                }

                public void handleException(Throwable throwable) {
                    Status status = new Status(4, "org.eclipse.cdt.core", 4, "Exception occurred in container initializer: " + this.val$initializer, throwable);
                    CCorePlugin.log((IStatus)status);
                }

                public void run() throws Exception {
                    this.val$initializer.initialize(this.val$containerPath, this.val$project);
                    this.val$ok[0] = true;
                }
            });
        }
        if (blArray[0]) return this.containerGet(iCProject, iPath);
        this.containerPut(iCProject, iPath, null);
        return this.containerGet(iCProject, iPath);
    }

    public PathEntryContainerInitializer getPathEntryContainerInitializer(String string) {
        CCorePlugin cCorePlugin = CCorePlugin.getDefault();
        if (cCorePlugin == null) {
            return null;
        }
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", CONTAINER_INITIALIZER_EXTPOINT_ID);
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    String string2 = iConfigurationElementArray[n2].getAttribute("id");
                    if (string2 != null && string2.equals(string)) {
                        try {
                            Object object = iConfigurationElementArray[n2].createExecutableExtension("class");
                            if (object instanceof PathEntryContainerInitializer) {
                                return (PathEntryContainerInitializer)object;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return null;
    }

    private synchronized IPathEntryContainer containerGet(ICProject iCProject, IPath iPath) {
        IPathEntryContainer iPathEntryContainer;
        HashMap<IPath, IPathEntryContainer> hashMap = (HashMap<IPath, IPathEntryContainer>)Containers.get(iCProject);
        if (hashMap == null) {
            hashMap = new HashMap<IPath, IPathEntryContainer>();
            Containers.put(iCProject, hashMap);
        }
        if ((iPathEntryContainer = (IPathEntryContainer)hashMap.get(iPath)) == null) {
            iPathEntryContainer = new PathEntryContainerLock();
            hashMap.put(iPath, iPathEntryContainer);
        }
        return iPathEntryContainer;
    }

    private synchronized void containerPut(ICProject iCProject, IPath iPath, IPathEntryContainer iPathEntryContainer) {
        IPathEntryContainer iPathEntryContainer2;
        HashMap<IPath, IPathEntryContainer> hashMap = (HashMap<IPath, IPathEntryContainer>)Containers.get(iCProject);
        if (hashMap == null) {
            hashMap = new HashMap<IPath, IPathEntryContainer>();
            Containers.put(iCProject, hashMap);
        }
        if ((iPathEntryContainer2 = hashMap.put(iPath, iPathEntryContainer)) instanceof PathEntryContainerLock) {
            IPathEntryContainer iPathEntryContainer3 = iPathEntryContainer2;
            synchronized (iPathEntryContainer3) {
                iPathEntryContainer2.notifyAll();
            }
        }
    }

    private synchronized void containerRemove(ICProject iCProject) {
        Containers.remove(iCProject);
    }

    public String[] projectPrerequisites(IPathEntry[] iPathEntryArray) throws CModelException {
        if (iPathEntryArray != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            int n2 = iPathEntryArray.length;
            while (n < n2) {
                if (iPathEntryArray[n].getEntryKind() == 2) {
                    IProjectEntry iProjectEntry = (IProjectEntry)iPathEntryArray[n];
                    arrayList.add(iProjectEntry.getPath().lastSegment());
                }
                ++n;
            }
            n = arrayList.size();
            if (n != 0) {
                String[] stringArray = new String[n];
                arrayList.toArray(stringArray);
                return stringArray;
            }
        }
        return NO_PREREQUISITES;
    }

    public void saveRawPathEntries(ICProject iCProject, IPathEntry[] iPathEntryArray) throws CModelException {
        Object object;
        if (iPathEntryArray == null) {
            iPathEntryArray = NO_PATHENTRIES;
        }
        ArrayList<IProject> arrayList = new ArrayList<IProject>(iPathEntryArray.length);
        IPath iPath = iCProject.getPath();
        int n = 0;
        while (n < iPathEntryArray.length) {
            int n2 = iPathEntryArray[n].getEntryKind();
            IPath iPath2 = iPathEntryArray[n].getPath();
            if (iPath2 == null) {
                iPath2 = Path.EMPTY;
            }
            if (n2 != 5 && iPath2.isAbsolute() && iPath != null && iPath.isPrefixOf(iPath2)) {
                if (iPath2.segment(0).equals(iPath.segment(0))) {
                    iPath2 = iPath2.removeFirstSegments(1);
                    iPath2 = iPath2.makeRelative();
                } else {
                    iPath2 = iPath2.makeAbsolute();
                }
            }
            switch (n2) {
                case 4: {
                    IPathEntry iPathEntry = (IIncludeEntry)iPathEntryArray[n];
                    IPath iPath3 = iPathEntry.getBaseReference();
                    if (iPath3 == null || iPath3.isEmpty()) {
                        object = CoreModel.newIncludeEntry(iPath2, iPathEntry.getBasePath(), iPathEntry.getIncludePath(), iPathEntry.isSystemInclude(), iPathEntry.getExclusionPatterns(), iPathEntry.isExported());
                        break;
                    }
                    object = CoreModel.newIncludeRefEntry(iPath2, iPath3, iPathEntry.getIncludePath());
                    break;
                }
                case 1: {
                    IPath iPath4;
                    IPathEntry iPathEntry = (ILibraryEntry)iPathEntryArray[n];
                    IPath iPath3 = iPathEntry.getSourceAttachmentPath();
                    if (iPath3 != null && iPath != null && iPath.isPrefixOf(iPath3) && iPath3.segment(0).equals(iPath.segment(0))) {
                        iPath3 = iPath3.removeFirstSegments(1);
                        iPath3 = iPath3.makeRelative();
                    }
                    if ((iPath4 = iPathEntry.getBaseReference()) == null || iPath4.isEmpty()) {
                        object = CoreModel.newLibraryEntry(iPath2, iPathEntry.getBasePath(), iPathEntry.getLibraryPath(), iPath3, iPathEntry.getSourceAttachmentRootPath(), iPathEntry.getSourceAttachmentPrefixMapping(), iPathEntry.isExported());
                        break;
                    }
                    object = CoreModel.newLibraryRefEntry(iPath2, iPath4, iPathEntry.getLibraryPath());
                    break;
                }
                case 6: {
                    IPathEntry iPathEntry = (IMacroEntry)iPathEntryArray[n];
                    IPath iPath3 = iPathEntry.getBaseReference();
                    if (iPath3 == null || iPath3.isEmpty()) {
                        object = CoreModel.newMacroEntry(iPath2, iPathEntry.getMacroName(), iPathEntry.getMacroValue(), iPathEntry.getExclusionPatterns(), iPathEntry.isExported());
                        break;
                    }
                    object = CoreModel.newMacroRefEntry(iPath2, iPath3, iPathEntry.getMacroName());
                    break;
                }
                case 7: {
                    IPathEntry iPathEntry = (IOutputEntry)iPathEntryArray[n];
                    object = CoreModel.newOutputEntry(iPath2, iPathEntry.getExclusionPatterns());
                    break;
                }
                case 2: {
                    IPathEntry iPathEntry = (IProjectEntry)iPathEntryArray[n];
                    object = CoreModel.newProjectEntry(iPathEntry.getPath(), iPathEntry.isExported());
                    break;
                }
                case 3: {
                    IPathEntry iPathEntry = (ISourceEntry)iPathEntryArray[n];
                    object = CoreModel.newSourceEntry(iPath2, iPathEntry.getExclusionPatterns());
                    break;
                }
                case 5: {
                    object = CoreModel.newContainerEntry(iPathEntryArray[n].getPath(), iPathEntryArray[n].isExported());
                    break;
                }
                default: {
                    object = iPathEntryArray[n];
                }
            }
            arrayList.add((IProject)object);
            ++n;
        }
        try {
            IPathEntry[] iPathEntryArray2 = new IPathEntry[arrayList.size()];
            arrayList.toArray(iPathEntryArray2);
            object = iCProject.getProject();
            IPathEntryStore iPathEntryStore = this.getPathEntryStore((IProject)object, true);
            iPathEntryStore.setRawPathEntries(iPathEntryArray2);
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
    }

    public ICElementDelta[] generatePathEntryDeltas(ICProject iCProject, IPathEntry[] iPathEntryArray, IPathEntry[] iPathEntryArray2) {
        boolean bl;
        ArrayList<ICElementDelta> arrayList = new ArrayList<ICElementDelta>();
        if (iPathEntryArray == null) {
            return new ICElementDelta[0];
        }
        if (iPathEntryArray2 == null) {
            iPathEntryArray2 = NO_PATHENTRIES;
        }
        int n = 0;
        while (n < iPathEntryArray.length) {
            ICElementDelta iCElementDelta;
            bl = false;
            int n2 = 0;
            while (n2 < iPathEntryArray2.length) {
                if (iPathEntryArray[n].equals(iPathEntryArray2[n2])) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl && (iCElementDelta = this.makePathEntryDelta(iCProject, iPathEntryArray[n], true)) != null) {
                arrayList.add(iCElementDelta);
            }
            ++n;
        }
        n = 0;
        while (n < iPathEntryArray2.length) {
            ICElementDelta iCElementDelta;
            bl = false;
            int n3 = 0;
            while (n3 < iPathEntryArray.length) {
                if (iPathEntryArray2[n].equals(iPathEntryArray[n3])) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl && (iCElementDelta = this.makePathEntryDelta(iCProject, iPathEntryArray2[n], false)) != null) {
                arrayList.add(iCElementDelta);
            }
            ++n;
        }
        if (arrayList.size() == 0 && iPathEntryArray.length == iPathEntryArray2.length) {
            n = 0;
            while (n < iPathEntryArray2.length) {
                ICElementDelta iCElementDelta;
                if (!iPathEntryArray2[n].equals(iPathEntryArray[n]) && (iCElementDelta = this.makePathEntryDelta(iCProject, null, false)) != null) {
                    arrayList.add(iCElementDelta);
                }
                ++n;
            }
        }
        ICElementDelta[] iCElementDeltaArray = new ICElementDelta[arrayList.size()];
        arrayList.toArray(iCElementDeltaArray);
        return iCElementDeltaArray;
    }

    protected ICElementDelta makePathEntryDelta(ICProject iCProject, IPathEntry iPathEntry, boolean bl) {
        ICElement iCElement = null;
        int n = 262144;
        if (iPathEntry == null) {
            iCElement = iCProject;
            n = 262144;
        } else {
            int n2 = iPathEntry.getEntryKind();
            switch (n2) {
                case 3: {
                    ISourceEntry iSourceEntry = (ISourceEntry)iPathEntry;
                    IPath iPath = iSourceEntry.getPath();
                    iCElement = CoreModel.getDefault().create(iPath);
                    n = bl ? 512 : 256;
                    break;
                }
                case 1: {
                    iCElement = iCProject;
                    n = bl ? 8192 : 4096;
                    break;
                }
                case 2: {
                    iCElement = iCProject;
                    n = 16384;
                    break;
                }
                case 4: {
                    IIncludeEntry iIncludeEntry = (IIncludeEntry)iPathEntry;
                    IPath iPath = iIncludeEntry.getPath();
                    iCElement = CoreModel.getDefault().create(iPath);
                    n = 2048;
                    break;
                }
                case 6: {
                    IMacroEntry iMacroEntry = (IMacroEntry)iPathEntry;
                    IPath iPath = iMacroEntry.getPath();
                    iCElement = CoreModel.getDefault().create(iPath);
                    n = 1024;
                    break;
                }
            }
        }
        if (iCElement == null) {
            iCElement = iCProject;
        }
        CElementDelta cElementDelta = new CElementDelta(iCProject.getCModel());
        cElementDelta.changed(iCElement, n);
        return cElementDelta;
    }

    static String[] getRegisteredContainerIDs() {
        Object[] objectArray;
        CCorePlugin cCorePlugin = CCorePlugin.getDefault();
        if (cCorePlugin == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(5);
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", CONTAINER_INITIALIZER_EXTPOINT_ID);
        if (iExtensionPoint != null) {
            objectArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < objectArray.length) {
                IConfigurationElement[] iConfigurationElementArray = objectArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    String string = iConfigurationElementArray[n2].getAttribute("id");
                    if (string != null) {
                        arrayList.add(string);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        objectArray = new String[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    public void setPathEntryStore(IProject iProject, IPathEntryStore iPathEntryStore) {
        IPathEntryStore iPathEntryStore2 = null;
        PathEntryManager pathEntryManager = this;
        synchronized (pathEntryManager) {
            iPathEntryStore2 = (IPathEntryStore)this.storeMap.remove(iProject);
            if (iPathEntryStore != null) {
                this.storeMap.put(iProject, iPathEntryStore);
            }
        }
        if (iPathEntryStore2 != null) {
            iPathEntryStore2.removePathEntryStoreListener(this);
            iPathEntryStore2.close();
        }
    }

    public synchronized IPathEntryStore getPathEntryStore(IProject iProject, boolean bl) throws CoreException {
        IPathEntryStore iPathEntryStore = (IPathEntryStore)this.storeMap.get(iProject);
        if (iPathEntryStore == null && bl) {
            iPathEntryStore = this.createPathEntryStore(iProject);
            this.storeMap.put(iProject, iPathEntryStore);
            iPathEntryStore.addPathEntryStoreListener(this);
        }
        return iPathEntryStore;
    }

    public IPathEntryStore createPathEntryStore(IProject iProject) throws CoreException {
        IPathEntryStore iPathEntryStore;
        block7: {
            iPathEntryStore = null;
            if (iProject != null) {
                try {
                    ICExtensionReference[] iCExtensionReferenceArray;
                    ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject, false);
                    if (iCDescriptor == null || (iCExtensionReferenceArray = iCDescriptor.get(PATHENTRY_STORE_UNIQ_ID, true)).length <= 0) break block7;
                    int n = 0;
                    while (n < iCExtensionReferenceArray.length) {
                        try {
                            iPathEntryStore = (IPathEntryStore)iCExtensionReferenceArray[n].createExtension();
                            break;
                        }
                        catch (ClassCastException classCastException) {
                            CCorePlugin.log(classCastException);
                            ++n;
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        if (iPathEntryStore == null) {
            iPathEntryStore = new DefaultPathEntryStore(iProject);
        }
        return iPathEntryStore;
    }

    public void pathEntryStoreChanged(PathEntryStoreChangedEvent pathEntryStoreChangedEvent) {
        IProject iProject = pathEntryStoreChangedEvent.getProject();
        if (iProject == null) {
            return;
        }
        CModelManager cModelManager = CModelManager.getDefault();
        ICProject iCProject = cModelManager.create(iProject);
        if (pathEntryStoreChangedEvent.hasClosed()) {
            this.setPathEntryStore(iProject, null);
            this.containerRemove(iCProject);
        }
        if (iProject.isAccessible()) {
            try {
                IPathEntry[] iPathEntryArray;
                ICElementDelta[] iCElementDeltaArray;
                IPathEntry[] iPathEntryArray2 = null;
                Set set = (Set)this.resolvedMap.remove(iCProject);
                if (set != null) {
                    iPathEntryArray2 = set.toArray(NO_PATHENTRIES);
                }
                if ((iCElementDeltaArray = this.generatePathEntryDeltas(iCProject, iPathEntryArray2, iPathEntryArray = this.getResolvedPathEntries(iCProject))).length > 0) {
                    iCProject.close();
                    int n = 0;
                    while (n < iCElementDeltaArray.length) {
                        cModelManager.registerCModelDelta(iCElementDeltaArray[n]);
                        ++n;
                    }
                    cModelManager.fire(1);
                }
            }
            catch (CModelException cModelException) {
                CCorePlugin.log((Throwable)((Object)cModelException));
            }
        } else {
            this.resolvedMap.remove(iCProject);
            this.containerRemove(iCProject);
        }
    }

    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        try {
            this.processDelta(elementChangedEvent.getDelta());
        }
        catch (CModelException cModelException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processDelta(ICElementDelta iCElementDelta) throws CModelException {
        Object object;
        block9: {
            int n = iCElementDelta.getKind();
            int n2 = iCElementDelta.getFlags();
            ICElement iCElement = iCElementDelta.getElement();
            if ((n2 & 0x80) == 0 && n != 2 || iCElement.getElementType() != 11) break block9;
            object = (ICProject)iCElement;
            IProject iProject = object.getProject();
            IPathEntryStore iPathEntryStore = null;
            try {
                try {
                    iPathEntryStore = this.getPathEntryStore(iProject, false);
                    if (iPathEntryStore != null) {
                        iPathEntryStore.close();
                    }
                }
                catch (CoreException coreException) {
                    throw new CModelException(coreException);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (iPathEntryStore == null) {
                    this.resolvedMap.remove(object);
                    this.containerRemove((ICProject)object);
                }
                throw throwable;
            }
            {
                Object var9_12 = null;
                if (iPathEntryStore != null) break block9;
                this.resolvedMap.remove(object);
            }
            this.containerRemove((ICProject)object);
        }
        object = iCElementDelta.getAffectedChildren();
        int n = 0;
        while (n < ((Object)object).length) {
            this.processDelta((ICElementDelta)object[n]);
            ++n;
        }
        return;
    }

    protected IPathEntry cloneEntry(IPath iPath, IPathEntry iPathEntry) {
        IPath iPath2 = iPathEntry.getPath();
        if (iPath2 == null) {
            iPath2 = Path.EMPTY;
        }
        IPath iPath3 = iPath2.isAbsolute() ? iPath2 : iPath.append(iPath2);
        switch (iPathEntry.getEntryKind()) {
            case 4: {
                IIncludeEntry iIncludeEntry = (IIncludeEntry)iPathEntry;
                return CoreModel.newIncludeEntry(iPath3, iIncludeEntry.getBasePath(), iIncludeEntry.getIncludePath(), iIncludeEntry.isSystemInclude(), iIncludeEntry.getExclusionPatterns(), iIncludeEntry.isExported());
            }
            case 1: {
                ILibraryEntry iLibraryEntry = (ILibraryEntry)iPathEntry;
                return CoreModel.newLibraryEntry(iPath3, iLibraryEntry.getBasePath(), iLibraryEntry.getLibraryPath(), iLibraryEntry.getSourceAttachmentPath(), iLibraryEntry.getSourceAttachmentRootPath(), iLibraryEntry.getSourceAttachmentPrefixMapping(), iLibraryEntry.isExported());
            }
            case 6: {
                IMacroEntry iMacroEntry = (IMacroEntry)iPathEntry;
                return CoreModel.newMacroEntry(iPath3, iMacroEntry.getMacroName(), iMacroEntry.getMacroValue(), iMacroEntry.getExclusionPatterns(), iMacroEntry.isExported());
            }
            case 7: {
                IOutputEntry iOutputEntry = (IOutputEntry)iPathEntry;
                return CoreModel.newOutputEntry(iPath3, iOutputEntry.getExclusionPatterns());
            }
            case 2: {
                IProjectEntry iProjectEntry = (IProjectEntry)iPathEntry;
                return CoreModel.newProjectEntry(iProjectEntry.getPath(), iProjectEntry.isExported());
            }
            case 3: {
                ISourceEntry iSourceEntry = (ISourceEntry)iPathEntry;
                return CoreModel.newSourceEntry(iPath3, iSourceEntry.getExclusionPatterns());
            }
            case 5: {
                return CoreModel.newContainerEntry(iPathEntry.getPath(), iPathEntry.isExported());
            }
        }
        return iPathEntry;
    }

    public ICModelStatus validatePathEntry(ICProject iCProject, IPathEntry[] iPathEntryArray) {
        IPathEntry iPathEntry;
        int n = 0;
        while (n < iPathEntryArray.length) {
            iPathEntry = iPathEntryArray[n];
            if (iPathEntry != null) {
                int n2 = 0;
                while (n2 < iPathEntryArray.length) {
                    IPathEntry iPathEntry2 = iPathEntryArray[n2];
                    if (iPathEntry2 != null && iPathEntry != iPathEntry2 && iPathEntry2.equals(iPathEntry)) {
                        StringBuffer stringBuffer = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.DuplicateEntry"));
                        stringBuffer.append(':').append(iPathEntry.toString());
                        return new CModelStatus(964, stringBuffer.toString());
                    }
                    ++n2;
                }
            }
            ++n;
        }
        n = 0;
        while (n < iPathEntryArray.length) {
            iPathEntry = iPathEntryArray[n];
            if (iPathEntry != null) {
                IPath iPath = iPathEntry.getPath();
                int n3 = iPathEntry.getEntryKind();
                if (n3 == 3) {
                    int n4 = 0;
                    while (n4 < iPathEntryArray.length) {
                        IPathEntry iPathEntry3 = iPathEntryArray[n4];
                        if (iPathEntry3 != null) {
                            int n5 = iPathEntry3.getEntryKind();
                            IPath iPath2 = iPathEntry3.getPath();
                            if (iPathEntry != iPathEntry3 && n5 == 3) {
                                char[][] cArray = ((ISourceEntry)iPathEntry3).fullExclusionPatternChars();
                                if (iPath2.isPrefixOf(iPath) && !iPath2.equals((Object)iPath) && !CoreModelUtil.isExcluded(iPath.append("*"), cArray)) {
                                    String string = iPath.removeFirstSegments(iPath2.segmentCount()).segment(0);
                                    if (CoreModelUtil.isExcluded(iPath, cArray)) {
                                        StringBuffer stringBuffer = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.NestedEntry"));
                                        stringBuffer.append(':').append(iPathEntry.toString());
                                        return new CModelStatus(964, stringBuffer.toString());
                                    }
                                    if (n5 == 3) {
                                        string = String.valueOf(string) + '/';
                                        StringBuffer stringBuffer = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.NestedEntry"));
                                        stringBuffer.append(':').append(iPathEntry.toString());
                                        return new CModelStatus(964, stringBuffer.toString());
                                    }
                                    StringBuffer stringBuffer = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.NestedEntry"));
                                    stringBuffer.append(':').append(iPathEntry.toString());
                                    return new CModelStatus(964, stringBuffer.toString());
                                }
                            }
                        }
                        ++n4;
                    }
                }
            }
            ++n;
        }
        return CModelStatus.VERIFIED_OK;
    }

    public ICModelStatus validatePathEntry(ICProject iCProject, IPathEntry iPathEntry, boolean bl, boolean bl2) {
        IProject iProject = iCProject.getProject();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CCorePlugin.getResourceString("CoreModel.PathEntry.InvalidPathEntry"));
        stringBuffer.append(':').append(iPathEntry.toString());
        String string = stringBuffer.toString();
        switch (iPathEntry.getEntryKind()) {
            case 4: {
                IIncludeEntry iIncludeEntry = (IIncludeEntry)iPathEntry;
                IPath iPath = iIncludeEntry.getPath();
                if (!this.isValidWorkspacePath(iProject, iPath)) {
                    return new CModelStatus(964, string);
                }
                IPath iPath2 = iIncludeEntry.getFullIncludePath();
                if (this.isValidExternalPath(iPath2)) break;
                return new CModelStatus(964, string);
            }
            case 1: {
                IPath iPath;
                ILibraryEntry iLibraryEntry = (ILibraryEntry)iPathEntry;
                IPath iPath3 = iLibraryEntry.getPath();
                if (!this.isValidWorkspacePath(iProject, iPath3)) {
                    return new CModelStatus(964, string);
                }
                if (bl && (iPath = iLibraryEntry.getSourceAttachmentPath()) != null && (!iPath.isAbsolute() ? !this.isValidWorkspacePath(iProject, iPath) : !this.isValidExternalPath(iPath))) {
                    return new CModelStatus(964, string);
                }
                iPath = iLibraryEntry.getFullLibraryPath();
                if (this.isValidExternalPath(iPath)) break;
                return new CModelStatus(964, string);
            }
            case 6: {
                IMacroEntry iMacroEntry = (IMacroEntry)iPathEntry;
                IPath iPath = iMacroEntry.getPath();
                if (this.isValidWorkspacePath(iProject, iPath)) break;
                return new CModelStatus(964, string);
            }
            case 7: {
                IOutputEntry iOutputEntry = (IOutputEntry)iPathEntry;
                IPath iPath = iOutputEntry.getPath();
                if (this.isValidWorkspacePath(iProject, iPath)) break;
                return new CModelStatus(964, string);
            }
            case 2: {
                IProjectEntry iProjectEntry = (IProjectEntry)iPathEntry;
                IPath iPath = iProjectEntry.getPath();
                if (iPath != null && iPath.isAbsolute() && !iPath.isEmpty()) {
                    IProject iProject2 = iProject.getWorkspace().getRoot().getProject(iPath.segment(0));
                    if (!iProject2.exists() || !CoreModel.hasCCNature(iProject2) && !CoreModel.hasCCNature(iProject2)) {
                        return new CModelStatus(964, string);
                    }
                    if (iProject2.isOpen()) break;
                    return new CModelStatus(964, string);
                }
                return new CModelStatus(964, string);
            }
            case 3: {
                ISourceEntry iSourceEntry = (ISourceEntry)iPathEntry;
                IPath iPath = iSourceEntry.getPath();
                if (this.isValidWorkspacePath(iProject, iPath)) break;
                return new CModelStatus(964, string);
            }
            case 5: {
                if (!bl2) break;
                try {
                    IPathEntryContainer iPathEntryContainer = this.getPathEntryContainer((IContainerEntry)iPathEntry, iCProject);
                    IPathEntry[] iPathEntryArray = iPathEntryContainer.getPathEntries();
                    int n = 0;
                    while (n < iPathEntryArray.length) {
                        ICModelStatus iCModelStatus = this.validatePathEntry(iCProject, iPathEntryArray[n], bl, false);
                        if (!iCModelStatus.isOK()) {
                            return iCModelStatus;
                        }
                        ++n;
                    }
                    break;
                }
                catch (CModelException cModelException) {
                    return new CModelStatus(cModelException);
                }
            }
        }
        return CModelStatus.VERIFIED_OK;
    }

    private boolean isValidWorkspacePath(IProject iProject, IPath iPath) {
        if (iPath == null) {
            return false;
        }
        IWorkspaceRoot iWorkspaceRoot = iProject.getWorkspace().getRoot();
        IResource iResource = null;
        iResource = iPath.isAbsolute() ? iWorkspaceRoot.findMember(iPath) : iProject.findMember(iPath);
        return iResource != null && iResource.isAccessible();
    }

    private boolean isValidExternalPath(IPath iPath) {
        File file;
        if (iPath != null && (file = iPath.toFile()) != null) {
            return file.exists();
        }
        return false;
    }

    void createPathEntryProblemMarker(IProject iProject, ICModelStatus iCModelStatus) {
        int n;
        IMarker iMarker = null;
        switch (iCModelStatus.getCode()) {
            case 964: {
                n = 1;
                break;
            }
            case 979: {
                n = 1;
                break;
            }
            default: {
                n = 2;
            }
        }
        try {
            iMarker = iProject.createMarker("org.eclipse.cdt.core.pathentry_problem");
            iMarker.setAttributes(new String[]{"message", "severity", "location", "pathEntryFileFormat"}, new Object[]{iCModelStatus.getString(), new Integer(n), "pathentry", "false"});
        }
        catch (CoreException coreException) {}
    }

    protected void flushPathEntryProblemMarkers(IProject iProject) {
        IWorkspace iWorkspace = iProject.getWorkspace();
        try {
            IMarker[] iMarkerArray;
            if (iProject.isAccessible() && (iMarkerArray = iProject.findMarkers("org.eclipse.cdt.core.pathentry_problem", false, 0)) != null) {
                iWorkspace.deleteMarkers(iMarkerArray);
            }
        }
        catch (CoreException coreException) {}
    }

    private class PathEntryContainerLock
    implements IPathEntryContainer {
        boolean runInitializer;

        PathEntryContainerLock() {
        }

        public boolean isContainerInitialize() {
            return this.runInitializer;
        }

        public void setContainerInitialize(boolean bl) {
            this.runInitializer = bl;
        }

        public IPathEntry[] getPathEntries() {
            return NO_PATHENTRIES;
        }

        public String getDescription() {
            return new String("Lock container");
        }

        public IPath getPath() {
            return Path.EMPTY;
        }
    }
}

