/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;

public class SetPathEntriesOperation
extends CModelOperation {
    static final String[] NO_PREREQUISITES = new String[0];
    IPathEntry[] oldResolvedEntries;
    IPathEntry[] newRawEntries;
    ICProject cproject;

    public SetPathEntriesOperation(ICProject iCProject, IPathEntry[] iPathEntryArray, IPathEntry[] iPathEntryArray2) {
        super(iCProject);
        this.oldResolvedEntries = iPathEntryArray;
        this.newRawEntries = iPathEntryArray2;
        this.cproject = iCProject;
    }

    protected void executeOperation() throws CModelException {
        this.updateProjectReferencesIfNecessary();
        PathEntryManager pathEntryManager = PathEntryManager.getDefault();
        this.hasModifiedResource = true;
        pathEntryManager.saveRawPathEntries(this.cproject, this.newRawEntries);
        this.done();
    }

    protected void updateProjectReferencesIfNecessary() throws CModelException {
        PathEntryManager pathEntryManager = PathEntryManager.getDefault();
        String[] stringArray = pathEntryManager.projectPrerequisites(this.oldResolvedEntries);
        String[] stringArray2 = pathEntryManager.projectPrerequisites(this.newRawEntries);
        try {
            int n;
            HashSet hashSet;
            IProjectDescription iProjectDescription;
            IProject iProject;
            block10: {
                String string;
                iProject = this.cproject.getProject();
                iProjectDescription = iProject.getDescription();
                IProject[] iProjectArray = iProjectDescription.getReferencedProjects();
                HashSet<String> hashSet2 = new HashSet<String>(iProjectArray.length);
                int n2 = 0;
                while (n2 < iProjectArray.length) {
                    String string2 = iProjectArray[n2].getName();
                    hashSet2.add(string2);
                    ++n2;
                }
                hashSet = (HashSet)hashSet2.clone();
                int n3 = 0;
                while (n3 < stringArray.length) {
                    string = stringArray[n3];
                    hashSet.remove(string);
                    ++n3;
                }
                n3 = 0;
                while (n3 < stringArray2.length) {
                    string = stringArray2[n3];
                    hashSet.add(string);
                    ++n3;
                }
                n = hashSet.size();
                if (hashSet2.size() == n) {
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        if (hashSet2.contains(iterator.next())) {
                            continue;
                        }
                        break block10;
                    }
                    return;
                }
            }
            Object[] objectArray = new String[n];
            int n4 = 0;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                objectArray[n4++] = (String)iterator.next();
            }
            Arrays.sort(objectArray);
            IProject[] iProjectArray = new IProject[n];
            IWorkspaceRoot iWorkspaceRoot = iProject.getWorkspace().getRoot();
            int n5 = 0;
            while (n5 < n) {
                iProjectArray[n5] = iWorkspaceRoot.getProject((String)objectArray[n5]);
                ++n5;
            }
            iProjectDescription.setReferencedProjects(iProjectArray);
            iProject.setDescription(iProjectDescription, this.fMonitor);
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
    }
}

