/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.internal.core.model.CContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class SourceRoot
extends CContainer
implements ISourceRoot {
    ISourceEntry sourceEntry;

    public SourceRoot(ICElement iCElement, IResource iResource, ISourceEntry iSourceEntry) {
        super(iCElement, iResource);
        this.sourceEntry = iSourceEntry;
        IPath iPath = this.getPath();
        IPath iPath2 = this.getParent().getPath();
        if (iPath.segmentCount() > iPath2.segmentCount()) {
            IPath iPath3 = iPath.removeFirstSegments(iPath2.segmentCount());
            this.setElementName(iPath3.toString());
        }
    }

    public ISourceEntry getSourceEntry() {
        return this.sourceEntry;
    }

    public boolean isOnSourceEntry(ICElement iCElement) {
        IPath iPath = iCElement.getPath();
        return this.isOnSourceEntry(iPath);
    }

    public boolean isOnSourceEntry(IResource iResource) {
        IPath iPath = iResource.getFullPath();
        return this.isOnSourceEntry(iPath);
    }

    private boolean isOnSourceEntry(IPath iPath) {
        return this.sourceEntry.getPath().isPrefixOf(iPath) && !CoreModelUtil.isExcluded(iPath, this.sourceEntry.fullExclusionPatternChars());
    }
}

