/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelBuilder;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CreateWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.IDebugLogConstants;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;
import org.eclipse.cdt.internal.core.model.TranslationUnitInfo;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class TranslationUnit
extends Openable
implements ITranslationUnit {
    IPath location = null;
    protected IProblemRequestor problemRequestor;
    SourceManipulationInfo sourceManipulationInfo = null;

    public TranslationUnit(ICElement iCElement, IFile iFile) {
        super(iCElement, (IResource)iFile, 60);
    }

    public TranslationUnit(ICElement iCElement, IPath iPath) {
        super(iCElement, iPath, 60);
    }

    public ITranslationUnit getTranslationUnit() {
        return this;
    }

    public IInclude createInclude(String string, ICElement iCElement, IProgressMonitor iProgressMonitor) throws CModelException {
        return null;
    }

    public IUsing createUsing(String string, IProgressMonitor iProgressMonitor) throws CModelException {
        return null;
    }

    public ICElement getElementAtLine(int n) throws CModelException {
        ICElement[] iCElementArray = this.getChildren();
        int n2 = 0;
        while (n2 < iCElementArray.length) {
            ISourceRange iSourceRange = ((ISourceReference)((Object)iCElementArray[n2])).getSourceRange();
            int n3 = iSourceRange.getStartLine();
            int n4 = iSourceRange.getEndLine();
            if (n >= n3 && n <= n4) {
                return iCElementArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public ICElement getElementAtOffset(int n) throws CModelException {
        ICElement iCElement = this.getSourceElementAtOffset(n);
        if (iCElement == this) {
            return null;
        }
        return iCElement;
    }

    public ICElement[] getElementsAtOffset(int n) throws CModelException {
        ICElement[] iCElementArray = this.getSourceElementsAtOffset(n);
        if (iCElementArray.length == 1 && iCElementArray[0] == this) {
            return CElement.NO_ELEMENTS;
        }
        return iCElementArray;
    }

    public ICElement getElement(String string) {
        try {
            ICElement[] iCElementArray = this.getChildren();
            int n = 0;
            while (n < iCElementArray.length) {
                if (string.equals(iCElementArray[n].getElementName())) {
                    return iCElementArray[n];
                }
                ++n;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public IInclude getInclude(String string) {
        try {
            ICElement[] iCElementArray = this.getChildren();
            int n = 0;
            while (n < iCElementArray.length) {
                if (iCElementArray[n].getElementType() == 72 && string.equals(iCElementArray[n].getElementName())) {
                    return (IInclude)iCElementArray[n];
                }
                ++n;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public IInclude[] getIncludes() throws CModelException {
        ICElement[] iCElementArray = this.getChildren();
        ArrayList<ICElement> arrayList = new ArrayList<ICElement>();
        int n = 0;
        while (n < iCElementArray.length) {
            if (iCElementArray[n].getElementType() == 72) {
                arrayList.add(iCElementArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IInclude[0]);
    }

    public IUsing getUsing(String string) {
        try {
            ICElement[] iCElementArray = this.getChildren();
            int n = 0;
            while (n < iCElementArray.length) {
                if (iCElementArray[n].getElementType() == 62 && string.equals(iCElementArray[n].getElementName())) {
                    return (IUsing)iCElementArray[n];
                }
                ++n;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public IUsing[] getUsings() throws CModelException {
        ICElement[] iCElementArray = this.getChildren();
        ArrayList<ICElement> arrayList = new ArrayList<ICElement>();
        int n = 0;
        while (n < iCElementArray.length) {
            if (iCElementArray[n].getElementType() == 62) {
                arrayList.add(iCElementArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IUsing[0]);
    }

    public void setLocation(IPath iPath) {
        this.location = iPath;
    }

    public IPath getLocation() {
        if (this.location == null) {
            IFile iFile = this.getFile();
            if (iFile != null) {
                this.location = iFile.getLocation();
            } else {
                return this.getPath();
            }
        }
        return this.location;
    }

    protected IFile getFile() {
        IResource iResource = this.getResource();
        if (iResource instanceof IFile) {
            return (IFile)iResource;
        }
        return null;
    }

    public void copy(ICElement iCElement, ICElement iCElement2, String string, boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        this.getSourceManipulationInfo().copy(iCElement, iCElement2, string, bl, iProgressMonitor);
    }

    public void delete(boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        this.getSourceManipulationInfo().delete(bl, iProgressMonitor);
    }

    public void move(ICElement iCElement, ICElement iCElement2, String string, boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        this.getSourceManipulationInfo().move(iCElement, iCElement2, string, bl, iProgressMonitor);
    }

    public void rename(String string, boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        this.getSourceManipulationInfo().rename(string, bl, iProgressMonitor);
    }

    public String getSource() throws CModelException {
        return this.getSourceManipulationInfo().getSource();
    }

    public ISourceRange getSourceRange() throws CModelException {
        return this.getSourceManipulationInfo().getSourceRange();
    }

    protected TranslationUnitInfo getTranslationUnitInfo() throws CModelException {
        return (TranslationUnitInfo)this.getElementInfo();
    }

    protected SourceManipulationInfo getSourceManipulationInfo() {
        if (this.sourceManipulationInfo == null) {
            this.sourceManipulationInfo = new SourceManipulationInfo(this);
        }
        return this.sourceManipulationInfo;
    }

    protected CElementInfo createElementInfo() {
        return new TranslationUnitInfo(this);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ITranslationUnit)) {
            return false;
        }
        return super.equals(object) && !((ITranslationUnit)object).isWorkingCopy();
    }

    public IWorkingCopy findSharedWorkingCopy(IBufferFactory iBufferFactory) {
        Map map;
        Map map2;
        if (iBufferFactory == null) {
            iBufferFactory = BufferManager.getDefaultBufferManager();
        }
        if ((map2 = (Map)(map = CModelManager.getDefault().sharedWorkingCopies).get(iBufferFactory)) == null) {
            return null;
        }
        return (WorkingCopy)map2.get(this);
    }

    private void getNewElements(Map map, CElement cElement) {
        CElementInfo cElementInfo = null;
        try {
            cElementInfo = cElement.getElementInfo();
        }
        catch (CModelException cModelException) {}
        if (cElementInfo != null && cElement instanceof IParent) {
            ICElement[] iCElementArray = cElementInfo.getChildren();
            int n = iCElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                CElement cElement2 = (CElement)iCElementArray[n2];
                this.getNewElements(map, cElement2);
                ++n2;
            }
        }
        map.put(cElement, cElementInfo);
    }

    protected boolean buildStructure(OpenableInfo openableInfo, IProgressMonitor iProgressMonitor, Map map, IResource iResource) throws CModelException {
        ITranslationUnit iTranslationUnit;
        IResource iResource2;
        TranslationUnitInfo translationUnitInfo = (TranslationUnitInfo)openableInfo;
        CModelManager.getDefault().removeChildrenInfo(this);
        this.parse(map);
        if (this.isWorkingCopy() && (iResource2 = (iTranslationUnit = ((IWorkingCopy)((Object)this)).getOriginalElement()).getResource()) != null && iResource2 instanceof IFile) {
            translationUnitInfo.fTimestamp = ((IFile)iResource2).getModificationStamp();
        }
        return translationUnitInfo.isStructureKnown();
    }

    public char[] getContents() {
        try {
            IBuffer iBuffer = this.getBuffer();
            return iBuffer == null ? null : iBuffer.getCharacters();
        }
        catch (CModelException cModelException) {
            return new char[0];
        }
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor iProgressMonitor, IBufferFactory iBufferFactory) throws CModelException {
        return this.getSharedWorkingCopy(iProgressMonitor, iBufferFactory, null);
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor iProgressMonitor, IBufferFactory iBufferFactory, IProblemRequestor iProblemRequestor) throws CModelException {
        WorkingCopy workingCopy;
        if (iBufferFactory == null) {
            iBufferFactory = BufferManager.getDefaultBufferManager();
        }
        CModelManager cModelManager = CModelManager.getDefault();
        Map map = cModelManager.sharedWorkingCopies;
        HashMap hashMap = (HashMap)map.get(iBufferFactory);
        if (hashMap == null) {
            hashMap = new HashMap();
            map.put(iBufferFactory, hashMap);
        }
        if ((workingCopy = (WorkingCopy)hashMap.get(this)) != null) {
            ++workingCopy.useCount;
            return workingCopy;
        }
        CreateWorkingCopyOperation createWorkingCopyOperation = new CreateWorkingCopyOperation(this, hashMap, iBufferFactory, iProblemRequestor);
        this.runOperation(createWorkingCopyOperation, iProgressMonitor);
        return (IWorkingCopy)createWorkingCopyOperation.getResultElements()[0];
    }

    public IWorkingCopy getWorkingCopy() throws CModelException {
        return this.getWorkingCopy(null, null);
    }

    public IWorkingCopy getWorkingCopy(IProgressMonitor iProgressMonitor, IBufferFactory iBufferFactory) throws CModelException {
        WorkingCopy workingCopy = new WorkingCopy(this.getParent(), this.getFile(), iBufferFactory);
        workingCopy.open(iProgressMonitor);
        return workingCopy;
    }

    protected boolean hasBuffer() {
        return true;
    }

    protected void openParent(Object object, Map map, IProgressMonitor iProgressMonitor) throws CModelException {
        block2: {
            try {
                super.openParent(object, map, iProgressMonitor);
            }
            catch (CModelException cModelException) {
                if (this.isWorkingCopy()) break block2;
                throw cModelException;
            }
        }
    }

    public boolean isConsistent() throws CModelException {
        return CModelManager.getDefault().getElementsOutOfSynchWithBuffers().get(this) == null;
    }

    protected boolean isSourceElement() {
        return true;
    }

    public boolean isWorkingCopy() {
        return false;
    }

    protected IBuffer openBuffer(IProgressMonitor iProgressMonitor) throws CModelException {
        IResource iResource;
        BufferManager bufferManager = this.getBufferManager();
        IBuffer iBuffer = this.getBufferFactory().createBuffer(this);
        if (iBuffer == null) {
            return null;
        }
        if (iBuffer.getCharacters() == null && (iResource = this.getResource()) != null && iResource.getType() == 1) {
            iBuffer.setContents(Util.getResourceContentsAsCharArray((IFile)iResource));
        }
        bufferManager.addBuffer(iBuffer);
        iBuffer.addBufferChangedListener(this);
        return iBuffer;
    }

    public Map parse() {
        HashMap hashMap = new HashMap();
        try {
            this.getNewElements(hashMap, this);
        }
        catch (Exception exception) {}
        return hashMap;
    }

    private void parse(Map map) {
        try {
            CModelBuilder cModelBuilder = new CModelBuilder(this, map);
            boolean bl = !CCorePlugin.getDefault().useStructuralParseMode();
            cModelBuilder.parse(bl);
        }
        catch (Exception exception) {
            Util.debugLog("Exception in CModelBuilder", IDebugLogConstants.MODEL);
        }
    }

    public IProblemRequestor getProblemRequestor() {
        return this.problemRequestor;
    }

    public boolean isHeaderUnit() {
        IProject iProject = this.getCProject().getProject();
        return CoreModel.isValidHeaderUnitName(iProject, this.getPath().lastSegment());
    }

    public boolean isSourceUnit() {
        IProject iProject = this.getCProject().getProject();
        return CoreModel.isValidSourceUnitName(iProject, this.getPath().lastSegment());
    }

    public boolean isCLanguage() {
        IProject iProject = this.getCProject().getProject();
        ICFileType iCFileType = CCorePlugin.getDefault().getFileType(iProject, this.getPath().lastSegment());
        String string = iCFileType.getLanguage().getId();
        return string != null && string.equals("org.eclipse.cdt.core.language.c");
    }

    public boolean isCXXLanguage() {
        IProject iProject = this.getCProject().getProject();
        ICFileType iCFileType = CCorePlugin.getDefault().getFileType(iProject, this.getPath().lastSegment());
        String string = iCFileType.getLanguage().getId();
        return string != null && string.equals("org.eclipse.cdt.core.language.cxx");
    }

    public boolean isASMLanguage() {
        IProject iProject = this.getCProject().getProject();
        ICFileType iCFileType = CCorePlugin.getDefault().getFileType(iProject, this.getPath().lastSegment());
        String string = iCFileType.getLanguage().getId();
        return string != null && string.equals("org.eclipse.cdt.core.language.asm");
    }

    public boolean exists() {
        IResource iResource = this.getResource();
        if (iResource != null) {
            return iResource.exists();
        }
        return super.exists();
    }
}

