/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.core.model.IDebugLogConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Util
implements ICLogConstants {
    public static boolean VERBOSE_PARSER = false;
    public static boolean VERBOSE_SCANNER = false;
    public static boolean VERBOSE_MODEL = false;

    private Util() {
    }

    public static StringBuffer getContent(IFile iFile) throws IOException {
        StringBuffer stringBuffer;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(iFile.getContents(true));
        }
        catch (CoreException coreException) {
            throw new IOException(coreException.getMessage());
        }
        try {
            char[] cArray = Util.getInputStreamAsCharArray(bufferedInputStream, -1, null);
            stringBuffer = new StringBuffer(cArray.length).append(cArray);
            Object var3_5 = null;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            try {
                if (bufferedInputStream != null) {
                    ((InputStream)bufferedInputStream).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (IOException iOException) {}
        return stringBuffer;
    }

    public static char[] getInputStreamAsCharArray(InputStream inputStream, int n, String string) throws IOException {
        char[] cArray;
        InputStreamReader inputStreamReader = null;
        InputStreamReader inputStreamReader2 = inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        if (n == -1) {
            cArray = new char[]{};
            int n2 = 0;
            int n3 = -1;
            do {
                int n4;
                if (n2 + (n4 = inputStream.available()) > cArray.length) {
                    char[] cArray2 = cArray;
                    cArray = new char[n2 + n4];
                    System.arraycopy(cArray2, 0, cArray, 0, n2);
                }
                if ((n3 = inputStreamReader.read(cArray, n2, n4)) <= 0) continue;
                n2 += n3;
            } while (n3 > 0);
            if (n2 < cArray.length) {
                char[] cArray3 = cArray;
                cArray = new char[n2];
                System.arraycopy(cArray3, 0, cArray, 0, n2);
            }
        } else {
            cArray = new char[n];
            int n5 = 0;
            int n6 = 0;
            while (n6 != -1 && n5 != n) {
                n6 = inputStreamReader.read(cArray, n5 += n6, n - n5);
            }
            if (n5 != n) {
                char[] cArray4 = cArray;
                cArray = new char[n5];
                System.arraycopy(cArray4, 0, cArray, 0, n5);
            }
        }
        return cArray;
    }

    public static void save(StringBuffer stringBuffer, IFile iFile) throws CoreException {
        byte[] byArray = stringBuffer.toString().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        boolean bl = true;
        iFile.setContents((InputStream)byteArrayInputStream, bl, true, null);
    }

    public static char[] getResourceContentsAsCharArray(IFile iFile) throws CModelException {
        return Util.getResourceContentsAsCharArray(iFile, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getResourceContentsAsCharArray(IFile iFile, String string) throws CModelException {
        char[] cArray;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(iFile.getContents(true));
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException, 969);
        }
        try {
            try {
                cArray = Util.getInputStreamAsCharArray(bufferedInputStream, -1, string);
                Object var4_6 = null;
            }
            catch (IOException iOException) {
                throw new CModelException(iOException, 985);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                ((InputStream)bufferedInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)bufferedInputStream).close();
        return cArray;
    }

    public static void log(Throwable throwable, String string, ICLogConstants.LogConst logConst) {
        Status status = new Status(4, "org.eclipse.cdt.core", 4, string, throwable);
        Util.log((IStatus)status, logConst);
    }

    public static void log(IStatus iStatus, ICLogConstants.LogConst logConst) {
        if (logConst.equals(ICLogConstants.PDE)) {
            CCorePlugin.getDefault().getLog().log(iStatus);
        } else if (logConst.equals(ICLogConstants.CDT)) {
            CCorePlugin.getDefault().cdtLog.log(iStatus);
        }
    }

    public static void log(String string, ICLogConstants.LogConst logConst) {
        Status status = new Status(1, "org.eclipse.cdt.core", 1, string, null);
        Util.log((IStatus)status, logConst);
    }

    public static void debugLog(String string, IDebugLogConstants.DebugLogConstant debugLogConstant) {
        Util.debugLog(string, debugLogConstant, true);
    }

    public static void debugLog(String string, IDebugLogConstants.DebugLogConstant debugLogConstant, boolean bl) {
        if (CCorePlugin.getDefault() == null) {
            return;
        }
        if (CCorePlugin.getDefault().isDebugging() && Util.isActive(debugLogConstant)) {
            if (bl) {
                string = MessageFormat.format("[{0}] {1}", new Long(System.currentTimeMillis()), string);
            }
            while (string.length() > 100) {
                String string2 = string.substring(0, 100);
                string = string.substring(100);
                System.out.println(String.valueOf(string2) + "\\");
            }
            if (string.endsWith("\n")) {
                System.err.print(string);
            } else {
                System.out.println(string);
            }
        }
    }

    public static boolean isActive(IDebugLogConstants.DebugLogConstant debugLogConstant) {
        if (debugLogConstant.equals(IDebugLogConstants.PARSER)) {
            return VERBOSE_PARSER;
        }
        if (debugLogConstant.equals(IDebugLogConstants.SCANNER)) {
            return VERBOSE_SCANNER;
        }
        if (debugLogConstant.equals(IDebugLogConstants.MODEL)) {
            return VERBOSE_MODEL;
        }
        return false;
    }

    public static void setDebugging(boolean bl) {
        CCorePlugin.getDefault().setDebugging(bl);
    }

    public static int combineHashCodes(int n, int n2) {
        return n * 17 + n2;
    }

    public static boolean equalArraysOrNull(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray.length;
        if (n != objectArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2] == null ? objectArray2[n2] != null : !objectArray[n2].equals(objectArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean equalArraysOrNull(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        int n = nArray.length;
        if (n != nArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != nArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean equalOrNull(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }
}

