/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CommitWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.DestroyWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.ReconcileWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.TranslationUnitInfo;
import org.eclipse.cdt.internal.core.model.WorkingCopyInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkingCopy
extends TranslationUnit
implements IWorkingCopy {
    protected IBufferFactory bufferFactory;
    protected int useCount = 1;

    public WorkingCopy(ICElement iCElement, IFile iFile, IBufferFactory iBufferFactory) {
        this(iCElement, iFile, iBufferFactory, null);
    }

    public WorkingCopy(ICElement iCElement, IFile iFile, IBufferFactory iBufferFactory, IProblemRequestor iProblemRequestor) {
        super(iCElement, iFile);
        this.bufferFactory = iBufferFactory == null ? this.getBufferManager() : iBufferFactory;
        this.problemRequestor = iProblemRequestor;
    }

    public WorkingCopy(ICElement iCElement, IPath iPath, IBufferFactory iBufferFactory) {
        super(iCElement, iPath);
        this.bufferFactory = iBufferFactory == null ? this.getBufferManager() : iBufferFactory;
    }

    public void commit(boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        ITranslationUnit iTranslationUnit = this.getOriginalElement();
        if (iTranslationUnit.exists()) {
            CommitWorkingCopyOperation commitWorkingCopyOperation = new CommitWorkingCopyOperation(this, bl);
            this.runOperation(commitWorkingCopyOperation, iProgressMonitor);
        } else {
            String string = this.getSource();
            if (string == null) {
                return;
            }
            try {
                IFile iFile = (IFile)iTranslationUnit.getResource();
                String string2 = null;
                try {
                    string2 = iFile.getCharset();
                }
                catch (CoreException coreException) {}
                byte[] byArray = string2 == null ? string.getBytes() : string.getBytes(string2);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                if (iFile.exists()) {
                    iFile.setContents((InputStream)byteArrayInputStream, bl ? 3 : 2, null);
                } else {
                    iFile.create((InputStream)byteArrayInputStream, bl, iProgressMonitor);
                }
            }
            catch (IOException iOException) {
                throw new CModelException(iOException, 985);
            }
            catch (CoreException coreException) {
                throw new CModelException(coreException);
            }
        }
    }

    protected CElementInfo createElementInfo() {
        return new WorkingCopyInfo(this);
    }

    public void destroy() {
        if (--this.useCount > 0) {
            return;
        }
        try {
            DestroyWorkingCopyOperation destroyWorkingCopyOperation = new DestroyWorkingCopyOperation(this);
            this.runOperation(destroyWorkingCopyOperation, null);
        }
        catch (CModelException cModelException) {}
    }

    public boolean exists() {
        return this.useCount != 0;
    }

    public IBufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public ITranslationUnit getOriginalElement() {
        return new TranslationUnit(this.getParent(), this.getFile());
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor iProgressMonitor, IBufferFactory iBufferFactory) throws CModelException {
        return this;
    }

    public IWorkingCopy getWorkingCopy() {
        return this;
    }

    public IWorkingCopy getWorkingCopy(IProgressMonitor iProgressMonitor, IBufferFactory iBufferFactory) {
        return this;
    }

    public boolean isBasedOn(IResource iResource) {
        if (iResource.getType() != 1) {
            return false;
        }
        if (this.useCount == 0) {
            return false;
        }
        try {
            return ((TranslationUnitInfo)this.getElementInfo()).fTimestamp == ((IFile)iResource).getModificationStamp();
        }
        catch (CModelException cModelException) {
            return false;
        }
    }

    public boolean isWorkingCopy() {
        return true;
    }

    public void open(IProgressMonitor iProgressMonitor) throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        super.open(iProgressMonitor);
    }

    protected IBuffer openBuffer(IProgressMonitor iProgressMonitor) throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        IBuffer iBuffer = this.getBufferFactory().createBuffer(this);
        if (iBuffer == null) {
            return null;
        }
        if (iBuffer.getCharacters() == null) {
            IBuffer iBuffer2;
            block8: {
                ITranslationUnit iTranslationUnit = this.getOriginalElement();
                iBuffer2 = null;
                try {
                    iBuffer2 = iTranslationUnit.getBuffer();
                }
                catch (CModelException cModelException) {
                    if (cModelException.getCModelStatus().doesNotExist()) break block8;
                    throw cModelException;
                }
            }
            if (iBuffer2 != null) {
                char[] cArray = iBuffer2.getCharacters();
                if (cArray != null) {
                    iBuffer.setContents((char[])cArray.clone());
                }
            } else {
                iBuffer.setContents(new char[0]);
            }
        }
        this.getBufferManager().addBuffer(iBuffer);
        iBuffer.addBufferChangedListener(this);
        return iBuffer;
    }

    public IMarker[] reconcile() throws CModelException {
        this.reconcile(false, null);
        return null;
    }

    public void reconcile(boolean bl, IProgressMonitor iProgressMonitor) throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        ReconcileWorkingCopyOperation reconcileWorkingCopyOperation = new ReconcileWorkingCopyOperation(this, bl);
        this.runOperation(reconcileWorkingCopyOperation, iProgressMonitor);
    }

    public void restore() throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        TranslationUnit translationUnit = (TranslationUnit)this.getOriginalElement();
        IBuffer iBuffer = this.getBuffer();
        if (iBuffer == null) {
            return;
        }
        iBuffer.setContents(translationUnit.getContents());
        this.updateTimeStamp(translationUnit);
        this.makeConsistent(null);
    }

    public void save(IProgressMonitor iProgressMonitor, boolean bl) throws CModelException {
        if (this.isReadOnly()) {
            throw new CModelException(new CModelStatus(976, this));
        }
        this.reconcile();
    }

    protected void updateTimeStamp(TranslationUnit translationUnit) throws CModelException {
        long l = ((IFile)translationUnit.getResource()).getModificationStamp();
        if (l == -1L) {
            throw new CModelException(new CModelStatus(995));
        }
        ((TranslationUnitInfo)this.getElementInfo()).fTimestamp = l;
    }
}

