/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.Set;
import org.eclipse.cdt.core.parser.BacktrackException;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.extension.IParserExtension;
import org.eclipse.cdt.internal.core.parser.CompleteParser;
import org.eclipse.cdt.internal.core.parser.ExpressionParser;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;

public class ContextualParser
extends CompleteParser {
    protected IASTScope contextualScope;
    protected IASTCompletionNode.CompletionKind completionKind;
    protected IASTNode context;
    protected IToken finalToken;
    protected Set keywordSet;
    protected char[] functionOrConstructorName = ExpressionParser.EMPTY_STRING;
    private char[] currentFunctionName = ExpressionParser.EMPTY_STRING;
    protected IASTExpression parameterListExpression;

    public ContextualParser(IScanner iScanner, ISourceElementRequestor iSourceElementRequestor, ParserLanguage parserLanguage, IParserLogService iParserLogService, IParserExtension iParserExtension) {
        super(iScanner, iSourceElementRequestor, parserLanguage, iParserLogService, iParserExtension);
    }

    protected IASTScope getCompletionScope() {
        return this.contextualScope;
    }

    protected IASTCompletionNode.CompletionKind getCompletionKind() {
        return this.completionKind;
    }

    protected String getCompletionPrefix() {
        return this.finalToken == null ? String.valueOf(ExpressionParser.EMPTY_STRING) : this.finalToken.getImage();
    }

    protected IASTNode getCompletionContext() {
        return this.context;
    }

    protected void setCompletionContext(IASTNode iASTNode) {
        this.context = iASTNode;
    }

    protected void setCompletionKind(IASTCompletionNode.CompletionKind completionKind) {
        this.completionKind = completionKind;
    }

    protected void setCompletionValues(IASTCompletionNode.CompletionKind completionKind, Set set, String string) {
        this.setCompletionScope(this.compilationUnit);
        this.keywordSet = set;
        this.setCompletionKind(completionKind);
        this.setCompletionContext(null);
        this.setCompletionFunctionName();
        this.setCompletionToken(TokenFactory.createStandAloneToken(1, string));
    }

    protected void setCompletionFunctionName() {
        this.functionOrConstructorName = this.currentFunctionName;
    }

    protected void setCompletionKeywords(KeywordSetKey keywordSetKey) {
        this.keywordSet = KeywordSets.getKeywords(keywordSetKey, this.language);
    }

    protected void setCompletionToken(IToken iToken) {
        this.finalToken = iToken;
    }

    protected void setCompletionValues(IASTScope iASTScope, IASTCompletionNode.CompletionKind completionKind, KeywordSetKey keywordSetKey, IASTNode iASTNode, String string) throws EndOfFileException {
        this.setCompletionToken(TokenFactory.createStandAloneToken(1, string));
        this.setCompletionValues(iASTScope, completionKind, keywordSetKey, iASTNode);
    }

    protected void setCompletionValues(IASTScope iASTScope, IASTCompletionNode.CompletionKind completionKind, KeywordSetKey keywordSetKey) throws EndOfFileException {
        this.setCompletionValues(iASTScope, completionKind, keywordSetKey, null);
    }

    protected void setCompletionValues(IASTScope iASTScope, IASTCompletionNode.CompletionKind completionKind, KeywordSetKey keywordSetKey, IASTNode iASTNode) throws EndOfFileException {
        this.setCompletionScope(iASTScope);
        this.setCompletionKeywords(keywordSetKey);
        this.setCompletionKind(completionKind);
        this.setCompletionContext(iASTNode);
        this.setCompletionFunctionName();
        this.checkEndOfFile();
    }

    protected void setCompletionValues(IASTScope iASTScope, IASTCompletionNode.CompletionKind completionKind, IToken iToken, IToken iToken2, KeywordSetKey keywordSetKey) throws EndOfFileException {
        this.setCompletionScope(iASTScope);
        this.setCompletionKind(completionKind);
        this.setCompletionKeywords(keywordSetKey);
        ITokenDuple iTokenDuple = TokenFactory.createTokenDuple(iToken, iToken2);
        try {
            this.setCompletionContext(this.astFactory.lookupSymbolInContext(iASTScope, iTokenDuple, null));
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {}
        this.setCompletionFunctionName();
    }

    protected void setCompletionValues(IASTScope iASTScope, IASTCompletionNode.CompletionKind completionKind, KeywordSetKey keywordSetKey, IASTExpression iASTExpression, IASTExpression.Kind kind) throws EndOfFileException {
        IASTNode iASTNode = this.astFactory.expressionToMostPreciseASTNode(iASTScope, iASTExpression);
        if (completionKind == IASTCompletionNode.CompletionKind.MEMBER_REFERENCE && !this.validMemberOperation(iASTNode, kind)) {
            iASTNode = null;
        }
        this.setCompletionValues(iASTScope, completionKind, keywordSetKey, iASTNode);
    }

    private boolean validMemberOperation(IASTNode iASTNode, IASTExpression.Kind kind) {
        if (kind == IASTExpression.Kind.POSTFIX_ARROW_IDEXPRESSION || kind == IASTExpression.Kind.POSTFIX_ARROW_TEMPL_IDEXP) {
            return this.astFactory.validateIndirectMemberOperation(iASTNode);
        }
        if (kind == IASTExpression.Kind.POSTFIX_DOT_IDEXPRESSION || kind == IASTExpression.Kind.POSTFIX_DOT_TEMPL_IDEXPRESS) {
            return this.astFactory.validateDirectMemberOperation(iASTNode);
        }
        return false;
    }

    protected void setCompletionScope(IASTScope iASTScope) {
        this.contextualScope = iASTScope;
    }

    protected void setCompletionValues(IASTScope iASTScope, IASTCompletionNode.CompletionKind completionKind) throws EndOfFileException {
        this.setCompletionScope(iASTScope);
        this.setCompletionKind(completionKind);
        this.setCompletionFunctionName();
        this.checkEndOfFile();
    }

    protected void setCompletionValues(IASTScope iASTScope, IASTCompletionNode.CompletionKind completionKind, IASTNode iASTNode) throws EndOfFileException {
        this.setCompletionScope(iASTScope);
        this.setCompletionKind(completionKind);
        this.setCompletionContext(iASTNode);
        this.setCompletionFunctionName();
        this.checkEndOfFile();
    }

    protected char[] getCompletionFunctionName() {
        return this.functionOrConstructorName;
    }

    protected void setCurrentFunctionName(char[] cArray) {
        this.currentFunctionName = cArray;
    }

    protected void handleFunctionBody(IASTScope iASTScope) throws BacktrackException, EndOfFileException {
        if (this.scanner.isOnTopContext()) {
            this.functionBody(iASTScope);
        } else {
            this.skipOverCompoundStatement();
        }
    }

    protected void catchBlockCompoundStatement(IASTScope iASTScope) throws BacktrackException, EndOfFileException {
        if (this.scanner.isOnTopContext()) {
            this.compoundStatement(iASTScope, true);
        } else {
            this.skipOverCompoundStatement();
        }
    }

    protected void setCompletionValuesNoContext(IASTScope iASTScope, IASTCompletionNode.CompletionKind completionKind, KeywordSetKey keywordSetKey) throws EndOfFileException {
        this.setCompletionScope(iASTScope);
        this.setCompletionKeywords(keywordSetKey);
        this.setCompletionKind(completionKind);
        this.checkEndOfFile();
    }

    protected void setParameterListExpression(IASTExpression iASTExpression) {
        this.parameterListExpression = iASTExpression;
    }

    public final IASTExpression getParameterListExpression() {
        return this.parameterListExpression;
    }
}

