/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.parser.BacktrackException;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.ASTSemanticException;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.parser.Declarator;
import org.eclipse.cdt.internal.core.parser.IDeclaratorOwner;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;

public class DeclarationWrapper
implements IDeclaratorOwner {
    private int flag = 0;
    private static final int DEFAULT_LIST_SIZE = 4;
    protected static final int IS_IMAGINARY = 16;
    protected static final int IS_COMPLEX = 32;
    protected static final int IS_RESTRICT = 64;
    protected static final int IS_SIGNED = 128;
    protected static final int IS_SHORT = 256;
    protected static final int IS_UNSIGNED = 512;
    protected static final int IS_LONG = 1024;
    protected static final int IS_TYPENAMED = 2048;
    protected static final int IS_VOLATILE = 4096;
    protected static final int IS_VIRTUAL = 8192;
    protected static final int IS_TYPEDEF = 16384;
    protected static final int IS_STATIC = 32768;
    protected static final int IS_REGISTER = 65536;
    protected static final int IS_EXTERN = 131072;
    protected static final int IS_EXPLICIT = 262144;
    protected static final int IS_CONST = 524288;
    protected static final int IS_AUTO = 0x100000;
    protected static final int IS_GLOBAL = 0x200000;
    protected static final int IS_MUTABLE = 0x400000;
    protected static final int IS_FRIEND = 0x800000;
    protected static final int IS_INLINE = 0x1000000;
    private int startingOffset = 0;
    private int startingLine;
    private int endOffset;
    private ITokenDuple name;
    private IASTSimpleTypeSpecifier.Type simpleType = IASTSimpleTypeSpecifier.Type.UNSPECIFIED;
    private final IASTTemplate templateDeclaration;
    private final IASTScope scope;
    private IASTTypeSpecifier typeSpecifier;
    private List declarators = Collections.EMPTY_LIST;
    private IASTFactory astFactory = null;
    private int endLine;
    private final char[] fn;
    private Map extensionParameters = Collections.EMPTY_MAP;

    protected void setBit(boolean bl, int n) {
        this.flag = bl ? (this.flag |= n) : (this.flag &= ~n);
    }

    protected boolean checkBit(int n) {
        return (this.flag & n) != 0;
    }

    public void setAuto(boolean bl) {
        this.setBit(bl, 0x100000);
    }

    public IASTScope getScope() {
        return this.scope;
    }

    public DeclarationWrapper(IASTScope iASTScope, int n, int n2, IASTTemplate iASTTemplate, char[] cArray) {
        this.scope = iASTScope;
        this.startingOffset = n;
        this.startingLine = n2;
        this.templateDeclaration = iASTTemplate;
        this.fn = cArray;
    }

    public void setTypenamed(boolean bl) {
        this.setBit(bl, 2048);
    }

    public void setMutable(boolean bl) {
        this.setBit(bl, 0x400000);
    }

    public void setFriend(boolean bl) {
        this.setBit(bl, 0x800000);
    }

    public void setInline(boolean bl) {
        this.setBit(bl, 0x1000000);
    }

    public void setRegister(boolean bl) {
        this.setBit(bl, 65536);
    }

    public void setStatic(boolean bl) {
        this.setBit(bl, 32768);
    }

    public void setTypedef(boolean bl) {
        this.setBit(bl, 16384);
    }

    public void setVirtual(boolean bl) {
        this.setBit(bl, 8192);
    }

    public void setVolatile(boolean bl) {
        this.setBit(bl, 4096);
    }

    public void setExtern(boolean bl) {
        this.setBit(bl, 131072);
    }

    public void setExplicit(boolean bl) {
        this.setBit(bl, 262144);
    }

    public void setConst(boolean bl) {
        this.setBit(bl, 524288);
    }

    public boolean isAuto() {
        return this.checkBit(0x100000);
    }

    public boolean isConst() {
        return this.checkBit(524288);
    }

    public boolean isExplicit() {
        return this.checkBit(262144);
    }

    public boolean isExtern() {
        return this.checkBit(131072);
    }

    public boolean isFriend() {
        return this.checkBit(0x800000);
    }

    public boolean isInline() {
        return this.checkBit(0x1000000);
    }

    public boolean isMutable() {
        return this.checkBit(0x400000);
    }

    public boolean isRegister() {
        return this.checkBit(65536);
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getStartingLine() {
        return this.startingLine;
    }

    public boolean isStatic() {
        return this.checkBit(32768);
    }

    public boolean isTypedef() {
        return this.checkBit(16384);
    }

    public boolean isTypeNamed() {
        return this.checkBit(2048);
    }

    public boolean isVirtual() {
        return this.checkBit(8192);
    }

    public boolean isVolatile() {
        return this.checkBit(4096);
    }

    public void addDeclarator(Declarator declarator) {
        if (this.declarators == Collections.EMPTY_LIST) {
            this.declarators = new ArrayList(4);
        }
        this.declarators.add(declarator);
    }

    public Iterator getDeclarators() {
        return this.declarators.iterator();
    }

    private List getDeclaratorsList() {
        return this.declarators;
    }

    public IASTTypeSpecifier getTypeSpecifier() {
        return this.typeSpecifier;
    }

    public void setTypeSpecifier(IASTTypeSpecifier iASTTypeSpecifier) {
        this.typeSpecifier = iASTTypeSpecifier;
    }

    public List createASTNodes(IASTFactory iASTFactory) throws ASTSemanticException, BacktrackException {
        this.astFactory = iASTFactory;
        if (this.declarators.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IASTDeclaration> arrayList = new ArrayList<IASTDeclaration>(this.declarators.size());
        int n = 0;
        while (n < this.declarators.size()) {
            arrayList.add(this.createASTNode((Declarator)this.declarators.get(n)));
            ++n;
        }
        return arrayList;
    }

    private IASTDeclaration createASTNode(Declarator declarator) throws ASTSemanticException, BacktrackException {
        boolean bl;
        boolean bl2 = false;
        if (this.getScope() instanceof IASTClassSpecifier) {
            bl2 = true;
        } else if (this.getScope() instanceof IASTTemplateDeclaration) {
            bl2 = ((IASTTemplateDeclaration)this.getScope()).getOwnerScope() instanceof IASTClassSpecifier;
        }
        boolean bl3 = declarator.isFunction();
        boolean bl4 = bl = declarator.getOwnedDeclarator() != null;
        if (bl) {
            return this.createIndirectDeclaration(declarator);
        }
        if (this.isTypedef()) {
            return this.createTypedef(declarator, false);
        }
        if (bl2) {
            if (bl3) {
                return this.createMethodASTNode(declarator, false);
            }
            if (declarator.hasFunctionBody()) {
                throw new ASTSemanticException(null);
            }
            return this.createFieldASTNode(declarator, false);
        }
        if (bl3) {
            return this.createFunctionASTNode(declarator, false);
        }
        if (declarator.hasFunctionBody()) {
            throw new ASTSemanticException(null);
        }
        return this.createVariableASTNode(declarator, false);
    }

    private IASTDeclaration createIndirectDeclaration(Declarator declarator) throws BacktrackException, ASTSemanticException {
        if (declarator.getOwnedDeclarator().getOwnedDeclarator() == null) {
            ITokenDuple iTokenDuple;
            boolean bl;
            Declarator declarator2 = declarator.getOwnedDeclarator();
            List list = declarator2.getPointerOperators();
            boolean bl2 = this.scope instanceof IASTClassSpecifier;
            boolean bl3 = bl = declarator.getParameters().size() != 0;
            if (list.size() == 0) {
                if (this.isTypedef()) {
                    return this.createTypedef(declarator, true);
                }
                if (bl2) {
                    if (bl) {
                        return this.createMethodASTNode(declarator, true);
                    }
                    return this.createFieldASTNode(declarator, true);
                }
                if (bl) {
                    return this.createFunctionASTNode(declarator, true);
                }
                return this.createVariableASTNode(declarator, true);
            }
            List list2 = this.createParameterList(declarator.getParameters());
            IASTAbstractDeclaration iASTAbstractDeclaration = null;
            iASTAbstractDeclaration = this.astFactory.createAbstractDeclaration(this.isConst(), this.isVolatile(), this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), list2, (ASTPointerOperator)list.get(0));
            ITokenDuple iTokenDuple2 = iTokenDuple = declarator2.getPointerOperatorNameDuple() != null ? TokenFactory.createTokenDuple(declarator2.getPointerOperatorNameDuple(), declarator2.getNameDuple()) : declarator2.getNameDuple();
            if (this.isTypedef()) {
                return this.astFactory.createTypedef(this.scope, iTokenDuple.toCharArray(), iASTAbstractDeclaration, this.getStartingOffset(), this.getStartingLine(), declarator2.getNameStartOffset(), declarator2.getNameEndOffset(), declarator2.getNameLine(), this.fn);
            }
            if (bl2) {
                return this.astFactory.createField(this.scope, iTokenDuple, this.isAuto(), declarator2.getInitializerClause(), declarator2.getBitFieldExpression(), iASTAbstractDeclaration, this.isMutable(), this.isExtern(), this.isRegister(), this.isStatic(), this.getStartingOffset(), this.getStartingLine(), declarator2.getNameStartOffset(), declarator2.getNameEndOffset(), declarator2.getNameLine(), declarator2.getConstructorExpression(), ((IASTClassSpecifier)this.scope).getCurrentVisibilityMode(), this.fn);
            }
            return this.astFactory.createVariable(this.scope, iTokenDuple, this.isAuto(), declarator2.getInitializerClause(), declarator2.getBitFieldExpression(), iASTAbstractDeclaration, this.isMutable(), this.isExtern(), this.isRegister(), this.isStatic(), this.getStartingOffset(), this.getStartingLine(), declarator2.getNameStartOffset(), declarator2.getNameEndOffset(), declarator2.getNameLine(), declarator2.getConstructorExpression(), this.fn);
        }
        throw new BacktrackException();
    }

    private IASTTypedefDeclaration createTypedef(Declarator declarator, boolean bl) throws ASTSemanticException {
        return this.astFactory.createTypedef(this.scope, bl ? declarator.getOwnedDeclarator().getName() : declarator.getName(), this.astFactory.createAbstractDeclaration(this.isConst(), this.isVolatile(), this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), this.startingOffset, this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), this.fn);
    }

    private IASTMethod createMethodASTNode(Declarator declarator, boolean bl) throws ASTSemanticException {
        IASTScope iASTScope = this.getScope();
        if (iASTScope instanceof IASTTemplateDeclaration) {
            iASTScope = ((IASTTemplateDeclaration)iASTScope).getOwnerScope();
        }
        return this.astFactory.createMethod(this.scope, bl ? declarator.getOwnedDeclarator().getNameDuple() : declarator.getNameDuple(), this.createParameterList(declarator.getParameters()), this.astFactory.createAbstractDeclaration(this.isConst(), this.isVolatile(), this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), declarator.getExceptionSpecification(), this.isInline(), this.isFriend(), this.isStatic(), this.startingOffset, this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), this.templateDeclaration, declarator.isConst(), declarator.isVolatile(), this.isVirtual(), this.isExplicit(), declarator.isPureVirtual(), ((IASTClassSpecifier)iASTScope).getCurrentVisibilityMode(), declarator.getConstructorMemberInitializers(), declarator.hasFunctionBody(), declarator.hasFunctionTryBlock(), declarator.isVarArgs());
    }

    private IASTFunction createFunctionASTNode(Declarator declarator, boolean bl) throws ASTSemanticException {
        return this.astFactory.createFunction(this.scope, bl ? declarator.getOwnedDeclarator().getNameDuple() : declarator.getNameDuple(), this.createParameterList(declarator.getParameters()), this.astFactory.createAbstractDeclaration(this.isConst(), this.isVolatile(), this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), declarator.getExceptionSpecification(), this.isInline(), this.isFriend(), this.isStatic(), this.startingOffset, this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), this.templateDeclaration, declarator.isConst(), declarator.isVolatile(), this.isVirtual(), this.isExplicit(), declarator.isPureVirtual(), declarator.getConstructorMemberInitializers(), declarator.hasFunctionBody(), declarator.hasFunctionTryBlock(), declarator.isVarArgs());
    }

    private IASTField createFieldASTNode(Declarator declarator, boolean bl) throws ASTSemanticException {
        return this.astFactory.createField(this.scope, bl ? declarator.getOwnedDeclarator().getNameDuple() : declarator.getNameDuple(), this.isAuto(), declarator.getInitializerClause(), declarator.getBitFieldExpression(), this.astFactory.createAbstractDeclaration(this.isConst(), this.isVolatile(), this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), this.isMutable(), this.isExtern(), this.isRegister(), this.isStatic(), this.startingOffset, this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), declarator.getConstructorExpression(), ((IASTClassSpecifier)this.scope).getCurrentVisibilityMode(), this.fn);
    }

    private List createParameterList(List list) throws ASTSemanticException {
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IASTParameterDeclaration> arrayList = new ArrayList<IASTParameterDeclaration>(list.size());
        int n = 0;
        while (n < list.size()) {
            DeclarationWrapper declarationWrapper = (DeclarationWrapper)list.get(n);
            List list2 = declarationWrapper.getDeclaratorsList();
            int n2 = 0;
            while (n2 < list2.size()) {
                Declarator declarator = (Declarator)list2.get(n2);
                arrayList.add(this.astFactory.createParameterDeclaration(declarationWrapper.isConst(), declarationWrapper.isVolatile(), declarationWrapper.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null, declarator.getName(), declarator.getInitializerClause(), declarationWrapper.getStartingOffset(), this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), declarationWrapper.getEndOffset(), this.getEndLine(), declarationWrapper.fn));
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    private IASTVariable createVariableASTNode(Declarator declarator, boolean bl) throws ASTSemanticException {
        return this.astFactory.createVariable(this.scope, bl ? declarator.getOwnedDeclarator().getNameDuple() : declarator.getNameDuple(), this.isAuto(), declarator.getInitializerClause(), declarator.getBitFieldExpression(), this.astFactory.createAbstractDeclaration(this.isConst(), this.isVolatile(), this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), this.isMutable(), this.isExtern(), this.isRegister(), this.isStatic(), this.getStartingOffset(), this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), declarator.getConstructorExpression(), this.fn);
    }

    public DeclarationWrapper getDeclarationWrapper() {
        return this;
    }

    public boolean isUnsigned() {
        return this.checkBit(512);
    }

    public boolean isSigned() {
        return this.checkBit(128);
    }

    public boolean isShort() {
        return this.checkBit(256);
    }

    public boolean isLong() {
        return this.checkBit(1024);
    }

    public void setLong(boolean bl) {
        this.setBit(bl, 1024);
    }

    public void setShort(boolean bl) {
        this.setBit(bl, 256);
    }

    public void setSigned(boolean bl) {
        this.setBit(bl, 128);
    }

    public void setUnsigned(boolean bl) {
        this.setBit(bl, 512);
    }

    public IASTSimpleTypeSpecifier.Type getSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(IASTSimpleTypeSpecifier.Type type) {
        this.simpleType = type;
    }

    public void setTypeName(ITokenDuple iTokenDuple) {
        this.name = iTokenDuple;
    }

    public final ITokenDuple getName() {
        return this.name;
    }

    public final IASTTemplate getOwnerTemplate() {
        return this.templateDeclaration;
    }

    public void setEndingOffsetAndLineNumber(int n, int n2) {
        this.endOffset = n;
        this.endLine = n2;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setRestrict(boolean bl) {
        this.setBit(bl, 64);
    }

    public boolean isRestrict() {
        return this.checkBit(64);
    }

    public void setImaginary(boolean bl) {
        this.setBit(bl, 16);
    }

    public boolean isComplex() {
        return this.checkBit(32);
    }

    public boolean isImaginary() {
        return this.checkBit(16);
    }

    public void setComplex(boolean bl) {
        this.setBit(bl, 32);
    }

    public void setGloballyQualified(boolean bl) {
        this.setBit(bl, 0x200000);
    }

    public boolean isGloballyQualified() {
        return this.checkBit(0x200000);
    }

    public void setExtensionParameter(String string, Object object) {
        if (this.extensionParameters == Collections.EMPTY_MAP) {
            this.extensionParameters = new Hashtable(4);
        }
        this.extensionParameters.put(string, object);
    }

    public Map getExtensionParameters() {
        return this.extensionParameters;
    }

    public boolean consumedRawType() {
        return this.getSimpleType() != IASTSimpleTypeSpecifier.Type.UNSPECIFIED;
    }
}

