/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.Hashtable;
import org.eclipse.cdt.core.parser.BacktrackException;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.Enum;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.ASTSemanticException;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTDesignator;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.gcc.IASTGCCDesignator;
import org.eclipse.cdt.core.parser.ast.gcc.IASTGCCExpression;
import org.eclipse.cdt.core.parser.ast.gcc.IASTGCCSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.extension.IParserExtension;
import org.eclipse.cdt.internal.core.parser.DeclarationWrapper;
import org.eclipse.cdt.internal.core.parser.IParserData;
import org.eclipse.cdt.internal.core.parser.Parser;

public class GCCParserExtension
implements IParserExtension {
    private static final char[] EMPTY_STRING = "".toCharArray();

    public boolean isValidCVModifier(ParserLanguage parserLanguage, int n) {
        return n == 137 && parserLanguage == ParserLanguage.CPP;
    }

    public ASTPointerOperator getPointerOperator(ParserLanguage parserLanguage, int n) {
        if (n == 137 && parserLanguage == ParserLanguage.CPP) {
            return ASTPointerOperator.RESTRICT_POINTER;
        }
        return null;
    }

    public boolean isValidUnaryExpressionStart(int n) {
        switch (n) {
            case 140: 
            case 141: {
                return true;
            }
        }
        return false;
    }

    public IASTExpression parseUnaryExpression(IASTScope iASTScope, IParserData iParserData, IASTCompletionNode.CompletionKind completionKind, KeywordSetKey keywordSetKey) {
        try {
            switch (iParserData.LT(1)) {
                case 141: {
                    return this.performUnaryExpression(iParserData, iASTScope, completionKind, keywordSetKey, UnaryExpressionKind.ALIGNOF);
                }
                case 140: {
                    return this.performUnaryExpression(iParserData, iASTScope, completionKind, keywordSetKey, UnaryExpressionKind.TYPEOF);
                }
            }
        }
        catch (EndOfFileException endOfFileException) {}
        return null;
    }

    protected IASTExpression performUnaryExpression(IParserData iParserData, IASTScope iASTScope, IASTCompletionNode.CompletionKind completionKind, KeywordSetKey keywordSetKey, UnaryExpressionKind unaryExpressionKind) {
        IToken iToken = null;
        try {
            if (unaryExpressionKind == UnaryExpressionKind.ALIGNOF) {
                iToken = iParserData.consume(141);
            } else if (unaryExpressionKind == UnaryExpressionKind.TYPEOF) {
                iToken = iParserData.consume(140);
            }
        }
        catch (BacktrackException backtrackException) {
            return null;
        }
        catch (EndOfFileException endOfFileException) {
            return null;
        }
        try {
            IToken iToken2 = iParserData.mark();
            IASTTypeId iASTTypeId = null;
            IASTExpression iASTExpression = null;
            if (iParserData.LT(1) == 8) {
                try {
                    iParserData.consume(8);
                    iASTTypeId = iParserData.typeId(iASTScope, false, IASTCompletionNode.CompletionKind.TYPE_REFERENCE);
                    iParserData.consume(9);
                }
                catch (BacktrackException backtrackException) {
                    iParserData.backup(iToken2);
                    iASTTypeId = null;
                    iASTExpression = iParserData.unaryExpression(iASTScope, completionKind, keywordSetKey);
                }
            } else {
                iASTExpression = iParserData.unaryExpression(iASTScope, completionKind, keywordSetKey);
            }
            if (iASTTypeId != null & iASTExpression == null) {
                try {
                    IASTGCCExpression.Kind kind = null;
                    if (unaryExpressionKind == UnaryExpressionKind.ALIGNOF) {
                        kind = IASTGCCExpression.Kind.UNARY_ALIGNOF_TYPEID;
                    } else if (unaryExpressionKind == UnaryExpressionKind.TYPEOF) {
                        kind = IASTGCCExpression.Kind.UNARY_TYPEOF_TYPEID;
                    }
                    return iParserData.getAstFactory().createExpression(iASTScope, kind, null, null, null, iASTTypeId, null, EMPTY_STRING, null);
                }
                catch (ASTSemanticException aSTSemanticException) {
                    iParserData.backup(iToken);
                    return null;
                }
                catch (Exception exception) {
                    iParserData.logException("unaryExpression_1::createExpression()", exception);
                    iParserData.backup(iToken);
                    return null;
                }
            }
            if (iASTExpression != null && iASTTypeId == null) {
                try {
                    IASTGCCExpression.Kind kind = null;
                    if (unaryExpressionKind == UnaryExpressionKind.ALIGNOF) {
                        kind = IASTGCCExpression.Kind.UNARY_ALIGNOF_UNARYEXPRESSION;
                    } else if (unaryExpressionKind == UnaryExpressionKind.TYPEOF) {
                        kind = IASTGCCExpression.Kind.UNARY_TYPEOF_UNARYEXPRESSION;
                    }
                    return iParserData.getAstFactory().createExpression(iASTScope, kind, iASTExpression, null, null, null, null, EMPTY_STRING, null);
                }
                catch (ASTSemanticException aSTSemanticException) {
                    iParserData.backup(iToken);
                    return null;
                }
                catch (Exception exception) {
                    iParserData.logException("unaryExpression_1::createExpression()", exception);
                    iParserData.backup(iToken);
                    return null;
                }
            }
            return null;
        }
        catch (BacktrackException backtrackException) {
            iParserData.backup(iToken);
            return null;
        }
        catch (EndOfFileException endOfFileException) {
            iParserData.backup(iToken);
            return null;
        }
    }

    public boolean canHandleDeclSpecifierSequence(int n) {
        switch (n) {
            case 140: {
                return true;
            }
        }
        return false;
    }

    public IParserExtension.IDeclSpecifierExtensionResult parseDeclSpecifierSequence(IParserData iParserData, Parser.Flags flags, DeclarationWrapper declarationWrapper, IASTCompletionNode.CompletionKind completionKind, KeywordSetKey keywordSetKey) {
        IToken iToken = null;
        try {
            iToken = iParserData.mark();
        }
        catch (EndOfFileException endOfFileException) {
            return null;
        }
        try {
            switch (iParserData.LT(1)) {
                case 140: {
                    IASTExpression iASTExpression = this.performUnaryExpression(iParserData, declarationWrapper.getScope(), completionKind, keywordSetKey, UnaryExpressionKind.TYPEOF);
                    if (iASTExpression != null) {
                        declarationWrapper.setSimpleType(IASTGCCSimpleTypeSpecifier.Type.TYPEOF);
                        flags.setEncounteredRawType(true);
                        Hashtable<String, IASTExpression> hashtable = new Hashtable<String, IASTExpression>();
                        hashtable.put("TYPEOF EXPRESSION", iASTExpression);
                        declarationWrapper.setExtensionParameter("TYPEOF EXPRESSION", iASTExpression);
                        return new GCCDeclSpecifierExtensionResult(iToken, iParserData.getLastToken(), flags, hashtable);
                    }
                    iParserData.backup(iToken);
                    return null;
                }
            }
            iParserData.backup(iToken);
            return null;
        }
        catch (EndOfFileException endOfFileException) {
            iParserData.backup(iToken);
            return null;
        }
    }

    public boolean isValidRelationalExpressionStart(ParserLanguage parserLanguage, int n) {
        switch (n) {
            case 142: 
            case 143: {
                return true;
            }
        }
        return false;
    }

    public IASTExpression parseRelationalExpression(IASTScope iASTScope, IParserData iParserData, IASTCompletionNode.CompletionKind completionKind, KeywordSetKey keywordSetKey, IASTExpression iASTExpression) {
        if (iParserData.getParserLanguage() == ParserLanguage.C) {
            return null;
        }
        IToken iToken = null;
        try {
            iToken = iParserData.mark();
        }
        catch (EndOfFileException endOfFileException) {
            return null;
        }
        IASTGCCExpression.Kind kind = null;
        try {
            switch (iParserData.LT(1)) {
                case 142: {
                    iParserData.consume(142);
                    kind = IASTGCCExpression.Kind.RELATIONAL_MAX;
                    break;
                }
                case 143: {
                    iParserData.consume(143);
                    kind = IASTGCCExpression.Kind.RELATIONAL_MIN;
                    break;
                }
                default: {
                    iParserData.backup(iToken);
                    return null;
                }
            }
            IToken iToken2 = iParserData.LA(1);
            IASTExpression iASTExpression2 = iParserData.shiftExpression(iASTScope, completionKind, keywordSetKey);
            if (iToken2 == iParserData.LA(1)) {
                iParserData.backup(iToken);
                return null;
            }
            try {
                IASTExpression iASTExpression3 = iParserData.getAstFactory().createExpression(iASTScope, kind, iASTExpression, iASTExpression2, null, null, null, EMPTY_STRING, null);
                return iASTExpression3;
            }
            catch (ASTSemanticException aSTSemanticException) {
                iParserData.backup(iToken);
                return null;
            }
        }
        catch (EndOfFileException endOfFileException) {
            iParserData.backup(iToken);
            return null;
        }
        catch (BacktrackException backtrackException) {
            iParserData.backup(iToken);
            return null;
        }
    }

    public boolean canHandleCDesignatorInitializer(int n) {
        switch (n) {
            case 1: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public IASTDesignator parseDesignator(IParserData iParserData, IASTScope iASTScope) {
        IToken iToken = null;
        try {
            iToken = iParserData.mark();
        }
        catch (EndOfFileException endOfFileException) {
            return null;
        }
        try {
            if (iParserData.LT(1) == 1) {
                IToken iToken2 = iParserData.identifier();
                iParserData.consume(4);
                return iParserData.getAstFactory().createDesignator(IASTDesignator.DesignatorKind.FIELD, null, iToken2, null);
            }
            if (iParserData.LT(1) == 10) {
                iParserData.consume(10);
                IASTExpression iASTExpression = iParserData.expression(iASTScope, IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE, KeywordSetKey.EXPRESSION);
                iParserData.consume(48);
                IASTExpression iASTExpression2 = iParserData.expression(iASTScope, IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE, KeywordSetKey.EXPRESSION);
                iParserData.consume(11);
                Hashtable<String, IASTExpression> hashtable = new Hashtable<String, IASTExpression>();
                hashtable.put("SUBSCRIPT2 EXPRESSION", iASTExpression2);
                return iParserData.getAstFactory().createDesignator(IASTGCCDesignator.DesignatorKind.SUBSCRIPT_RANGE, iASTExpression, null, hashtable);
            }
        }
        catch (EndOfFileException endOfFileException) {
        }
        catch (BacktrackException backtrackException) {}
        iParserData.backup(iToken);
        return null;
    }

    protected static class UnaryExpressionKind
    extends Enum {
        public static final UnaryExpressionKind ALIGNOF = new UnaryExpressionKind(1);
        public static final UnaryExpressionKind TYPEOF = new UnaryExpressionKind(2);

        protected UnaryExpressionKind(int n) {
            super(n);
        }
    }

    public class GCCDeclSpecifierExtensionResult
    implements IParserExtension.IDeclSpecifierExtensionResult {
        private final IToken first;
        private final IToken last;
        private final Parser.Flags flags;

        public GCCDeclSpecifierExtensionResult(IToken iToken, IToken iToken2, Parser.Flags flags, Hashtable hashtable) {
            this.first = iToken;
            this.last = iToken2;
            this.flags = flags;
        }

        public IToken getFirstToken() {
            return this.first;
        }

        public IToken getLastToken() {
            return this.last;
        }

        public Parser.Flags getFlags() {
            return this.flags;
        }
    }
}

