/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.extension.ExtensionDialect;
import org.eclipse.cdt.core.parser.extension.IASTFactoryExtension;
import org.eclipse.cdt.core.parser.extension.IParserExtension;
import org.eclipse.cdt.core.parser.extension.IParserExtensionFactory;
import org.eclipse.cdt.core.parser.extension.IScannerExtension;
import org.eclipse.cdt.internal.core.parser.GCCParserExtension;
import org.eclipse.cdt.internal.core.parser.ast.GCCASTExtension;
import org.eclipse.cdt.internal.core.parser.scanner.GCCScannerExtension;

public class ParserExtensionFactory
implements IParserExtensionFactory {
    private final ExtensionDialect dialect;

    public ParserExtensionFactory(ExtensionDialect extensionDialect) {
        this.dialect = extensionDialect;
    }

    public IScannerExtension createScannerExtension() throws ParserFactoryError {
        if (this.dialect == ExtensionDialect.GCC) {
            return new GCCScannerExtension();
        }
        throw new ParserFactoryError(ParserFactoryError.Kind.BAD_DIALECT);
    }

    public IParserExtension createParserExtension() throws ParserFactoryError {
        if (this.dialect == ExtensionDialect.GCC) {
            return new GCCParserExtension();
        }
        throw new ParserFactoryError(ParserFactoryError.Kind.BAD_DIALECT);
    }

    public IASTFactoryExtension createASTExtension(ParserMode parserMode) {
        if (this.dialect == ExtensionDialect.GCC) {
            return GCCASTExtension.createExtension(parserMode);
        }
        throw new ParserFactoryError(ParserFactoryError.Kind.BAD_DIALECT);
    }
}

