/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IQuickParseCallback;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableElement;
import org.eclipse.cdt.internal.core.parser.ParserMessages;

public class QuickParseCallback
extends NullSourceElementRequestor
implements IQuickParseCallback {
    protected IASTCompilationUnit compUnit = null;
    protected List inclusions = new ArrayList();
    protected List macros = new ArrayList();
    protected boolean hasNoProblems = true;

    public Iterator getInclusions() {
        return this.inclusions.iterator();
    }

    public Iterator getMacros() {
        return this.macros.iterator();
    }

    public Iterator getDeclarations() {
        try {
            return this.compUnit.getDeclarations();
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {
            return null;
        }
    }

    public void exitMethodBody(IASTMethod iASTMethod) {
        iASTMethod.setHasFunctionBody(true);
    }

    public void exitFunctionBody(IASTFunction iASTFunction) {
        iASTFunction.setHasFunctionBody(true);
    }

    public void exitCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
        this.compUnit = iASTCompilationUnit;
    }

    public void exitInclusion(IASTInclusion iASTInclusion) {
        this.inclusions.add(iASTInclusion);
    }

    public void acceptMacro(IASTMacro iASTMacro) {
        this.macros.add(iASTMacro);
    }

    public IASTCompilationUnit getCompilationUnit() {
        return this.compUnit;
    }

    public Iterator iterateOffsetableElements() {
        return new OffsetableIterator();
    }

    public boolean acceptProblem(IProblem iProblem) {
        this.setHasNoProblems(false);
        return super.acceptProblem(iProblem);
    }

    public boolean hasNoProblems() {
        return this.hasNoProblems;
    }

    public void setHasNoProblems(boolean bl) {
        this.hasNoProblems = bl;
    }

    public class OffsetableIterator
    implements Iterator {
        private Iterator declarationIter;
        private final Iterator inclusionIter;
        private final Iterator macroIter;
        private IASTOffsetableElement currentMacro = null;
        private IASTOffsetableElement currentInclusion = null;
        private IASTOffsetableElement currentDeclaration = null;

        public OffsetableIterator() {
            this.declarationIter = QuickParseCallback.this.getDeclarations();
            this.inclusionIter = QuickParseCallback.this.getInclusions();
            this.macroIter = QuickParseCallback.this.getMacros();
            this.updateInclusionIterator();
            this.updateMacroIterator();
            this.updateDeclarationIterator();
        }

        private Object updateDeclarationIterator() {
            IASTOffsetableElement iASTOffsetableElement = this.currentDeclaration;
            if (this.declarationIter != null) {
                this.currentDeclaration = this.declarationIter.hasNext() ? (IASTOffsetableElement)this.declarationIter.next() : null;
            }
            return iASTOffsetableElement;
        }

        private Object updateMacroIterator() {
            IASTOffsetableElement iASTOffsetableElement = this.currentMacro;
            this.currentMacro = this.macroIter.hasNext() ? (IASTOffsetableElement)this.macroIter.next() : null;
            return iASTOffsetableElement;
        }

        private Object updateInclusionIterator() {
            IASTOffsetableElement iASTOffsetableElement = this.currentInclusion;
            this.currentInclusion = this.inclusionIter.hasNext() ? (IASTOffsetableElement)this.inclusionIter.next() : null;
            return iASTOffsetableElement;
        }

        public boolean hasNext() {
            return this.currentMacro != null || this.currentInclusion != null || this.currentDeclaration != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.currentMacro == null && this.currentInclusion == null) {
                return this.updateDeclarationIterator();
            }
            if (this.currentDeclaration == null && this.currentInclusion == null) {
                return this.updateMacroIterator();
            }
            if (this.currentMacro == null && this.currentDeclaration == null) {
                return this.updateInclusionIterator();
            }
            if (this.currentMacro == null) {
                if (this.currentDeclaration.getStartingOffset() < this.currentInclusion.getStartingOffset()) {
                    return this.updateDeclarationIterator();
                }
                return this.updateInclusionIterator();
            }
            if (this.currentInclusion == null) {
                if (this.currentDeclaration.getStartingOffset() < this.currentMacro.getStartingOffset()) {
                    return this.updateDeclarationIterator();
                }
                return this.updateMacroIterator();
            }
            if (this.currentDeclaration == null) {
                if (this.currentInclusion.getStartingOffset() < this.currentMacro.getStartingOffset()) {
                    return this.updateInclusionIterator();
                }
                return this.updateMacroIterator();
            }
            if (this.currentInclusion.getStartingOffset() < this.currentMacro.getStartingOffset() && this.currentInclusion.getStartingOffset() < this.currentDeclaration.getStartingOffset()) {
                return this.updateInclusionIterator();
            }
            if (this.currentMacro.getStartingOffset() < this.currentInclusion.getStartingOffset() && this.currentMacro.getStartingOffset() < this.currentDeclaration.getStartingOffset()) {
                return this.updateMacroIterator();
            }
            return this.updateDeclarationIterator();
        }

        public void remove() {
            throw new UnsupportedOperationException(ParserMessages.getString("QuickParseCallback.exception.constIterator"));
        }
    }
}

