/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.Arrays;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableElement;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.extension.IParserExtension;
import org.eclipse.cdt.internal.core.parser.ContextualParser;
import org.eclipse.cdt.internal.core.parser.token.OffsetDuple;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;
import org.eclipse.cdt.internal.core.parser.util.TraceUtil;

public class SelectionParser
extends ContextualParser {
    private OffsetDuple offsetRange;
    private IToken firstTokenOfDuple = null;
    private IToken lastTokenOfDuple = null;
    private IASTScope ourScope = null;
    private IASTCompletionNode.CompletionKind ourKind = null;
    private IASTNode ourContext = null;
    private ITokenDuple greaterContextDuple = null;
    private boolean pastPointOfSelection = false;
    private IASTNode contextNode = null;

    protected void handleNewToken(IToken iToken) {
        if (iToken != null && this.scanner.isOnTopContext()) {
            TraceUtil.outputTrace(this.log, "IToken provided w/offsets ", null, iToken.getOffset(), " & ", iToken.getEndOffset());
            boolean bl = false;
            if (iToken.getOffset() == this.offsetRange.getFloorOffset()) {
                TraceUtil.outputTrace(this.log, "Offset Floor Hit w/token \"", null, iToken.getCharImage(), "\"", null);
                this.firstTokenOfDuple = iToken;
                bl = true;
            }
            if (iToken.getEndOffset() == this.offsetRange.getCeilingOffset()) {
                TraceUtil.outputTrace(this.log, "Offset Ceiling Hit w/token \"", null, iToken.getCharImage(), "\"", null);
                bl = true;
                this.lastTokenOfDuple = iToken;
            }
            if (bl && this.tokenDupleCompleted()) {
                if (this.ourScope == null) {
                    this.ourScope = this.getCompletionScope();
                }
                if (this.ourContext == null) {
                    this.ourContext = this.getCompletionContext();
                }
                if (this.ourKind == null) {
                    this.ourKind = this.getCompletionKind();
                }
            }
        }
    }

    protected boolean tokenDupleCompleted() {
        return this.lastTokenOfDuple != null && this.lastTokenOfDuple.getEndOffset() >= this.offsetRange.getCeilingOffset();
    }

    public SelectionParser(IScanner iScanner, ISourceElementRequestor iSourceElementRequestor, ParserLanguage parserLanguage, IParserLogService iParserLogService, IParserExtension iParserExtension) {
        super(iScanner, iSourceElementRequestor, parserLanguage, iParserLogService, iParserExtension);
    }

    public IParser.ISelectionParseResult parse(int n, int n2) {
        this.offsetRange = new OffsetDuple(n, n2);
        this.translationUnit();
        return this.reconcileTokenDuple();
    }

    protected IParser.ISelectionParseResult reconcileTokenDuple() throws ParseError {
        if (this.firstTokenOfDuple == null || this.lastTokenOfDuple == null) {
            throw new ParseError(ParseError.ParseErrorKind.OFFSET_RANGE_NOT_NAME);
        }
        if (this.getCompletionKind() == IASTCompletionNode.CompletionKind.UNREACHABLE_CODE) {
            throw new ParseError(ParseError.ParseErrorKind.OFFSETDUPLE_UNREACHABLE);
        }
        ITokenDuple iTokenDuple = TokenFactory.createTokenDuple(this.firstTokenOfDuple, this.lastTokenOfDuple);
        if (!iTokenDuple.syntaxOfName()) {
            throw new ParseError(ParseError.ParseErrorKind.OFFSET_RANGE_NOT_NAME);
        }
        return this.provideSelectionNode(iTokenDuple);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IParser.ISelectionParseResult provideSelectionNode(ITokenDuple iTokenDuple) {
        ITokenDuple iTokenDuple2 = null;
        if (!iTokenDuple.equals(this.greaterContextDuple)) {
            if (iTokenDuple.getFirstToken().equals(this.greaterContextDuple.getFirstToken())) {
                iTokenDuple2 = iTokenDuple;
            } else {
                if (!iTokenDuple.getLastToken().equals(this.greaterContextDuple.getLastToken())) throw new ParseError(ParseError.ParseErrorKind.OFFSET_RANGE_NOT_NAME);
                iTokenDuple2 = this.greaterContextDuple;
            }
        } else {
            iTokenDuple2 = this.greaterContextDuple;
        }
        IASTNode iASTNode = this.lookupNode(iTokenDuple2);
        if (iASTNode == null) {
            return null;
        }
        if (iASTNode instanceof IASTOffsetableNamedElement) return new SelectionParseResult((IASTOffsetableNamedElement)((Object)iASTNode), new String(((IASTOffsetableElement)((Object)iASTNode)).getFilename()));
        return null;
    }

    protected IASTNode lookupNode(ITokenDuple iTokenDuple) {
        if (this.contextNode == null) {
            return null;
        }
        if (this.contextNode instanceof IASTDeclaration) {
            Object object;
            if (this.contextNode instanceof IASTOffsetableNamedElement && ((IASTOffsetableNamedElement)((Object)this.contextNode)).getName().equals(iTokenDuple.toString())) {
                return this.contextNode;
            }
            if (this.contextNode instanceof IASTQualifiedNameElement && Arrays.equals((Object[])(object = ((IASTQualifiedNameElement)((Object)this.contextNode)).getFullyQualifiedName()), iTokenDuple.toQualifiedName())) {
                return this.contextNode;
            }
            try {
                if (this.ourKind == IASTCompletionNode.CompletionKind.NEW_TYPE_REFERENCE && this.contextNode instanceof IASTVariable && (object = ((IASTVariable)this.contextNode).getInitializerClause()) != null) {
                    IASTExpression iASTExpression = object.findExpressionForDuple(iTokenDuple);
                    return this.astFactory.lookupSymbolInContext(this.ourScope, iTokenDuple, iASTExpression);
                }
                return this.astFactory.lookupSymbolInContext(this.ourScope, iTokenDuple, null);
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {
                return null;
            }
        }
        if (this.contextNode instanceof IASTExpression) {
            try {
                return this.astFactory.lookupSymbolInContext(this.ourScope, iTokenDuple, this.contextNode);
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {
                return null;
            }
        }
        return null;
    }

    public IASTCompletionNode parse(int n) {
        throw new ParseError(ParseError.ParseErrorKind.METHOD_NOT_IMPLEMENTED);
    }

    protected void checkEndOfFile() throws EndOfFileException {
    }

    protected void setGreaterNameContext(ITokenDuple iTokenDuple) {
        if (this.pastPointOfSelection) {
            return;
        }
        if (this.greaterContextDuple == null && this.scanner.isOnTopContext() && this.lastTokenOfDuple != null && this.firstTokenOfDuple != null) {
            if (iTokenDuple.getStartOffset() > this.lastTokenOfDuple.getEndOffset()) {
                this.pastPointOfSelection = true;
                return;
            }
            int n = 0;
            IToken iToken = iTokenDuple.getFirstToken();
            while (iToken != null) {
                if (iToken == this.firstTokenOfDuple) {
                    ++n;
                }
                if (iToken == this.lastTokenOfDuple) {
                    ++n;
                }
                if (iToken == iTokenDuple.getLastToken()) break;
                iToken = iToken.getNext();
            }
            if (n == 2) {
                this.greaterContextDuple = iTokenDuple;
                this.pastPointOfSelection = true;
            }
        }
    }

    protected void endDeclaration(IASTDeclaration iASTDeclaration) throws EndOfFileException {
        if (this.tokenDupleCompleted()) {
            this.contextNode = iASTDeclaration;
            throw new EndOfFileException();
        }
        super.endDeclaration(iASTDeclaration);
    }

    protected void endExpression(IASTExpression iASTExpression) throws EndOfFileException {
        if (this.tokenDupleCompleted()) {
            this.contextNode = iASTExpression;
            throw new EndOfFileException();
        }
        super.endExpression(iASTExpression);
    }

    protected void endEnumerator(IASTEnumerator iASTEnumerator) throws EndOfFileException {
        if (this.tokenDupleCompleted()) {
            this.contextNode = iASTEnumerator;
            throw new EndOfFileException();
        }
        super.endEnumerator(iASTEnumerator);
    }

    protected void handleClassSpecifier(IASTClassSpecifier iASTClassSpecifier) throws EndOfFileException {
        if (this.tokenDupleCompleted()) {
            this.contextNode = iASTClassSpecifier;
            throw new EndOfFileException();
        }
        super.handleClassSpecifier(iASTClassSpecifier);
    }

    protected void handleEnumeration(IASTEnumerationSpecifier iASTEnumerationSpecifier) throws EndOfFileException {
        if (this.tokenDupleCompleted()) {
            this.contextNode = iASTEnumerationSpecifier;
            throw new EndOfFileException();
        }
        super.handleEnumeration(iASTEnumerationSpecifier);
    }

    public static class SelectionParseResult
    implements IParser.ISelectionParseResult {
        private final String fileName;
        private final IASTOffsetableNamedElement node;

        public SelectionParseResult(IASTOffsetableNamedElement iASTOffsetableNamedElement, String string) {
            this.node = iASTOffsetableNamedElement;
            this.fileName = string;
        }

        public IASTOffsetableNamedElement getOffsetableNamedElement() {
            return this.node;
        }

        public String getFilename() {
            return this.fileName;
        }
    }
}

