/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class TemplateParameterManager {
    private final int counterId;
    private List list;
    private int emptySegmentCount;
    private static final int NUMBER_OF_INSTANCES = 8;
    private static final boolean[] instancesUsed = new boolean[8];
    private static final TemplateParameterManager[] counters = new TemplateParameterManager[8];
    private static int counter = 8;

    static {
        int n = 0;
        while (n < 8) {
            TemplateParameterManager.instancesUsed[n] = false;
            TemplateParameterManager.counters[n] = new TemplateParameterManager(n);
            ++n;
        }
    }

    protected void reset() {
        this.list = Collections.EMPTY_LIST;
        this.emptySegmentCount = 0;
    }

    private TemplateParameterManager(int n) {
        this.reset();
        this.counterId = n;
    }

    public List getTemplateArgumentsList() {
        return this.list;
    }

    public void addSegment(List list) {
        if (list == null) {
            if (this.list == Collections.EMPTY_LIST) {
                ++this.emptySegmentCount;
            } else {
                this.list.add(null);
            }
        } else {
            if (this.list == Collections.EMPTY_LIST) {
                this.list = new ArrayList();
                int n = 0;
                while (n < this.emptySegmentCount) {
                    this.list.add(null);
                    ++n;
                }
            }
            this.list.add(list);
        }
    }

    public static synchronized TemplateParameterManager getInstance() {
        int n = TemplateParameterManager.findFreeCounter();
        if (n == -1) {
            return new TemplateParameterManager(++counter);
        }
        TemplateParameterManager.instancesUsed[n] = true;
        return counters[n];
    }

    public static synchronized void returnInstance(TemplateParameterManager templateParameterManager) {
        if (templateParameterManager.counterId > 0 && templateParameterManager.counterId < 8) {
            TemplateParameterManager.instancesUsed[templateParameterManager.counterId] = false;
        }
        templateParameterManager.reset();
    }

    private static int findFreeCounter() {
        int n = 0;
        while (n < 8) {
            if (!instancesUsed[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

