/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.SymbolIterator;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTBaseSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.ast.complete.ReferenceCache;
import org.eclipse.cdt.internal.core.parser.ast.complete.UnresolvedReferenceDuple;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTClassSpecifier
extends ASTScope
implements IASTClassSpecifier {
    private List declarations = null;
    private final IASTClassSpecifier.ClassNameType classNameType;
    private final ASTClassKind classKind;
    private ASTAccessVisibility currentVisibility;
    private final ASTQualifiedNamedElement qualifiedName;
    private List references;
    private List unresolvedCrossReferences = Collections.EMPTY_LIST;
    private boolean processingUnresolvedReferences = false;
    private List resolvedCrossReferences = Collections.EMPTY_LIST;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;
    private final char[] fn;

    public ASTClassSpecifier(ISymbol iSymbol, ASTClassKind aSTClassKind, IASTClassSpecifier.ClassNameType classNameType, ASTAccessVisibility aSTAccessVisibility, int n, int n2, int n3, int n4, int n5, List list, char[] cArray) {
        super(iSymbol);
        this.classKind = aSTClassKind;
        this.classNameType = classNameType;
        this.currentVisibility = aSTAccessVisibility;
        this.setStartingOffsetAndLineNumber(n, n2);
        this.setNameOffset(n3);
        this.setNameEndOffsetAndLineNumber(n4, n5);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), iSymbol.getName());
        this.references = list;
        this.fn = cArray;
    }

    public IASTClassSpecifier.ClassNameType getClassNameType() {
        return this.classNameType;
    }

    public ASTClassKind getClassKind() {
        return this.classKind;
    }

    public Iterator getBaseClauses() {
        return new BaseIterator((IDerivableContainerSymbol)this.getSymbol());
    }

    private List getBaseClausesList() {
        List list = ((IDerivableContainerSymbol)this.getSymbol()).getParents();
        return list != null ? list : Collections.EMPTY_LIST;
    }

    public ASTAccessVisibility getCurrentVisibilityMode() {
        return this.currentVisibility;
    }

    public void setCurrentVisibility(ASTAccessVisibility aSTAccessVisibility) {
        this.currentVisibility = aSTAccessVisibility;
    }

    public String getName() {
        return String.valueOf(this.symbol.getName());
    }

    public char[] getNameCharArray() {
        return this.symbol.getName();
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        iReferenceManager.processReferences(this.references, iSourceElementRequestor);
        this.references = null;
        try {
            iSourceElementRequestor.enterClassSpecifier(this);
        }
        catch (Exception exception) {}
        List list = this.getBaseClausesList();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            IDerivableContainerSymbol.IParentSymbol iParentSymbol = (IDerivableContainerSymbol.IParentSymbol)list.get(n2);
            ASTBaseSpecifier aSTBaseSpecifier = new ASTBaseSpecifier(iParentSymbol.getParent(), iParentSymbol.isVirtual(), iParentSymbol.getAccess(), iParentSymbol.getOffset(), iParentSymbol.getReferences());
            aSTBaseSpecifier.acceptElement(iSourceElementRequestor, iReferenceManager);
            ++n2;
        }
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        iReferenceManager.processReferences(this.resolvedCrossReferences, iSourceElementRequestor);
        try {
            iSourceElementRequestor.exitClassSpecifier(this);
        }
        catch (Exception exception) {}
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedName.getFullyQualifiedNameCharArrays();
    }

    public IASTScope getOwnerScope() {
        return (IASTScope)((Object)this.symbol.getContainingSymbol().getASTExtension().getPrimaryDeclaration());
    }

    public Iterator getDeclarations() {
        if (this.declarations != null) {
            return this.declarations.iterator();
        }
        return super.getDeclarations();
    }

    public void addDeclaration(IASTDeclaration iASTDeclaration) {
        this.declarations.add(iASTDeclaration);
    }

    public void initDeclarations() {
        this.declarations = new ArrayList(0);
    }

    public void addUnresolvedReference(UnresolvedReferenceDuple unresolvedReferenceDuple) {
        if (!this.processingUnresolvedReferences) {
            if (this.unresolvedCrossReferences == Collections.EMPTY_LIST) {
                this.unresolvedCrossReferences = new ArrayList();
            }
            this.unresolvedCrossReferences.add(unresolvedReferenceDuple);
        }
    }

    public List getUnresolvedReferences() {
        return this.unresolvedCrossReferences;
    }

    public void setProcessingUnresolvedReferences(boolean bl) {
        this.processingUnresolvedReferences = bl;
    }

    public void setExtraReferences(List list, ReferenceCache referenceCache) {
        if (list != null && !list.isEmpty()) {
            int n = 0;
            while (n < list.size()) {
                IASTReference iASTReference = (IASTReference)list.get(n);
                if (this.resolvedCrossReferences == Collections.EMPTY_LIST) {
                    this.resolvedCrossReferences = new ArrayList(list.size());
                }
                this.resolvedCrossReferences.add(iASTReference);
                ++n;
            }
        }
    }

    public Iterator getFriends() {
        IDerivableContainerSymbol iDerivableContainerSymbol = (IDerivableContainerSymbol)this.getSymbol();
        return new SymbolIterator(iDerivableContainerSymbol.getFriends().iterator());
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public void setStartingOffsetAndLineNumber(int n, int n2) {
        this.startingOffset = n;
        this.startingLineNumber = n2;
    }

    public void setEndingOffsetAndLineNumber(int n, int n2) {
        this.endingOffset = n;
        this.endingLineNumber = n2;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameStartOffset;
    }

    public void setNameOffset(int n) {
        this.nameStartOffset = n;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int n, int n2) {
        this.nameEndOffset = n;
        this.nameLineNumber = n2;
    }

    public char[] getFilename() {
        return this.fn;
    }

    public class BaseIterator
    implements Iterator {
        private final Iterator parents;

        public BaseIterator(IDerivableContainerSymbol iDerivableContainerSymbol) {
            this.parents = iDerivableContainerSymbol.getParents() != null ? iDerivableContainerSymbol.getParents().iterator() : null;
        }

        public boolean hasNext() {
            if (this.parents == null) {
                return false;
            }
            return this.parents.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IDerivableContainerSymbol.IParentSymbol iParentSymbol = (IDerivableContainerSymbol.IParentSymbol)this.parents.next();
            return new ASTBaseSpecifier(iParentSymbol.getParent(), iParentSymbol.isVirtual(), iParentSymbol.getAccess(), iParentSymbol.getOffset(), iParentSymbol.getReferences());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

