/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTElaboratedTypeSpecifier
extends ASTSymbol
implements IASTElaboratedTypeSpecifier {
    private List references;
    private final boolean isForwardDeclaration;
    private final ASTClassKind kind;
    private final ASTQualifiedNamedElement qualifiedName;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;
    private final char[] fn;

    public ASTElaboratedTypeSpecifier(ISymbol iSymbol, ASTClassKind aSTClassKind, int n, int n2, int n3, int n4, int n5, int n6, int n7, List list, boolean bl, char[] cArray) {
        super(iSymbol);
        this.kind = aSTClassKind;
        this.setStartingOffsetAndLineNumber(n, n2);
        this.setNameOffset(n3);
        this.setNameEndOffsetAndLineNumber(n4, n5);
        this.setEndingOffsetAndLineNumber(n6, n7);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), iSymbol.getName());
        this.isForwardDeclaration = bl;
        this.references = list;
        this.fn = cArray;
    }

    public String getName() {
        return String.valueOf(this.getSymbol().getName());
    }

    public char[] getNameCharArray() {
        return this.getSymbol().getName();
    }

    public ASTClassKind getClassKind() {
        return this.kind;
    }

    public boolean isResolved() {
        return !this.getSymbol().isForwardDeclaration();
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        if (this.isForwardDeclaration) {
            try {
                iSourceElementRequestor.acceptElaboratedForewardDeclaration(this);
            }
            catch (Exception exception) {}
        }
        iReferenceManager.processReferences(this.references, iSourceElementRequestor);
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedName.getFullyQualifiedNameCharArrays();
    }

    public List getReferences() {
        return this.references;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof IASTElaboratedTypeSpecifier)) {
            return false;
        }
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)object;
        if (iASTElaboratedTypeSpecifier.getClassKind() != this.getClassKind()) {
            return false;
        }
        return iASTElaboratedTypeSpecifier.getName().equals(this.getName());
    }

    public int hashCode() {
        String string = this.getName().toString();
        return string.hashCode();
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public void setStartingOffsetAndLineNumber(int n, int n2) {
        this.startingOffset = n;
        this.startingLineNumber = n2;
    }

    public void setEndingOffsetAndLineNumber(int n, int n2) {
        this.endingOffset = n;
        this.endingLineNumber = n2;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameStartOffset;
    }

    public void setNameOffset(int n) {
        this.nameStartOffset = n;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int n, int n2) {
        this.nameEndOffset = n;
        this.nameLineNumber = n2;
    }

    public char[] getFilename() {
        return this.fn;
    }
}

