/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTEnumerationSpecifier
extends ASTSymbol
implements IASTEnumerationSpecifier {
    private final ASTQualifiedNamedElement qualifiedName;
    private final char[] fn;
    private List enumerators = Collections.EMPTY_LIST;
    private static final int ENUMERATOR_LIST_SIZE = 4;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTEnumerationSpecifier(ISymbol iSymbol, int n, int n2, int n3, int n4, int n5, char[] cArray) {
        super(iSymbol);
        this.setStartingOffsetAndLineNumber(n, n2);
        this.setNameOffset(n3);
        this.setNameEndOffsetAndLineNumber(n4, n5);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), iSymbol.getName());
        this.fn = cArray;
    }

    public void addEnumerator(IASTEnumerator iASTEnumerator) {
        if (this.enumerators == Collections.EMPTY_LIST) {
            this.enumerators = new ArrayList(4);
        }
        this.enumerators.add(iASTEnumerator);
    }

    public Iterator getEnumerators() {
        return this.enumerators.iterator();
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        try {
            iSourceElementRequestor.acceptEnumerationSpecifier(this);
        }
        catch (Exception exception) {}
        if (this.enumerators.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < this.enumerators.size()) {
            IASTEnumerator iASTEnumerator = (IASTEnumerator)this.enumerators.get(n);
            if (iASTEnumerator.getInitialValue() != null) {
                iASTEnumerator.getInitialValue().acceptElement(iSourceElementRequestor, iReferenceManager);
            }
            ++n;
        }
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public String getName() {
        return String.valueOf(this.getSymbol().getName());
    }

    public char[] getNameCharArray() {
        return this.getSymbol().getName();
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedName.getFullyQualifiedNameCharArrays();
    }

    public void freeReferences(IReferenceManager iReferenceManager) {
        if (this.enumerators.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < this.enumerators.size()) {
            ((IASTEnumerator)this.enumerators.get(n)).freeReferences(iReferenceManager);
            ++n;
        }
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public void setStartingOffsetAndLineNumber(int n, int n2) {
        this.startingOffset = n;
        this.startingLineNumber = n2;
    }

    public void setEndingOffsetAndLineNumber(int n, int n2) {
        this.endingOffset = n;
        this.endingLineNumber = n2;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameStartOffset;
    }

    public void setNameOffset(int n) {
        this.nameStartOffset = n;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int n, int n2) {
        this.nameEndOffset = n;
        this.nameLineNumber = n2;
    }
}

