/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTExpressionEvaluationException;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTIdExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNode;
import org.eclipse.cdt.internal.core.parser.ast.complete.ExpressionResult;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfoProvider;

public abstract class ASTExpression
extends ASTNode
implements IASTExpression {
    private final IASTExpression.Kind kind;
    private List references;
    private ExpressionResult resultType;
    private static final String EMPTY_STRING = "";
    private static final char[] EMPTY_CHAR_ARRAY = "".toCharArray();

    public ASTExpression(IASTExpression.Kind kind, List list) {
        this.kind = kind;
        this.references = list;
    }

    public IASTExpression.Kind getExpressionKind() {
        return this.kind;
    }

    public long evaluateExpression() throws ASTExpressionEvaluationException {
        throw new ASTExpressionEvaluationException();
    }

    public List getReferences() {
        return this.references;
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        try {
            this.reconcileReferences(iReferenceManager);
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {}
        iReferenceManager.processReferences(this.references, iSourceElementRequestor);
        this.references = null;
        this.processCallbacks(iSourceElementRequestor, iReferenceManager);
        try {
            this.purgeReferences();
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {}
    }

    protected void processCallbacks(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public ExpressionResult getResultType() {
        return this.resultType;
    }

    public void setResultType(ExpressionResult expressionResult) {
        this.resultType = expressionResult;
    }

    public void reconcileReferences(IReferenceManager iReferenceManager) throws ASTNotImplementedException {
    }

    protected void reconcileSubExpression(ASTExpression aSTExpression, IReferenceManager iReferenceManager) {
        if (aSTExpression != null && aSTExpression.getReferences() != null) {
            List list = aSTExpression.getReferences();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                IASTReference iASTReference = (IASTReference)list.get(n2);
                if (iASTReference != null && this.references.contains(iASTReference)) {
                    list.remove(n2--);
                    --n;
                    iReferenceManager.returnReference(iASTReference);
                }
                ++n2;
            }
        }
    }

    public void purgeReferences() throws ASTNotImplementedException {
    }

    protected void purgeSubExpression(ASTExpression aSTExpression) {
        if (aSTExpression != null && aSTExpression.getReferences() != null) {
            aSTExpression.getReferences().clear();
        }
    }

    protected String getStringPrefix() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ASTExpression w/Kind=");
        stringBuffer.append(this.kind.getKindName());
        return stringBuffer.toString();
    }

    public IContainerSymbol getLookupQualificationSymbol() throws IASTNode.LookupError {
        ExpressionResult expressionResult = this.getResultType();
        ITypeInfo iTypeInfo = expressionResult != null ? expressionResult.getResult() : null;
        IContainerSymbol iContainerSymbol = null;
        if (iTypeInfo != null && iTypeInfo.getTypeSymbol() != null) {
            TypeInfoProvider typeInfoProvider = iTypeInfo.getTypeSymbol().getSymbolTable().getTypeInfoProvider();
            if ((iTypeInfo = iTypeInfo.getFinalType(typeInfoProvider)).isType(ITypeInfo.t_type) && iTypeInfo.getTypeSymbol() != null && iTypeInfo.getTypeSymbol() instanceof IContainerSymbol) {
                iContainerSymbol = (IContainerSymbol)iTypeInfo.getTypeSymbol();
            }
            typeInfoProvider.returnTypeInfo(iTypeInfo);
        }
        return iContainerSymbol;
    }

    public boolean shouldFilterLookupResult(ISymbol iSymbol) {
        ITypeInfo iTypeInfo;
        ExpressionResult expressionResult = this.getResultType();
        ITypeInfo iTypeInfo2 = iTypeInfo = expressionResult != null ? expressionResult.getResult() : null;
        if (iTypeInfo != null) {
            boolean bl = false;
            TypeInfoProvider typeInfoProvider = iSymbol.getSymbolTable().getTypeInfoProvider();
            if ((iTypeInfo = iTypeInfo.getFinalType(typeInfoProvider)).checkBit(1024) && !iSymbol.getTypeInfo().checkBit(1024)) {
                bl = true;
            }
            if (iTypeInfo.checkBit(2048) && !iSymbol.getTypeInfo().checkBit(2048)) {
                bl = true;
            }
            typeInfoProvider.returnTypeInfo(iTypeInfo);
            return bl;
        }
        return false;
    }

    public ASTExpression findOwnerExpressionForIDExpression(ITokenDuple iTokenDuple) {
        return null;
    }

    protected ASTExpression recursiveFindExpressionForDuple(IASTExpression iASTExpression, ITokenDuple iTokenDuple) {
        if (iASTExpression == null) {
            return null;
        }
        return ((ASTExpression)iASTExpression).findOwnerExpressionForIDExpression(iTokenDuple);
    }

    protected boolean isIDExpressionForDuple(IASTExpression iASTExpression, ITokenDuple iTokenDuple) {
        if (iASTExpression == null) {
            return false;
        }
        if (iASTExpression.getExpressionKind() == IASTExpression.Kind.ID_EXPRESSION && iASTExpression instanceof ASTIdExpression) {
            ITokenDuple iTokenDuple2 = ((ASTIdExpression)iASTExpression).getIdExpressionTokenDuple();
            if (iTokenDuple2.equals(iTokenDuple)) {
                return true;
            }
            if (iTokenDuple2.contains(iTokenDuple)) {
                return true;
            }
        }
        return false;
    }

    public IASTExpression getLHSExpression() {
        return null;
    }

    public IASTExpression getRHSExpression() {
        return null;
    }

    public IASTExpression getThirdExpression() {
        return null;
    }

    public String getLiteralString() {
        return EMPTY_STRING;
    }

    public String getIdExpression() {
        return EMPTY_STRING;
    }

    public char[] getIdExpressionCharArray() {
        return EMPTY_CHAR_ARRAY;
    }

    public IASTTypeId getTypeId() {
        return null;
    }

    public IASTExpression.IASTNewExpressionDescriptor getNewExpressionDescriptor() {
        return null;
    }

    public IASTExpression findNewDescriptor(ITokenDuple iTokenDuple) {
        return null;
    }

    public void freeReferences(IReferenceManager iReferenceManager) {
        if (this.references == null || this.references.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < this.references.size()) {
            iReferenceManager.returnReference((IASTReference)this.references.get(n));
            ++n;
        }
        this.references.clear();
    }
}

