/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTArrayModifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;

public class ASTFunction
extends ASTScope
implements IASTFunction {
    private final boolean previouslyDeclared;
    private boolean hasFunctionBody = false;
    private final boolean isFriendDeclaration;
    private final IASTTemplate ownerTemplate;
    private final IASTAbstractDeclaration returnType;
    private final IASTExceptionSpecification exception;
    private final ASTQualifiedNamedElement qualifiedName;
    private final List parameters;
    protected List references;
    private List declarations = null;
    private final char[] fn;
    private boolean hasFunctionTryBlock = false;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTFunction(IParameterizedSymbol iParameterizedSymbol, int n, List list, IASTAbstractDeclaration iASTAbstractDeclaration, IASTExceptionSpecification iASTExceptionSpecification, int n2, int n3, int n4, int n5, IASTTemplate iASTTemplate, List list2, boolean bl, boolean bl2, boolean bl3, char[] cArray) {
        super(iParameterizedSymbol);
        this.parameters = list;
        this.returnType = iASTAbstractDeclaration;
        this.exception = iASTExceptionSpecification;
        this.setStartingOffsetAndLineNumber(n2, n3);
        this.setNameOffset(n4);
        this.setNameEndOffsetAndLineNumber(n, n5);
        this.ownerTemplate = iASTTemplate;
        this.references = list2;
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), iParameterizedSymbol.getName());
        this.previouslyDeclared = bl;
        this.hasFunctionTryBlock = bl2;
        this.isFriendDeclaration = bl3;
        this.fn = cArray;
    }

    public boolean isInline() {
        return this.symbol.getTypeInfo().checkBit(32);
    }

    public boolean isFriend() {
        return this.isFriendDeclaration;
    }

    public boolean isStatic() {
        return this.symbol.getTypeInfo().checkBit(4);
    }

    public String getName() {
        return String.valueOf(this.symbol.getName());
    }

    public IASTAbstractDeclaration getReturnType() {
        return this.returnType;
    }

    public Iterator getParameters() {
        return this.parameters.iterator();
    }

    public IASTExceptionSpecification getExceptionSpec() {
        return this.exception;
    }

    public void setHasFunctionBody(boolean bl) {
        this.hasFunctionBody = true;
    }

    public boolean hasFunctionBody() {
        return this.hasFunctionBody;
    }

    public IASTTemplate getOwnerTemplateDeclaration() {
        return this.ownerTemplate;
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedName.getFullyQualifiedNameCharArrays();
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        try {
            if (this.isFriend()) {
                iSourceElementRequestor.acceptFriendDeclaration(this);
            } else {
                iSourceElementRequestor.acceptFunctionDeclaration(this);
            }
        }
        catch (Exception exception) {}
        this.functionCallbacks(iSourceElementRequestor, iReferenceManager);
    }

    protected void functionCallbacks(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        iReferenceManager.processReferences(this.references, iSourceElementRequestor);
        this.references = null;
        this.processParameterInitializersAndArrayMods(iSourceElementRequestor, iReferenceManager);
        if (this.getReturnType() != null) {
            this.getReturnType().acceptElement(iSourceElementRequestor, iReferenceManager);
        }
    }

    protected void processParameterInitializersAndArrayMods(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        int n = this.parameters.size();
        int n2 = 0;
        while (n2 < n) {
            IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)this.parameters.get(n2);
            if (iASTParameterDeclaration.getDefaultValue() != null) {
                iASTParameterDeclaration.getDefaultValue().acceptElement(iSourceElementRequestor, iReferenceManager);
            }
            Iterator iterator = iASTParameterDeclaration.getArrayModifiers();
            while (iterator.hasNext()) {
                ((IASTArrayModifier)iterator.next()).acceptElement(iSourceElementRequestor, iReferenceManager);
            }
            ++n2;
        }
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        try {
            iSourceElementRequestor.enterFunctionBody(this);
        }
        catch (Exception exception) {}
        this.functionCallbacks(iSourceElementRequestor, iReferenceManager);
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        try {
            iSourceElementRequestor.exitFunctionBody(this);
        }
        catch (Exception exception) {}
    }

    public IASTCodeScope getOwnerCodeScope() {
        return this.getSymbol().getContainingSymbol().getASTExtension().getPrimaryDeclaration() instanceof IASTCodeScope ? (IASTCodeScope)((Object)this.getSymbol().getContainingSymbol().getASTExtension().getPrimaryDeclaration()) : null;
    }

    public boolean previouslyDeclared() {
        return this.previouslyDeclared;
    }

    public void setHasFunctionTryBlock(boolean bl) {
        this.hasFunctionTryBlock = bl;
    }

    public boolean hasFunctionTryBlock() {
        return this.hasFunctionTryBlock;
    }

    public Iterator getDeclarations() {
        if (this.declarations != null) {
            return this.declarations.iterator();
        }
        return super.getDeclarations();
    }

    public void addDeclaration(IASTDeclaration iASTDeclaration) {
        this.declarations.add(iASTDeclaration);
    }

    public void initDeclarations() {
        this.declarations = new ArrayList(0);
    }

    public boolean takesVarArgs() {
        return ((IParameterizedSymbol)this.getSymbol()).hasVariableArgs();
    }

    public IASTFunction getContainingFunction() {
        return this;
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public void setStartingOffsetAndLineNumber(int n, int n2) {
        this.startingOffset = n;
        this.startingLineNumber = n2;
    }

    public void setEndingOffsetAndLineNumber(int n, int n2) {
        this.endingOffset = n;
        this.endingLineNumber = n2;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameStartOffset;
    }

    public void setNameOffset(int n) {
        this.nameStartOffset = n;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int n, int n2) {
        this.nameEndOffset = n;
        this.nameLineNumber = n2;
    }

    public char[] getNameCharArray() {
        return this.symbol.getName();
    }
}

