/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTExpression;

public class ASTInitializerClause
implements IASTInitializerClause {
    private List references = new ArrayList();
    private IASTVariable ownerDeclaration = null;
    private final IASTInitializerClause.Kind kind;
    private final IASTExpression assignmentExpression;
    private final List initializerClauses;
    private final List designators;

    public ASTInitializerClause(IASTInitializerClause.Kind kind, IASTExpression iASTExpression, List list, List list2) {
        this.kind = kind;
        this.assignmentExpression = iASTExpression;
        this.initializerClauses = list;
        this.designators = list2;
    }

    public IASTInitializerClause.Kind getKind() {
        return this.kind;
    }

    public Iterator getInitializers() {
        if (this.initializerClauses == null) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        return this.initializerClauses.iterator();
    }

    public List getInitializersList() {
        return this.initializerClauses != null ? this.initializerClauses : Collections.EMPTY_LIST;
    }

    public IASTExpression getAssigmentExpression() {
        return this.assignmentExpression;
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        List list = this.getInitializersList();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ((IASTInitializerClause)list.get(n2)).acceptElement(iSourceElementRequestor, iReferenceManager);
            ++n2;
        }
        if (this.assignmentExpression != null) {
            this.assignmentExpression.acceptElement(iSourceElementRequestor, iReferenceManager);
        }
        iReferenceManager.processReferences(this.references, iSourceElementRequestor);
        this.references = null;
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public Iterator getDesignators() {
        return this.designators.iterator();
    }

    public List getDesignatorList() {
        return this.designators;
    }

    public void setOwnerVariableDeclaration(IASTVariable iASTVariable) {
        this.ownerDeclaration = iASTVariable;
        Iterator iterator = this.getInitializers();
        while (iterator.hasNext()) {
            ((IASTInitializerClause)iterator.next()).setOwnerVariableDeclaration(iASTVariable);
        }
    }

    public IASTVariable getOwnerVariableDeclaration() {
        return this.ownerDeclaration;
    }

    public List getReferences() {
        return this.references;
    }

    public IASTExpression findExpressionForDuple(ITokenDuple iTokenDuple) throws ASTNotImplementedException {
        if (this.kind == IASTInitializerClause.Kind.EMPTY) {
            return null;
        }
        if (this.kind == IASTInitializerClause.Kind.ASSIGNMENT_EXPRESSION || this.kind == IASTInitializerClause.Kind.DESIGNATED_ASSIGNMENT_EXPRESSION) {
            return ((ASTExpression)this.assignmentExpression).findNewDescriptor(iTokenDuple);
        }
        Iterator iterator = this.getInitializers();
        while (iterator.hasNext()) {
            IASTInitializerClause iASTInitializerClause = (IASTInitializerClause)iterator.next();
            IASTExpression iASTExpression = iASTInitializerClause.findExpressionForDuple(iTokenDuple);
            if (iASTExpression == null) continue;
            return iASTExpression;
        }
        return null;
    }
}

