/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTNamespaceDefinition
extends ASTScope
implements IASTNamespaceDefinition {
    private final ASTQualifiedNamedElement qualifiedName;
    private List declarations = null;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTNamespaceDefinition(ISymbol iSymbol, int n, int n2, int n3, int n4, int n5, char[] cArray) {
        super(iSymbol);
        this.setStartingOffsetAndLineNumber(n, n2);
        this.setNameOffset(n3);
        this.setNameEndOffsetAndLineNumber(n4, n5);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), iSymbol.getName());
        this.fn = cArray;
    }

    public String getName() {
        return String.valueOf(this.symbol.getName());
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        try {
            iSourceElementRequestor.enterNamespaceDefinition(this);
        }
        catch (Exception exception) {}
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        try {
            iSourceElementRequestor.exitNamespaceDefinition(this);
        }
        catch (Exception exception) {}
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedName.getFullyQualifiedNameCharArrays();
    }

    public Iterator getDeclarations() {
        if (this.declarations != null) {
            return this.declarations.iterator();
        }
        return super.getDeclarations();
    }

    public void addDeclaration(IASTDeclaration iASTDeclaration) {
        this.declarations.add(iASTDeclaration);
    }

    public void initDeclarations() {
        this.declarations = new ArrayList(0);
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public void setStartingOffsetAndLineNumber(int n, int n2) {
        this.startingOffset = n;
        this.startingLineNumber = n2;
    }

    public void setEndingOffsetAndLineNumber(int n, int n2) {
        this.endingOffset = n;
        this.endingLineNumber = n2;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameStartOffset;
    }

    public void setNameOffset(int n) {
        this.nameStartOffset = n;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int n, int n2) {
        this.nameEndOffset = n;
        this.nameLineNumber = n2;
    }

    public char[] getNameCharArray() {
        return this.symbol.getName();
    }
}

