/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbolOwner;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolOwner;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableError;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfoProvider;

public abstract class ASTSymbol
extends ASTSymbolOwner
implements ISymbolOwner,
IASTDeclaration {
    public ASTSymbol(ISymbol iSymbol) {
        super(iSymbol);
    }

    public IASTScope getOwnerScope() {
        if (this.symbol.getContainingSymbol() != null) {
            return (IASTScope)((Object)this.symbol.getContainingSymbol().getASTExtension().getPrimaryDeclaration());
        }
        return null;
    }

    public IContainerSymbol getLookupQualificationSymbol() throws IASTNode.LookupError {
        ISymbol iSymbol = this.getSymbol();
        IContainerSymbol iContainerSymbol = null;
        TypeInfoProvider typeInfoProvider = iSymbol.getSymbolTable().getTypeInfoProvider();
        ITypeInfo iTypeInfo = null;
        try {
            iTypeInfo = iSymbol.getTypeInfo().getFinalType(typeInfoProvider);
        }
        catch (ParserSymbolTableError parserSymbolTableError) {
            throw new IASTNode.LookupError();
        }
        if (iTypeInfo.isType(ITypeInfo.t_type) && iTypeInfo.getTypeSymbol() != null && iTypeInfo.getTypeSymbol() instanceof IContainerSymbol) {
            iContainerSymbol = (IContainerSymbol)iTypeInfo.getTypeSymbol();
        } else if (iSymbol instanceof IContainerSymbol) {
            iContainerSymbol = (IContainerSymbol)iSymbol;
        }
        typeInfoProvider.returnTypeInfo(iTypeInfo);
        return iContainerSymbol;
    }

    public boolean shouldFilterLookupResult(ISymbol iSymbol) {
        boolean bl = false;
        TypeInfoProvider typeInfoProvider = iSymbol.getSymbolTable().getTypeInfoProvider();
        ITypeInfo iTypeInfo = null;
        try {
            iTypeInfo = this.getSymbol().getTypeInfo().getFinalType(typeInfoProvider);
        }
        catch (ParserSymbolTableError parserSymbolTableError) {
            return true;
        }
        if (iTypeInfo.checkBit(1024) && !iSymbol.getTypeInfo().checkBit(1024)) {
            bl = true;
        }
        if (iTypeInfo.checkBit(2048) && !iSymbol.getTypeInfo().checkBit(2048)) {
            bl = true;
        }
        typeInfoProvider.returnTypeInfo(iTypeInfo);
        return bl;
    }
}

