/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNode;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateFactory;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.StandardSymbolExtension;

public class ASTTemplateDeclaration
extends ASTSymbol
implements IASTTemplateDeclaration {
    private final List templateParameters;
    private ISymbol owned = null;
    private IASTScope ownerScope;
    private ITemplateFactory factory;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;

    public char[] getFilename() {
        return this.fn;
    }

    private ITemplateSymbol getTemplateSymbol() {
        return (ITemplateSymbol)(this.getSymbol() instanceof ITemplateSymbol ? this.getSymbol() : null);
    }

    public ASTTemplateDeclaration(ITemplateSymbol iTemplateSymbol, IASTScope iASTScope, List list, char[] cArray) {
        super(iTemplateSymbol);
        IContainerSymbol iContainerSymbol = null;
        iContainerSymbol = iASTScope instanceof ASTTemplateDeclaration ? ((ASTTemplateDeclaration)iASTScope).getContainerSymbol() : ((ASTScope)iASTScope).getContainerSymbol();
        if (iContainerSymbol instanceof ITemplateFactory) {
            this.factory = (ITemplateFactory)iContainerSymbol;
        } else {
            this.factory = iTemplateSymbol.getSymbolTable().newTemplateFactory();
            this.factory.setContainingSymbol(iContainerSymbol);
            this.factory.setASTExtension(new StandardSymbolExtension(this.factory, this));
        }
        this.factory.pushTemplate(iTemplateSymbol);
        this.templateParameters = list != null ? list : Collections.EMPTY_LIST;
        this.ownerScope = iASTScope;
        this.fn = cArray;
    }

    public IASTScope getOwnerScope() {
        return this.ownerScope;
    }

    public boolean isExported() {
        return false;
    }

    public IASTDeclaration getOwnedDeclaration() {
        if (this.owned != null && this.owned.getASTExtension() != null) {
            ISymbolASTExtension iSymbolASTExtension = this.owned.getASTExtension();
            Iterator iterator = iSymbolASTExtension.getAllDefinitions();
            ASTSymbol aSTSymbol = null;
            while (iterator.hasNext()) {
                aSTSymbol = (ASTSymbol)iterator.next();
            }
            return aSTSymbol;
        }
        IContainerSymbol iContainerSymbol = this.getTemplateSymbol().getTemplatedSymbol();
        if (iContainerSymbol != null && iContainerSymbol.getASTExtension() != null) {
            ASTNode aSTNode = iContainerSymbol.getASTExtension().getPrimaryDeclaration();
            return aSTNode instanceof IASTDeclaration ? (IASTDeclaration)((Object)aSTNode) : null;
        }
        return null;
    }

    public void setOwnedDeclaration(ISymbol iSymbol) {
        this.owned = iSymbol;
    }

    public void releaseFactory() {
        this.factory = null;
    }

    public IContainerSymbol getContainerSymbol() {
        return this.factory != null ? this.factory : this.getTemplateSymbol();
    }

    public Iterator getTemplateParameters() {
        return this.templateParameters.iterator();
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        try {
            iSourceElementRequestor.enterTemplateDeclaration(this);
        }
        catch (Exception exception) {}
        if (this.templateParameters == null || this.templateParameters.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < this.templateParameters.size()) {
            ((IASTTemplateParameter)this.templateParameters.get(n)).acceptElement(iSourceElementRequestor, iReferenceManager);
            ++n;
        }
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        try {
            iSourceElementRequestor.exitTemplateDeclaration(this);
        }
        catch (Exception exception) {}
    }

    public void setOwnedDeclaration(IASTDeclaration iASTDeclaration) {
    }

    public Iterator getDeclarations() throws ASTNotImplementedException {
        return null;
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int n, int n2) {
        this.startingOffset = n;
        this.startingLineNumber = n2;
    }

    public final void setEndingOffsetAndLineNumber(int n, int n2) {
        this.endingOffset = n;
        this.endingLineNumber = n2;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }
}

