/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTParameterDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;

public class ASTTemplateParameter
extends ASTSymbol
implements IASTTemplateParameter,
IASTOffsetableNamedElement {
    private IASTTypeId defaultValue;
    private ASTParameterDeclaration parameter;
    private List parms;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTTemplateParameter(ISymbol iSymbol, IASTTypeId iASTTypeId, IASTParameterDeclaration iASTParameterDeclaration, List list, int n, int n2, int n3, int n4, int n5, int n6, int n7, char[] cArray) {
        super(iSymbol);
        this.symbol = iSymbol;
        this.defaultValue = iASTTypeId;
        this.parameter = (ASTParameterDeclaration)iASTParameterDeclaration;
        this.parms = list;
        this.setStartingOffsetAndLineNumber(n, n2);
        this.setEndingOffsetAndLineNumber(n6, n7);
        this.setNameOffset(n3);
        this.setNameEndOffsetAndLineNumber(n4, n5);
        this.fn = cArray;
    }

    public IASTTemplateParameter.ParamKind getTemplateParameterKind() {
        ITypeInfo.eType eType2 = this.symbol.getTypeInfo().getTemplateParameterType();
        if (eType2 == ITypeInfo.t_typeName) {
            return IASTTemplateParameter.ParamKind.TYPENAME;
        }
        if (eType2 == ITypeInfo.t_template) {
            return IASTTemplateParameter.ParamKind.TEMPLATE_LIST;
        }
        return IASTTemplateParameter.ParamKind.PARAMETER;
    }

    public String getIdentifier() {
        return String.valueOf(this.symbol.getName());
    }

    public String getDefaultValueIdExpression() {
        return this.defaultValue != null ? this.defaultValue.toString() : "";
    }

    public IASTParameterDeclaration getParameterDeclaration() {
        return this.parameter;
    }

    public Iterator getTemplateParameters() {
        return this.parms.iterator();
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        if (this.defaultValue != null) {
            this.defaultValue.acceptElement(iSourceElementRequestor, iReferenceManager);
        }
        if (this.parameter != null) {
            this.parameter.acceptElement(iSourceElementRequestor, iReferenceManager);
        }
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public String getName() {
        return String.valueOf(this.symbol.getName());
    }

    public char[] getNameCharArray() {
        return this.symbol.getName();
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public void setStartingOffsetAndLineNumber(int n, int n2) {
        this.startingOffset = n;
        this.startingLineNumber = n2;
    }

    public void setEndingOffsetAndLineNumber(int n, int n2) {
        this.endingOffset = n;
        this.endingLineNumber = n2;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameStartOffset;
    }

    public void setNameOffset(int n) {
        this.nameStartOffset = n;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int n, int n2) {
        this.nameEndOffset = n;
        this.nameLineNumber = n2;
    }
}

