/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.IASTArrayModifier;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.complete.ReferenceCache;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTTypeId
implements IASTTypeId {
    private final boolean isTypename;
    private final boolean isUnsigned;
    private final boolean isSigned;
    private final boolean isShort;
    private final boolean isLong;
    private final boolean isVolatile;
    private final boolean isConst;
    private final char[] signature;
    private ITokenDuple tokenDuple;
    private final List arrayModifiers;
    private final char[] typeName;
    private final List pointerOps;
    private final IASTSimpleTypeSpecifier.Type kind;
    private List references = null;
    private ISymbol symbol;

    public ASTTypeId(IASTSimpleTypeSpecifier.Type type, ITokenDuple iTokenDuple, List list, List list2, char[] cArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        this.typeName = iTokenDuple == null ? "".toCharArray() : iTokenDuple.toCharArray();
        this.tokenDuple = iTokenDuple;
        this.kind = type;
        this.pointerOps = list;
        this.arrayModifiers = list2;
        this.signature = cArray;
        this.isConst = bl;
        this.isVolatile = bl2;
        this.isUnsigned = bl3;
        this.isSigned = bl4;
        this.isShort = bl5;
        this.isLong = bl6;
        this.isTypename = bl7;
    }

    public IASTSimpleTypeSpecifier.Type getKind() {
        return this.kind;
    }

    public String getTypeOrClassName() {
        return String.valueOf(this.typeName);
    }

    public char[] getTypeOrClassNameCharArray() {
        return this.typeName;
    }

    public Iterator getPointerOperators() {
        return this.pointerOps.iterator();
    }

    public List getPointerOperatorsList() {
        return this.pointerOps;
    }

    public Iterator getArrayModifiers() {
        return this.arrayModifiers.iterator();
    }

    public List getArrayModifiersList() {
        return this.arrayModifiers;
    }

    public List getReferences() {
        return this.references == null ? Collections.EMPTY_LIST : this.references;
    }

    public ITokenDuple getTokenDuple() {
        return this.tokenDuple;
    }

    public String getFullSignature() {
        return String.valueOf(this.signature);
    }

    public char[] getFullSignatureCharArray() {
        return this.signature;
    }

    public ISymbol getTypeSymbol() {
        return this.symbol;
    }

    public void setTypeSymbol(ISymbol iSymbol) {
        this.symbol = iSymbol;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public boolean isLong() {
        return this.isLong;
    }

    public boolean isShort() {
        return this.isShort;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isTypename() {
        return this.isTypename;
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        iReferenceManager.processReferences(this.references, iSourceElementRequestor);
        this.references = null;
        if (this.tokenDuple != null) {
            this.tokenDuple.acceptElement(iSourceElementRequestor, iReferenceManager);
        }
        List list = this.getArrayModifiersList();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ((IASTArrayModifier)list.get(n2)).acceptElement(iSourceElementRequestor, iReferenceManager);
            ++n2;
        }
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public void addReferences(List list, ReferenceCache referenceCache) {
        if (this.references == null) {
            this.references = new ArrayList(list.size());
        }
        int n = 0;
        while (n < list.size()) {
            this.references.add(list.get(n));
            ++n;
        }
    }

    public void freeReferences(IReferenceManager iReferenceManager) {
        if (this.tokenDuple != null) {
            this.tokenDuple.freeReferences(iReferenceManager);
        }
        if (this.references == null || this.references.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < this.references.size()) {
            iReferenceManager.returnReference((IASTReference)this.references.get(n));
            ++n;
        }
        this.references.clear();
    }
}

