/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTTypedef
extends ASTSymbol
implements IASTTypedefDeclaration {
    private final IASTAbstractDeclaration mapping;
    private final ASTQualifiedNamedElement qualifiedName;
    private List references;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTTypedef(ISymbol iSymbol, IASTAbstractDeclaration iASTAbstractDeclaration, int n, int n2, int n3, int n4, int n5, List list, char[] cArray) {
        super(iSymbol);
        this.mapping = iASTAbstractDeclaration;
        this.references = list;
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), iSymbol.getName());
        this.setStartingOffsetAndLineNumber(n, n2);
        this.setNameOffset(n3);
        this.setNameEndOffsetAndLineNumber(n4, n5);
        this.fn = cArray;
    }

    public String getName() {
        return String.valueOf(this.getSymbol().getName());
    }

    public IASTAbstractDeclaration getAbstractDeclarator() {
        return this.mapping;
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        try {
            iSourceElementRequestor.acceptTypedefDeclaration(this);
        }
        catch (Exception exception) {}
        iReferenceManager.processReferences(this.references, iSourceElementRequestor);
        this.references = null;
        this.getAbstractDeclarator().acceptElement(iSourceElementRequestor, iReferenceManager);
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedName.getFullyQualifiedNameCharArrays();
    }

    public IASTTypeSpecifier getFinalTypeSpecifier() throws ASTNotImplementedException {
        IASTTypeSpecifier iASTTypeSpecifier = this.mapping.getTypeSpecifier();
        while (iASTTypeSpecifier instanceof IASTSimpleTypeSpecifier || iASTTypeSpecifier instanceof IASTTypedefDeclaration) {
            if (iASTTypeSpecifier instanceof IASTSimpleTypeSpecifier) {
                IASTSimpleTypeSpecifier iASTSimpleTypeSpecifier = (IASTSimpleTypeSpecifier)iASTTypeSpecifier;
                if (iASTSimpleTypeSpecifier.getType() != IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME) break;
                iASTTypeSpecifier = iASTSimpleTypeSpecifier.getTypeSpecifier();
                continue;
            }
            if (!(iASTTypeSpecifier instanceof IASTTypedefDeclaration)) continue;
            iASTTypeSpecifier = ((IASTTypedefDeclaration)iASTTypeSpecifier).getAbstractDeclarator().getTypeSpecifier();
        }
        return iASTTypeSpecifier;
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public void setStartingOffsetAndLineNumber(int n, int n2) {
        this.startingOffset = n;
        this.startingLineNumber = n2;
    }

    public void setEndingOffsetAndLineNumber(int n, int n2) {
        this.endingOffset = n;
        this.endingLineNumber = n2;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameStartOffset;
    }

    public void setNameOffset(int n) {
        this.nameStartOffset = n;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int n, int n2) {
        this.nameEndOffset = n;
        this.nameLineNumber = n2;
    }

    public char[] getNameCharArray() {
        return this.getSymbol().getName();
    }
}

