/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTAnonymousDeclaration;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDirectiveSymbol;

public class ASTUsingDirective
extends ASTAnonymousDeclaration
implements IASTUsingDirective {
    private final IUsingDirectiveSymbol using;
    private List references;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTUsingDirective(IContainerSymbol iContainerSymbol, IUsingDirectiveSymbol iUsingDirectiveSymbol, int n, int n2, int n3, int n4, List list, char[] cArray) {
        super(iContainerSymbol);
        this.using = iUsingDirectiveSymbol;
        this.setStartingOffsetAndLineNumber(n, n2);
        this.setEndingOffsetAndLineNumber(n3, n4);
        this.references = list;
        this.fn = cArray;
    }

    public String getNamespaceName() {
        IASTNamespaceDefinition iASTNamespaceDefinition = this.getNamespaceDefinition();
        String[] stringArray = iASTNamespaceDefinition.getFullyQualifiedName();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n + 1 != stringArray.length) {
                stringBuffer.append("::");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        try {
            iSourceElementRequestor.acceptUsingDirective(this);
        }
        catch (Exception exception) {}
        iReferenceManager.processReferences(this.references, iSourceElementRequestor);
        this.references = null;
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public IASTNamespaceDefinition getNamespaceDefinition() {
        IContainerSymbol iContainerSymbol = this.using.getNamespace();
        return (IASTNamespaceDefinition)((Object)iContainerSymbol.getASTExtension().getPrimaryDeclaration());
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int n, int n2) {
        this.startingOffset = n;
        this.startingLineNumber = n2;
    }

    public final void setEndingOffsetAndLineNumber(int n, int n2) {
        this.endingOffset = n;
        this.endingLineNumber = n2;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }
}

