/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTVariable
extends ASTSymbol
implements IASTVariable {
    private final IASTExpression constructorExpression;
    private final ASTQualifiedNamedElement qualifiedName;
    private final IASTExpression bitfieldExpression;
    private final IASTInitializerClause initializerClause;
    private final IASTAbstractDeclaration abstractDeclaration;
    protected List references;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTVariable(ISymbol iSymbol, IASTAbstractDeclaration iASTAbstractDeclaration, IASTInitializerClause iASTInitializerClause, IASTExpression iASTExpression, int n, int n2, int n3, int n4, int n5, List list, IASTExpression iASTExpression2, boolean bl, char[] cArray) {
        super(iSymbol);
        this.abstractDeclaration = iASTAbstractDeclaration;
        this.initializerClause = iASTInitializerClause;
        this.bitfieldExpression = iASTExpression;
        this.constructorExpression = iASTExpression2;
        this.setStartingOffsetAndLineNumber(n, n2);
        this.setNameOffset(n3);
        this.setNameEndOffsetAndLineNumber(n4, n5);
        this.references = list;
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), iSymbol.getName());
        this.fn = cArray;
    }

    public boolean isAuto() {
        return this.symbol.getTypeInfo().checkBit(1);
    }

    public boolean isRegister() {
        return this.symbol.getTypeInfo().checkBit(2);
    }

    public boolean isStatic() {
        return this.symbol.getTypeInfo().checkBit(4);
    }

    public boolean isExtern() {
        return this.symbol.getTypeInfo().checkBit(8);
    }

    public boolean isMutable() {
        return this.symbol.getTypeInfo().checkBit(16);
    }

    public IASTAbstractDeclaration getAbstractDeclaration() {
        return this.abstractDeclaration;
    }

    public String getName() {
        return String.valueOf(this.getSymbol().getName());
    }

    public IASTInitializerClause getInitializerClause() {
        return this.initializerClause;
    }

    public boolean isBitfield() {
        return this.bitfieldExpression != null;
    }

    public IASTExpression getBitfieldExpression() {
        return this.bitfieldExpression;
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedName.getFullyQualifiedNameCharArrays();
    }

    public IASTScope getOwnerScope() {
        return (IASTScope)((Object)this.getSymbol().getContainingSymbol().getASTExtension().getPrimaryDeclaration());
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        try {
            iSourceElementRequestor.acceptVariable(this);
        }
        catch (Exception exception) {}
        iReferenceManager.processReferences(this.references, iSourceElementRequestor);
        this.references = null;
        if (this.initializerClause != null) {
            this.initializerClause.acceptElement(iSourceElementRequestor, iReferenceManager);
        }
        if (this.constructorExpression != null) {
            this.constructorExpression.acceptElement(iSourceElementRequestor, iReferenceManager);
        }
        if (this.getAbstractDeclaration() != null) {
            this.getAbstractDeclaration().acceptElement(iSourceElementRequestor, iReferenceManager);
        }
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public IASTExpression getConstructorExpression() {
        return this.constructorExpression;
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int n, int n2) {
        this.startingOffset = n;
        this.startingLineNumber = n2;
    }

    public final void setEndingOffsetAndLineNumber(int n, int n2) {
        this.endingOffset = n;
        this.endingLineNumber = n2;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }

    public final int getNameOffset() {
        return this.nameStartOffset;
    }

    public final void setNameOffset(int n) {
        this.nameStartOffset = n;
    }

    public final int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public final void setNameEndOffsetAndLineNumber(int n, int n2) {
        this.nameEndOffset = n;
        this.nameLineNumber = n2;
    }

    public char[] getNameCharArray() {
        return this.getSymbol().getName();
    }
}

