/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationReference;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTEnumeratorReference;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTFunctionReference;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTMethodReference;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceReference;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefReference;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayUtils;

public class ReferenceCache
implements IReferenceManager {
    private static final int DEFAULT_CACHE_SIZE = 64;
    private boolean[] classReferencesAvailable;
    private ASTReference[] classReferences = CLASSREF_FACTORY.createReferenceArray(64);
    private boolean[] variableReferencesAvailable;
    private ASTReference[] variableReferences = VARIABLEREF_FACTORY.createReferenceArray(64);
    private boolean[] fieldReferencesAvailable;
    private ASTReference[] fieldReferences = FIELDREF_FACTORY.createReferenceArray(64);
    private boolean[] functionReferencesAvailable;
    private ASTReference[] functionReferences = FUNCTIONREF_FACTORY.createReferenceArray(64);
    private boolean[] methodReferencesAvailable;
    private ASTReference[] methodReferences = METHODREF_FACTORY.createReferenceArray(64);
    private boolean[] enumerationReferencesAvailable;
    private ASTReference[] enumerationReferences = ENUMSPECREF_FACTORY.createReferenceArray(64);
    private boolean[] enumeratorReferencesAvailable;
    private ASTReference[] enumeratorReferences = ENUMERATORREF_FACTORY.createReferenceArray(64);
    private boolean[] namespaceReferencesAvailable;
    private ASTReference[] namespaceReferences = NAMESPACEREF_FACTORY.createReferenceArray(64);
    private boolean[] typedefReferencesAvailable;
    private ASTReference[] typedefReferences = TYPEDEFREF_FACTORY.createReferenceArray(64);
    private boolean[] parameterReferencesAvailable;
    private ASTReference[] parameterReferences = PARMREF_FACTORY.createReferenceArray(64);
    private boolean[] templateParameterReferencesAvailable;
    private ASTReference[] templateParameterReferences = TEMPPARMREF_FACTORY.createReferenceArray(64);
    private static final IReferenceFactory TYPEDEFREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTTypedefReference();
        }
    };
    private static final IReferenceFactory NAMESPACEREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTNamespaceReference();
        }
    };
    private static final IReferenceFactory PARMREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTParameterReference();
        }
    };
    private static final IReferenceFactory TEMPPARMREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTTemplateParameterReference();
        }
    };
    private static final IReferenceFactory CLASSREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTClassReference();
        }
    };
    private static final IReferenceFactory FUNCTIONREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTFunctionReference();
        }
    };
    private static final IReferenceFactory METHODREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTMethodReference();
        }
    };
    private static final IReferenceFactory VARIABLEREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTVariableReference();
        }
    };
    private static final IReferenceFactory FIELDREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTFieldReference();
        }
    };
    private static final IReferenceFactory ENUMSPECREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTEnumerationReference();
        }
    };
    private static final IReferenceFactory ENUMERATORREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTEnumeratorReference();
        }
    };
    protected static final GrowResult growResult = new GrowResult();

    public ReferenceCache() {
        this.classReferencesAvailable = new boolean[64];
        this.variableReferencesAvailable = new boolean[64];
        this.fieldReferencesAvailable = new boolean[64];
        this.functionReferencesAvailable = new boolean[64];
        this.methodReferencesAvailable = new boolean[64];
        this.enumerationReferencesAvailable = new boolean[64];
        this.enumeratorReferencesAvailable = new boolean[64];
        this.templateParameterReferencesAvailable = new boolean[64];
        this.namespaceReferencesAvailable = new boolean[64];
        this.typedefReferencesAvailable = new boolean[64];
        this.parameterReferencesAvailable = new boolean[64];
        int n = 0;
        while (n < 64) {
            this.classReferencesAvailable[n] = true;
            this.variableReferencesAvailable[n] = true;
            this.fieldReferencesAvailable[n] = true;
            this.functionReferencesAvailable[n] = true;
            this.methodReferencesAvailable[n] = true;
            this.enumerationReferencesAvailable[n] = true;
            this.enumeratorReferencesAvailable[n] = true;
            this.namespaceReferencesAvailable[n] = true;
            this.typedefReferencesAvailable[n] = true;
            this.parameterReferencesAvailable[n] = true;
            this.templateParameterReferencesAvailable[n] = true;
            this.methodReferences[n] = METHODREF_FACTORY.createReference();
            this.classReferences[n] = CLASSREF_FACTORY.createReference();
            this.variableReferences[n] = VARIABLEREF_FACTORY.createReference();
            this.fieldReferences[n] = FIELDREF_FACTORY.createReference();
            this.functionReferences[n] = FUNCTIONREF_FACTORY.createReference();
            this.enumerationReferences[n] = ENUMSPECREF_FACTORY.createReference();
            this.enumeratorReferences[n] = ENUMERATORREF_FACTORY.createReference();
            this.typedefReferences[n] = TYPEDEFREF_FACTORY.createReference();
            this.namespaceReferences[n] = NAMESPACEREF_FACTORY.createReference();
            this.parameterReferences[n] = PARMREF_FACTORY.createReference();
            this.templateParameterReferences[n] = TEMPPARMREF_FACTORY.createReference();
            ++n;
        }
    }

    public void returnReference(IASTReference iASTReference) {
        if (iASTReference instanceof IASTClassReference) {
            this.returnReference(this.classReferencesAvailable, this.classReferences, iASTReference);
            return;
        }
        if (iASTReference instanceof IASTVariableReference) {
            this.returnReference(this.variableReferencesAvailable, this.variableReferences, iASTReference);
            return;
        }
        if (iASTReference instanceof IASTFieldReference) {
            this.returnReference(this.fieldReferencesAvailable, this.fieldReferences, iASTReference);
            return;
        }
        if (iASTReference instanceof IASTFunctionReference) {
            this.returnReference(this.functionReferencesAvailable, this.functionReferences, iASTReference);
            return;
        }
        if (iASTReference instanceof IASTMethodReference) {
            this.returnReference(this.methodReferencesAvailable, this.methodReferences, iASTReference);
            return;
        }
        if (iASTReference instanceof IASTEnumerationReference) {
            this.returnReference(this.enumerationReferencesAvailable, this.enumerationReferences, iASTReference);
            return;
        }
        if (iASTReference instanceof IASTEnumeratorReference) {
            this.returnReference(this.enumeratorReferencesAvailable, this.enumeratorReferences, iASTReference);
            return;
        }
        if (iASTReference instanceof IASTNamespaceReference) {
            this.returnReference(this.namespaceReferencesAvailable, this.namespaceReferences, iASTReference);
            return;
        }
        if (iASTReference instanceof IASTTypedefReference) {
            this.returnReference(this.typedefReferencesAvailable, this.typedefReferences, iASTReference);
            return;
        }
        if (iASTReference instanceof IASTParameterReference) {
            this.returnReference(this.parameterReferencesAvailable, this.parameterReferences, iASTReference);
            return;
        }
        if (iASTReference instanceof IASTTemplateParameterReference) {
            this.returnReference(this.templateParameterReferencesAvailable, this.templateParameterReferences, iASTReference);
        }
    }

    private void returnReference(boolean[] blArray, ASTReference[] aSTReferenceArray, IASTReference iASTReference) {
        int n = 0;
        while (n < blArray.length) {
            if (aSTReferenceArray[n] == iASTReference) {
                blArray[n] = true;
                aSTReferenceArray[n].reset();
                break;
            }
            ++n;
        }
    }

    public IASTReference getReference(int n, ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
        if (iSourceElementCallbackDelegate instanceof IASTTypedefDeclaration) {
            return this.getTypedefReference(n, (IASTTypedefDeclaration)iSourceElementCallbackDelegate);
        }
        if (iSourceElementCallbackDelegate instanceof IASTEnumerationSpecifier) {
            return this.getEnumerationReference(n, (IASTEnumerationSpecifier)iSourceElementCallbackDelegate);
        }
        if (iSourceElementCallbackDelegate instanceof IASTTemplateParameter) {
            return this.getTemplateParameterReference(n, (IASTTemplateParameter)iSourceElementCallbackDelegate);
        }
        if (iSourceElementCallbackDelegate instanceof IASTParameterDeclaration) {
            return this.getParameterReference(n, (IASTParameterDeclaration)iSourceElementCallbackDelegate);
        }
        if (iSourceElementCallbackDelegate instanceof IASTTypeSpecifier) {
            return this.getClassReference(n, iSourceElementCallbackDelegate);
        }
        if (iSourceElementCallbackDelegate instanceof IASTNamespaceDefinition) {
            return this.getNamespaceReference(n, (IASTNamespaceDefinition)iSourceElementCallbackDelegate);
        }
        if (iSourceElementCallbackDelegate instanceof IASTMethod) {
            return this.getMethodReference(n, (IASTMethod)iSourceElementCallbackDelegate);
        }
        if (iSourceElementCallbackDelegate instanceof IASTFunction) {
            return this.getFunctionReference(n, (IASTFunction)iSourceElementCallbackDelegate);
        }
        if (iSourceElementCallbackDelegate instanceof IASTField) {
            return this.getFieldReference(n, (IASTField)iSourceElementCallbackDelegate);
        }
        if (iSourceElementCallbackDelegate instanceof IASTVariable) {
            return this.getVariableReference(n, (IASTVariable)iSourceElementCallbackDelegate);
        }
        if (iSourceElementCallbackDelegate instanceof IASTEnumerator) {
            return this.getEnumeratorReference(n, (IASTEnumerator)iSourceElementCallbackDelegate);
        }
        return null;
    }

    private IASTReference getClassReference(int n, ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
        int n2 = 0;
        while (n2 < this.classReferencesAvailable.length) {
            if (this.classReferencesAvailable[n2]) {
                this.classReferencesAvailable[n2] = false;
                this.classReferences[n2].initialize(n, iSourceElementCallbackDelegate);
                return this.classReferences[n2];
            }
            ++n2;
        }
        n2 = this.classReferences.length;
        GrowResult growResult = ReferenceCache.growArrays(this.classReferences, this.classReferencesAvailable, CLASSREF_FACTORY);
        this.classReferences = growResult.getReferences();
        this.classReferencesAvailable = growResult.getAvailables();
        this.classReferencesAvailable[n2] = false;
        this.classReferences[n2].initialize(n, iSourceElementCallbackDelegate);
        return this.classReferences[n2];
    }

    protected static GrowResult growArrays(ASTReference[] aSTReferenceArray, boolean[] blArray, IReferenceFactory iReferenceFactory) {
        int n = aSTReferenceArray.length;
        boolean[] blArray2 = new boolean[n * 2];
        System.arraycopy(blArray, 0, blArray2, 0, n);
        ASTReference[] aSTReferenceArray2 = iReferenceFactory.createReferenceArray(n * 2);
        System.arraycopy(aSTReferenceArray, 0, aSTReferenceArray2, 0, n);
        int n2 = n;
        while (n2 < blArray2.length) {
            aSTReferenceArray2[n2] = iReferenceFactory.createReference();
            blArray2[n2] = true;
            ++n2;
        }
        growResult.initialize(blArray2, aSTReferenceArray2);
        return growResult;
    }

    private IASTReference getTypedefReference(int n, IASTTypedefDeclaration iASTTypedefDeclaration) {
        int n2 = 0;
        while (n2 < this.typedefReferencesAvailable.length) {
            if (this.typedefReferencesAvailable[n2]) {
                this.typedefReferencesAvailable[n2] = false;
                this.typedefReferences[n2].initialize(n, iASTTypedefDeclaration);
                return this.typedefReferences[n2];
            }
            ++n2;
        }
        n2 = this.typedefReferences.length;
        GrowResult growResult = ReferenceCache.growArrays(this.typedefReferences, this.typedefReferencesAvailable, TYPEDEFREF_FACTORY);
        this.typedefReferencesAvailable = growResult.getAvailables();
        this.typedefReferences = growResult.getReferences();
        this.typedefReferencesAvailable[n2] = false;
        this.typedefReferences[n2].initialize(n, iASTTypedefDeclaration);
        return this.typedefReferences[n2];
    }

    private IASTReference getVariableReference(int n, IASTVariable iASTVariable) {
        int n2 = 0;
        while (n2 < this.variableReferencesAvailable.length) {
            if (this.variableReferencesAvailable[n2]) {
                this.variableReferencesAvailable[n2] = false;
                this.variableReferences[n2].initialize(n, iASTVariable);
                return this.variableReferences[n2];
            }
            ++n2;
        }
        n2 = this.variableReferences.length;
        GrowResult growResult = ReferenceCache.growArrays(this.variableReferences, this.variableReferencesAvailable, VARIABLEREF_FACTORY);
        this.variableReferencesAvailable = growResult.getAvailables();
        this.variableReferences = growResult.getReferences();
        this.variableReferencesAvailable[n2] = false;
        this.variableReferences[n2].initialize(n, iASTVariable);
        return this.variableReferences[n2];
    }

    private IASTReference getParameterReference(int n, IASTParameterDeclaration iASTParameterDeclaration) {
        int n2 = 0;
        while (n2 < this.parameterReferencesAvailable.length) {
            if (this.parameterReferencesAvailable[n2]) {
                this.parameterReferencesAvailable[n2] = false;
                this.parameterReferences[n2].initialize(n, iASTParameterDeclaration);
                return this.parameterReferences[n2];
            }
            ++n2;
        }
        n2 = this.parameterReferences.length;
        GrowResult growResult = ReferenceCache.growArrays(this.parameterReferences, this.parameterReferencesAvailable, PARMREF_FACTORY);
        this.parameterReferencesAvailable = growResult.getAvailables();
        this.parameterReferences = growResult.getReferences();
        this.parameterReferencesAvailable[n2] = false;
        this.parameterReferences[n2].initialize(n, iASTParameterDeclaration);
        return this.parameterReferences[n2];
    }

    private IASTReference getTemplateParameterReference(int n, IASTTemplateParameter iASTTemplateParameter) {
        int n2 = 0;
        while (n2 < this.templateParameterReferencesAvailable.length) {
            if (this.templateParameterReferencesAvailable[n2]) {
                this.templateParameterReferencesAvailable[n2] = false;
                this.templateParameterReferences[n2].initialize(n, iASTTemplateParameter);
                return this.templateParameterReferences[n2];
            }
            ++n2;
        }
        n2 = this.templateParameterReferences.length;
        GrowResult growResult = ReferenceCache.growArrays(this.templateParameterReferences, this.templateParameterReferencesAvailable, TEMPPARMREF_FACTORY);
        this.templateParameterReferencesAvailable = growResult.getAvailables();
        this.templateParameterReferences = growResult.getReferences();
        this.templateParameterReferencesAvailable[n2] = false;
        this.templateParameterReferences[n2].initialize(n, iASTTemplateParameter);
        return this.templateParameterReferences[n2];
    }

    private IASTReference getNamespaceReference(int n, IASTNamespaceDefinition iASTNamespaceDefinition) {
        int n2 = 0;
        while (n2 < this.namespaceReferencesAvailable.length) {
            if (this.namespaceReferencesAvailable[n2]) {
                this.namespaceReferencesAvailable[n2] = false;
                this.namespaceReferences[n2].initialize(n, iASTNamespaceDefinition);
                return this.namespaceReferences[n2];
            }
            ++n2;
        }
        n2 = this.namespaceReferences.length;
        GrowResult growResult = ReferenceCache.growArrays(this.namespaceReferences, this.namespaceReferencesAvailable, NAMESPACEREF_FACTORY);
        this.namespaceReferencesAvailable = growResult.getAvailables();
        this.namespaceReferences = growResult.getReferences();
        this.namespaceReferencesAvailable[n2] = false;
        this.namespaceReferences[n2].initialize(n, iASTNamespaceDefinition);
        return this.namespaceReferences[n2];
    }

    private IASTReference getEnumerationReference(int n, IASTEnumerationSpecifier iASTEnumerationSpecifier) {
        int n2 = 0;
        while (n2 < this.enumerationReferencesAvailable.length) {
            if (this.enumerationReferencesAvailable[n2]) {
                this.enumerationReferencesAvailable[n2] = false;
                this.enumerationReferences[n2].initialize(n, iASTEnumerationSpecifier);
                return this.enumerationReferences[n2];
            }
            ++n2;
        }
        n2 = this.enumerationReferences.length;
        GrowResult growResult = ReferenceCache.growArrays(this.enumerationReferences, this.enumerationReferencesAvailable, ENUMSPECREF_FACTORY);
        this.enumerationReferencesAvailable = growResult.getAvailables();
        this.enumerationReferences = growResult.getReferences();
        this.enumerationReferencesAvailable[n2] = false;
        this.enumerationReferences[n2].initialize(n, iASTEnumerationSpecifier);
        return this.enumerationReferences[n2];
    }

    private IASTReference getEnumeratorReference(int n, IASTEnumerator iASTEnumerator) {
        int n2 = 0;
        while (n2 < this.enumeratorReferencesAvailable.length) {
            if (this.enumeratorReferencesAvailable[n2]) {
                this.enumeratorReferencesAvailable[n2] = false;
                this.enumeratorReferences[n2].initialize(n, iASTEnumerator);
                return this.enumeratorReferences[n2];
            }
            ++n2;
        }
        n2 = this.enumeratorReferences.length;
        GrowResult growResult = ReferenceCache.growArrays(this.enumeratorReferences, this.enumeratorReferencesAvailable, ENUMERATORREF_FACTORY);
        this.enumeratorReferencesAvailable = growResult.getAvailables();
        this.enumeratorReferences = growResult.getReferences();
        this.enumeratorReferencesAvailable[n2] = false;
        this.enumeratorReferences[n2].initialize(n, iASTEnumerator);
        return this.enumeratorReferences[n2];
    }

    private IASTReference getMethodReference(int n, IASTMethod iASTMethod) {
        int n2 = 0;
        while (n2 < this.methodReferencesAvailable.length) {
            if (this.methodReferencesAvailable[n2]) {
                this.methodReferencesAvailable[n2] = false;
                this.methodReferences[n2].initialize(n, iASTMethod);
                return this.methodReferences[n2];
            }
            ++n2;
        }
        n2 = this.methodReferences.length;
        GrowResult growResult = ReferenceCache.growArrays(this.methodReferences, this.methodReferencesAvailable, METHODREF_FACTORY);
        this.methodReferencesAvailable = growResult.getAvailables();
        this.methodReferences = growResult.getReferences();
        this.methodReferencesAvailable[n2] = false;
        this.methodReferences[n2].initialize(n, iASTMethod);
        return this.methodReferences[n2];
    }

    private IASTReference getFunctionReference(int n, IASTFunction iASTFunction) {
        int n2 = 0;
        while (n2 < this.functionReferencesAvailable.length) {
            if (this.functionReferencesAvailable[n2]) {
                this.functionReferencesAvailable[n2] = false;
                this.functionReferences[n2].initialize(n, iASTFunction);
                return this.functionReferences[n2];
            }
            ++n2;
        }
        n2 = this.functionReferences.length;
        GrowResult growResult = ReferenceCache.growArrays(this.functionReferences, this.functionReferencesAvailable, FUNCTIONREF_FACTORY);
        this.functionReferencesAvailable = growResult.getAvailables();
        this.functionReferences = growResult.getReferences();
        this.functionReferencesAvailable[n2] = false;
        this.functionReferences[n2].initialize(n, iASTFunction);
        return this.functionReferences[n2];
    }

    private IASTReference getFieldReference(int n, IASTField iASTField) {
        int n2 = 0;
        while (n2 < this.fieldReferencesAvailable.length) {
            if (this.fieldReferencesAvailable[n2]) {
                this.fieldReferencesAvailable[n2] = false;
                this.fieldReferences[n2].initialize(n, iASTField);
                return this.fieldReferences[n2];
            }
            ++n2;
        }
        n2 = this.fieldReferences.length;
        GrowResult growResult = ReferenceCache.growArrays(this.fieldReferences, this.fieldReferencesAvailable, FIELDREF_FACTORY);
        this.fieldReferencesAvailable = growResult.getAvailables();
        this.fieldReferences = growResult.getReferences();
        this.fieldReferencesAvailable[n2] = false;
        this.fieldReferences[n2].initialize(n, iASTField);
        return this.fieldReferences[n2];
    }

    public void processReferences(List list, ISourceElementRequestor iSourceElementRequestor) {
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            IASTReference iASTReference = (IASTReference)list.get(n);
            iASTReference.acceptElement(iSourceElementRequestor, this);
            this.returnReference(iASTReference);
            ++n;
        }
        list.clear();
    }

    public boolean isBalanced() {
        return this.isBalanced(this.classReferencesAvailable) && this.isBalanced(this.variableReferencesAvailable) && this.isBalanced(this.fieldReferencesAvailable) && this.isBalanced(this.functionReferencesAvailable) && this.isBalanced(this.methodReferencesAvailable) && this.isBalanced(this.enumerationReferencesAvailable) && this.isBalanced(this.enumeratorReferencesAvailable) && this.isBalanced(this.parameterReferencesAvailable) && this.isBalanced(this.templateParameterReferencesAvailable) && this.isBalanced(this.typedefReferencesAvailable);
    }

    private boolean isBalanced(boolean[] blArray) {
        int n = 0;
        while (n < blArray.length) {
            if (!blArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private interface IReferenceFactory {
        public ASTReference createReference();

        public ASTReference[] createReferenceArray(int var1);
    }

    private static abstract class BaseReferenceFactory
    implements IReferenceFactory {
        BaseReferenceFactory() {
        }

        public ASTReference[] createReferenceArray(int n) {
            return new ASTReference[n];
        }
    }

    protected static class GrowResult {
        private boolean[] b;
        private ASTReference[] r;

        protected GrowResult() {
        }

        public void initialize(boolean[] blArray, ASTReference[] aSTReferenceArray) {
            this.b = blArray;
            this.r = aSTReferenceArray;
        }

        public boolean[] getAvailables() {
            return this.b;
        }

        public ASTReference[] getReferences() {
            return this.r;
        }
    }

    public static abstract class ASTReference
    implements IASTReference {
        protected int offset;
        private static final String EMPTY_STRING = "";
        private static final char[] EMPTY_CHAR_ARRAY = "".toCharArray();

        public abstract void reset();

        protected void resetOffset() {
            this.offset = 0;
        }

        public abstract void initialize(int var1, ISourceElementCallbackDelegate var2);

        protected void initialize(int n) {
            this.offset = n;
        }

        public ASTReference(int n) {
            this.offset = n;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getName() {
            if (this.getReferencedElement() instanceof IASTOffsetableNamedElement) {
                return ((IASTOffsetableNamedElement)((Object)this.getReferencedElement())).getName();
            }
            return EMPTY_STRING;
        }

        public char[] getNameCharArray() {
            if (this.getReferencedElement() instanceof IASTOffsetableNamedElement) {
                return ((IASTOffsetableNamedElement)((Object)this.getReferencedElement())).getNameCharArray();
            }
            return EMPTY_CHAR_ARRAY;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof IASTReference)) {
                return false;
            }
            return CharArrayUtils.equals(((IASTReference)object).getNameCharArray(), this.getNameCharArray()) && ((IASTReference)object).getOffset() == this.getOffset();
        }

        public void enterScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        }

        public void exitScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        }
    }

    public static class ASTClassReference
    extends ASTReference
    implements IASTClassReference {
        private IASTTypeSpecifier reference;

        public ASTClassReference(int n, IASTTypeSpecifier iASTTypeSpecifier) {
            super(n);
            this.reference = iASTTypeSpecifier;
        }

        public void initialize(int n, ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
            super.initialize(n);
            this.reference = (IASTTypeSpecifier)((Object)iSourceElementCallbackDelegate);
        }

        public void reset() {
            super.resetOffset();
            this.reference = null;
        }

        public ASTClassReference() {
            super(0);
            this.reference = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return (ISourceElementCallbackDelegate)((Object)this.reference);
        }

        public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
            try {
                iSourceElementRequestor.acceptClassReference(this);
            }
            catch (Exception exception) {}
        }

        public boolean isResolved() {
            return this.reference instanceof IASTClassSpecifier;
        }
    }

    public static class ASTEnumerationReference
    extends ASTReference
    implements IASTEnumerationReference {
        private IASTEnumerationSpecifier referencedElement;

        public ASTEnumerationReference(int n, IASTEnumerationSpecifier iASTEnumerationSpecifier) {
            super(n);
            this.referencedElement = iASTEnumerationSpecifier;
        }

        public ASTEnumerationReference() {
            super(0);
            this.referencedElement = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.referencedElement;
        }

        public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
            try {
                iSourceElementRequestor.acceptEnumerationReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int n, ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
            this.initialize(n);
            this.referencedElement = (IASTEnumerationSpecifier)iSourceElementCallbackDelegate;
        }

        public void reset() {
            super.resetOffset();
            this.referencedElement = null;
        }
    }

    public static class ASTEnumeratorReference
    extends ASTReference
    implements IASTEnumeratorReference {
        private IASTEnumerator enumerator;

        public ASTEnumeratorReference(int n, IASTEnumerator iASTEnumerator) {
            super(n);
            this.enumerator = iASTEnumerator;
        }

        public ASTEnumeratorReference() {
            super(0);
            this.enumerator = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.enumerator;
        }

        public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
            try {
                iSourceElementRequestor.acceptEnumeratorReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int n, ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
            super.initialize(n);
            this.enumerator = (IASTEnumerator)iSourceElementCallbackDelegate;
        }

        public void reset() {
            super.resetOffset();
            this.enumerator = null;
        }
    }

    public static class ASTFieldReference
    extends ASTReference
    implements IASTReference,
    IASTFieldReference {
        private IASTField referencedElement;

        public ASTFieldReference(int n, IASTField iASTField) {
            super(n);
            this.referencedElement = iASTField;
        }

        public ASTFieldReference() {
            super(0);
            this.referencedElement = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.referencedElement;
        }

        public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
            try {
                iSourceElementRequestor.acceptFieldReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int n, ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
            this.initialize(n);
            this.referencedElement = (IASTField)iSourceElementCallbackDelegate;
        }

        public void reset() {
            this.resetOffset();
            this.referencedElement = null;
        }
    }

    public static class ASTFunctionReference
    extends ASTReference
    implements IASTReference,
    IASTFunctionReference {
        private IASTFunction declaration;

        public ASTFunctionReference(int n, IASTFunction iASTFunction) {
            super(n);
            this.declaration = iASTFunction;
        }

        public ASTFunctionReference() {
            super(0);
            this.declaration = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.declaration;
        }

        public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
            try {
                iSourceElementRequestor.acceptFunctionReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int n, ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
            super.initialize(n);
            this.declaration = (IASTFunction)iSourceElementCallbackDelegate;
        }

        public void reset() {
            this.resetOffset();
            this.declaration = null;
        }
    }

    public static class ASTMethodReference
    extends ASTReference
    implements IASTMethodReference {
        private IASTMethod method;

        public ASTMethodReference(int n, IASTMethod iASTMethod) {
            super(n);
            this.method = iASTMethod;
        }

        public ASTMethodReference() {
            super(0);
            this.method = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.method;
        }

        public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
            try {
                iSourceElementRequestor.acceptMethodReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int n, ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
            super.initialize(n);
            this.method = (IASTMethod)iSourceElementCallbackDelegate;
        }

        public void reset() {
            this.resetOffset();
            this.method = null;
        }
    }

    public static class ASTNamespaceReference
    extends ASTReference
    implements IASTNamespaceReference {
        private IASTNamespaceDefinition reference;

        public ASTNamespaceReference(int n, IASTNamespaceDefinition iASTNamespaceDefinition) {
            super(n);
            this.reference = iASTNamespaceDefinition;
        }

        public ASTNamespaceReference() {
            super(0);
            this.reference = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.reference;
        }

        public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
            try {
                iSourceElementRequestor.acceptNamespaceReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int n, ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
            super.initialize(n);
            this.reference = (IASTNamespaceDefinition)iSourceElementCallbackDelegate;
        }

        public void reset() {
            this.resetOffset();
            this.reference = null;
        }
    }

    public static class ASTParameterReference
    extends ASTReference
    implements IASTParameterReference {
        private IASTParameterDeclaration parm;

        public ASTParameterReference(int n, IASTParameterDeclaration iASTParameterDeclaration) {
            super(n);
            this.parm = iASTParameterDeclaration;
        }

        public ASTParameterReference() {
            super(0);
            this.parm = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.parm;
        }

        public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
            try {
                iSourceElementRequestor.acceptParameterReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int n, ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
            this.initialize(n);
            this.parm = (IASTParameterDeclaration)iSourceElementCallbackDelegate;
        }

        public void reset() {
            this.resetOffset();
            this.parm = null;
        }
    }

    public static class ASTTemplateParameterReference
    extends ASTReference
    implements IASTTemplateParameterReference {
        private IASTTemplateParameter parameter;

        public ASTTemplateParameterReference(int n, IASTTemplateParameter iASTTemplateParameter) {
            super(n);
            this.parameter = iASTTemplateParameter;
        }

        public ASTTemplateParameterReference() {
            super(0);
            this.parameter = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.parameter;
        }

        public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
            try {
                iSourceElementRequestor.acceptTemplateParameterReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int n, ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
            super.initialize(n);
            this.parameter = (IASTTemplateParameter)iSourceElementCallbackDelegate;
        }

        public void reset() {
            this.resetOffset();
            this.parameter = null;
        }
    }

    public static class ASTTypedefReference
    extends ASTReference
    implements IASTTypedefReference {
        private IASTTypedefDeclaration referencedItem;

        public ASTTypedefReference(int n, IASTTypedefDeclaration iASTTypedefDeclaration) {
            super(n);
            this.referencedItem = iASTTypedefDeclaration;
        }

        public ASTTypedefReference() {
            super(0);
            this.referencedItem = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.referencedItem;
        }

        public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
            try {
                iSourceElementRequestor.acceptTypedefReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int n, ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
            super.initialize(n);
            this.referencedItem = (IASTTypedefDeclaration)iSourceElementCallbackDelegate;
        }

        public void reset() {
            super.resetOffset();
            this.referencedItem = null;
        }
    }

    public static class ASTVariableReference
    extends ASTReference
    implements IASTReference,
    IASTVariableReference {
        private IASTVariable referencedElement;

        public ASTVariableReference(int n, IASTVariable iASTVariable) {
            super(n);
            this.referencedElement = iASTVariable;
        }

        public void initialize(int n, ISourceElementCallbackDelegate iSourceElementCallbackDelegate) {
            super.initialize(n);
            this.referencedElement = (IASTVariable)iSourceElementCallbackDelegate;
        }

        public void reset() {
            super.resetOffset();
            this.referencedElement = null;
        }

        public ASTVariableReference() {
            super(0);
            this.referencedElement = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.referencedElement;
        }

        public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
            try {
                iSourceElementRequestor.acceptVariableReference(this);
            }
            catch (Exception exception) {}
        }
    }
}

