/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTScopedTypeSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.quick.IASTQClassSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.quick.IASTQScope;

public class ASTClassSpecifier
extends ASTScopedTypeSpecifier
implements IASTQClassSpecifier,
IASTQScope {
    private final char[] name;
    private List declarations = new ArrayList();
    private List baseClauses = new ArrayList();
    private List friends = new ArrayList();
    private ASTAccessVisibility access;
    private final IASTClassSpecifier.ClassNameType classNameType;
    private final ASTClassKind classKind;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public ASTClassSpecifier(IASTScope iASTScope, char[] cArray, ASTClassKind aSTClassKind, IASTClassSpecifier.ClassNameType classNameType, int n, int n2, int n3, int n4, int n5, ASTAccessVisibility aSTAccessVisibility, char[] cArray2) {
        super(iASTScope, cArray);
        this.classNameType = classNameType;
        this.classKind = aSTClassKind;
        this.setStartingOffsetAndLineNumber(n, n2);
        this.setNameOffset(n3);
        this.setNameEndOffsetAndLineNumber(n4, n5);
        this.access = aSTAccessVisibility;
        this.name = cArray;
        this.fn = cArray2;
    }

    public char[] getFilename() {
        return this.fn;
    }

    public IASTClassSpecifier.ClassNameType getClassNameType() {
        return this.classNameType;
    }

    public ASTClassKind getClassKind() {
        return this.classKind;
    }

    public Iterator getBaseClauses() {
        return this.baseClauses.iterator();
    }

    public ASTAccessVisibility getCurrentVisibilityMode() {
        return this.access;
    }

    public Iterator getDeclarations() {
        return this.declarations.iterator();
    }

    public String getName() {
        return String.valueOf(this.name);
    }

    public void addDeclaration(IASTDeclaration iASTDeclaration) {
        this.declarations.add(iASTDeclaration);
    }

    public void addBaseClass(IASTBaseSpecifier iASTBaseSpecifier) {
        this.baseClauses.add(iASTBaseSpecifier);
    }

    public void setCurrentVisibility(ASTAccessVisibility aSTAccessVisibility) {
        this.access = aSTAccessVisibility;
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        try {
            iSourceElementRequestor.enterClassSpecifier(this);
        }
        catch (Exception exception) {}
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor, IReferenceManager iReferenceManager) {
        try {
            iSourceElementRequestor.exitClassSpecifier(this);
        }
        catch (Exception exception) {}
    }

    public Iterator getFriends() {
        return this.friends.iterator();
    }

    public void addFriendDeclaration(IASTDeclaration iASTDeclaration) {
        this.friends.add(iASTDeclaration);
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int n, int n2) {
        this.startingOffset = n;
        this.startingLineNumber = n2;
    }

    public final void setEndingOffsetAndLineNumber(int n, int n2) {
        this.endingOffset = n;
        this.endingLineNumber = n2;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }

    public final int getNameOffset() {
        return this.nameStartOffset;
    }

    public final void setNameOffset(int n) {
        this.nameStartOffset = n;
    }

    public final int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public final void setNameEndOffsetAndLineNumber(int n, int n2) {
        this.nameEndOffset = n;
        this.nameLineNumber = n2;
    }

    public char[] getNameCharArray() {
        return this.name;
    }
}

