/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.List;
import org.eclipse.cdt.internal.core.parser.pst.ExtensibleSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfoProvider;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectMap;

public class BasicSymbol
extends ExtensibleSymbol
implements ISymbol {
    private char[] _name;
    private ITypeInfo _typeInfo;
    private int _depth;
    private boolean _isInvisible = false;
    private boolean _isTemplateMember = false;
    private boolean _isForwardDeclaration = false;
    private boolean _isTemplateInstance = false;
    private ISymbol _symbolDef = null;

    public BasicSymbol(ParserSymbolTable parserSymbolTable, char[] cArray) {
        super(parserSymbolTable);
        this._name = cArray;
    }

    public BasicSymbol(ParserSymbolTable parserSymbolTable, char[] cArray, ITypeInfo.eType eType2) {
        super(parserSymbolTable);
        this._name = cArray;
        this._typeInfo = TypeInfoProvider.newTypeInfo(eType2);
    }

    public ISymbol instantiate(ITemplateSymbol iTemplateSymbol, ObjectMap objectMap) throws ParserSymbolTableException {
        if (!this.isTemplateMember() && !this.getContainingSymbol().isTemplateMember()) {
            return null;
        }
        ISymbol iSymbol = (ISymbol)this.clone();
        iSymbol.setTypeInfo(TemplateEngine.instantiateTypeInfo(iSymbol.getTypeInfo(), iTemplateSymbol, objectMap));
        iSymbol.setInstantiatedSymbol(this);
        return iSymbol;
    }

    public char[] getName() {
        return this._name;
    }

    public void setName(char[] cArray) {
        this._name = cArray;
    }

    public void setContainingSymbol(IContainerSymbol iContainerSymbol) {
        super.setContainingSymbol(iContainerSymbol);
        this._depth = iContainerSymbol.getDepth() + 1;
    }

    public void setType(ITypeInfo.eType eType2) {
        this.getTypeInfo().setType(eType2);
    }

    public ITypeInfo.eType getType() {
        return this.getTypeInfo().getType();
    }

    public boolean isType(ITypeInfo.eType eType2) {
        return this.getTypeInfo().isType(eType2, ITypeInfo.t_undef);
    }

    public boolean isType(ITypeInfo.eType eType2, ITypeInfo.eType eType3) {
        return this.getTypeInfo().isType(eType2, eType3);
    }

    public ISymbol getTypeSymbol() {
        ISymbol iSymbol = this.getTypeInfo().getTypeSymbol();
        if (iSymbol != null && iSymbol.isForwardDeclaration() && iSymbol.getForwardSymbol() != null) {
            return iSymbol.getForwardSymbol();
        }
        return iSymbol;
    }

    public void setTypeSymbol(ISymbol iSymbol) {
        this.getTypeInfo().setTypeSymbol(iSymbol);
    }

    public ITypeInfo getTypeInfo() {
        return this._typeInfo != null ? this._typeInfo : (this._typeInfo = new TypeInfo());
    }

    public void setTypeInfo(ITypeInfo iTypeInfo) {
        this._typeInfo = iTypeInfo;
    }

    public boolean isForwardDeclaration() {
        return this._isForwardDeclaration;
    }

    public void setIsForwardDeclaration(boolean bl) {
        this._isForwardDeclaration = bl;
    }

    public void setForwardSymbol(ISymbol iSymbol) {
        this._symbolDef = iSymbol;
    }

    public ISymbol getForwardSymbol() {
        return this._isForwardDeclaration || this.isType(ITypeInfo.t_namespace) ? this._symbolDef : null;
    }

    public int compareCVQualifiersTo(ISymbol iSymbol) {
        int n;
        int n2 = iSymbol.getTypeInfo().hasPtrOperators() ? iSymbol.getTypeInfo().getPtrOperators().size() : 0;
        int n3 = n = this.getTypeInfo().hasPtrOperators() ? this.getTypeInfo().getPtrOperators().size() : 0;
        if (n2 != n) {
            return n - n2;
        }
        if (n2 == 0) {
            return 0;
        }
        ITypeInfo.PtrOp ptrOp = null;
        ITypeInfo.PtrOp ptrOp2 = null;
        int n4 = 0;
        while (n4 > n2) {
            ptrOp = (ITypeInfo.PtrOp)iSymbol.getTypeInfo().getPtrOperators().get(n4);
            if (ptrOp.compareCVTo(ptrOp2 = (ITypeInfo.PtrOp)this.getTypeInfo().getPtrOperators().get(n4)) != 0) {
                return -1;
            }
            ++n4;
        }
        return 0;
    }

    public List getPtrOperators() {
        return this.getTypeInfo().getPtrOperators();
    }

    public void addPtrOperator(ITypeInfo.PtrOp ptrOp) {
        this.getTypeInfo().addPtrOperator(ptrOp);
    }

    public void preparePtrOperatros(int n) {
        this.getTypeInfo().preparePtrOperators(n);
    }

    public int getDepth() {
        return this._depth;
    }

    public boolean isTemplateMember() {
        return this._isTemplateMember;
    }

    public void setIsTemplateMember(boolean bl) {
        this._isTemplateMember = bl;
    }

    public boolean isTemplateInstance() {
        return this._isTemplateInstance && this._symbolDef != null;
    }

    public ISymbol getInstantiatedSymbol() {
        return this._symbolDef;
    }

    public void setInstantiatedSymbol(ISymbol iSymbol) {
        this._isTemplateInstance = true;
        this._symbolDef = iSymbol;
    }

    public boolean getIsInvisible() {
        return this._isInvisible;
    }

    public void setIsInvisible(boolean bl) {
        this._isInvisible = bl;
    }

    public Object clone() {
        BasicSymbol basicSymbol = (BasicSymbol)super.clone();
        basicSymbol._typeInfo = TypeInfoProvider.newTypeInfo(basicSymbol._typeInfo);
        return basicSymbol;
    }
}

