/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfoProvider;

public class BasicTypeInfo
implements ITypeInfo {
    private static final char[][] _image = new char[][]{ParserSymbolTable.EMPTY_NAME_ARRAY, ParserSymbolTable.EMPTY_NAME_ARRAY, "namespace".toCharArray(), "class".toCharArray(), "struct".toCharArray(), "union".toCharArray(), "enum".toCharArray(), ParserSymbolTable.EMPTY_NAME_ARRAY, ParserSymbolTable.EMPTY_NAME_ARRAY, "_Bool".toCharArray(), "bool".toCharArray(), "char".toCharArray(), "wchar_t".toCharArray(), "int".toCharArray(), "float".toCharArray(), "double".toCharArray(), "void".toCharArray(), ParserSymbolTable.EMPTY_NAME_ARRAY, ParserSymbolTable.EMPTY_NAME_ARRAY, "template".toCharArray(), ParserSymbolTable.EMPTY_NAME_ARRAY, ParserSymbolTable.EMPTY_NAME_ARRAY, ParserSymbolTable.EMPTY_NAME_ARRAY, "typename".toCharArray()};
    protected int _typeBits = 0;
    protected ITypeInfo.eType _type = ITypeInfo.t_undef;
    protected List _ptrOperators = Collections.EMPTY_LIST;
    protected boolean _hasDefault = false;

    public void setBit(boolean bl, int n) {
        this._typeBits = bl ? (this._typeBits |= n) : (this._typeBits &= ~n);
    }

    public boolean checkBit(int n) {
        return (this._typeBits & n) != 0;
    }

    public void setType(ITypeInfo.eType eType2) {
        this._type = eType2;
    }

    public ITypeInfo.eType getType() {
        return this._type;
    }

    public boolean isType(ITypeInfo.eType eType2) {
        return this.isType(eType2, ITypeInfo.t_undef);
    }

    public int getTypeBits() {
        return this._typeBits;
    }

    public void setTypeBits(int n) {
        this._typeBits = n;
    }

    public ITypeInfo getFinalType(TypeInfoProvider typeInfoProvider) {
        return ParserSymbolTable.getFlatTypeInfo(this, typeInfoProvider);
    }

    public boolean isType(ITypeInfo.eType eType2, ITypeInfo.eType eType3) {
        if (eType2 == ITypeInfo.t_any) {
            return true;
        }
        if (eType3 == ITypeInfo.t_undef) {
            return this.getType() == eType2;
        }
        return this.getType().compareTo(eType2) >= 0 && this.getType().compareTo(eType3) <= 0;
    }

    public boolean hasPtrOperators() {
        return this._ptrOperators.size() > 0;
    }

    public List getPtrOperators() {
        return this._ptrOperators;
    }

    public boolean hasSamePtrs(ITypeInfo iTypeInfo) {
        int n = this.getPtrOperators().size();
        int n2 = iTypeInfo.getPtrOperators().size();
        ITypeInfo.PtrOp ptrOp = null;
        ITypeInfo.PtrOp ptrOp2 = null;
        if (n == n2) {
            if (n > 0) {
                int n3 = 0;
                while (n3 < n) {
                    ptrOp = (ITypeInfo.PtrOp)this.getPtrOperators().get(n3);
                    ptrOp2 = (ITypeInfo.PtrOp)iTypeInfo.getPtrOperators().get(n3);
                    if (ptrOp.getType() != ptrOp2.getType()) {
                        return false;
                    }
                    ++n3;
                }
            }
            return true;
        }
        return false;
    }

    public void applyOperatorExpression(ITypeInfo.OperatorExpression operatorExpression) {
        if (operatorExpression == null) {
            return;
        }
        if (operatorExpression == ITypeInfo.OperatorExpression.indirection || operatorExpression == ITypeInfo.OperatorExpression.subscript) {
            ListIterator listIterator;
            ITypeInfo.PtrOp ptrOp;
            if (this.hasPtrOperators() && ((ptrOp = (ITypeInfo.PtrOp)(listIterator = this.getPtrOperators().listIterator(this.getPtrOperators().size())).previous()).getType() == ITypeInfo.PtrOp.t_pointer || ptrOp.getType() == ITypeInfo.PtrOp.t_array)) {
                listIterator.remove();
            }
        } else if (operatorExpression == ITypeInfo.OperatorExpression.addressof) {
            ITypeInfo.PtrOp ptrOp = new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer);
            this.addPtrOperator(ptrOp);
        }
    }

    public void addPtrOperator(ITypeInfo.PtrOp ptrOp) {
        if (ptrOp != null) {
            if (this._ptrOperators == Collections.EMPTY_LIST) {
                this._ptrOperators = new ArrayList(4);
            }
            this._ptrOperators.add(ptrOp);
        }
    }

    public void addPtrOperator(List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        if (this._ptrOperators == Collections.EMPTY_LIST) {
            this._ptrOperators = new ArrayList(list.size());
        }
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            this._ptrOperators.add(list.get(n2));
            ++n2;
        }
    }

    public void preparePtrOperators(int n) {
        if (this._ptrOperators == Collections.EMPTY_LIST) {
            this._ptrOperators = new ArrayList(n);
        } else {
            ((ArrayList)this._ptrOperators).ensureCapacity(n);
        }
    }

    public boolean canHold(ITypeInfo iTypeInfo) {
        if (this.getType().compareTo(iTypeInfo.getType()) > 0) {
            return true;
        }
        int n = 286720;
        return (this.getTypeBits() & n) >= (iTypeInfo.getTypeBits() & n);
    }

    public boolean equals(Object object) {
        int n;
        if (object == null || !(object instanceof ITypeInfo)) {
            return false;
        }
        int n2 = this._typeBits & 0xFFFFFEFF & 0xFFFF7FFF & 0xFFFFFFFB & 0xFFFFFFF7;
        ITypeInfo iTypeInfo = (ITypeInfo)object;
        int n3 = iTypeInfo.getTypeBits() & 0xFFFFFEFF & 0xFFFF7FFF & 0xFFFFFFFB & 0xFFFFFFF7;
        boolean bl = n2 == n3;
        if (!(bl &= this._type == iTypeInfo.getType())) {
            return false;
        }
        int n4 = this._ptrOperators.size();
        if (n4 == (n = iTypeInfo.getPtrOperators().size())) {
            if (n4 != 0) {
                ITypeInfo.PtrOp ptrOp = null;
                ITypeInfo.PtrOp ptrOp2 = null;
                int n5 = 0;
                while (n5 < n4) {
                    ptrOp = (ITypeInfo.PtrOp)this._ptrOperators.get(n5);
                    if (!ptrOp.equals(ptrOp2 = (ITypeInfo.PtrOp)iTypeInfo.getPtrOperators().get(n5))) {
                        return false;
                    }
                    ++n5;
                }
            }
        } else {
            return false;
        }
        return bl;
    }

    public char[] toCharArray() {
        if (this.isType(ITypeInfo.t_type) && this.getTypeSymbol() != null) {
            return this.getTypeSymbol().getName();
        }
        return _image[this.getType().toInt()];
    }

    public void clear() {
        this._typeBits = 0;
        this._type = ITypeInfo.t_undef;
        this._ptrOperators = Collections.EMPTY_LIST;
    }

    public void copy(ITypeInfo iTypeInfo) {
        if (iTypeInfo == null) {
            return;
        }
        this._typeBits = iTypeInfo.getTypeBits();
        this._type = iTypeInfo.getType();
        this._ptrOperators = iTypeInfo.getPtrOperators() != Collections.EMPTY_LIST ? (ArrayList)((ArrayList)iTypeInfo.getPtrOperators()).clone() : Collections.EMPTY_LIST;
    }

    public boolean getHasDefault() {
        return this._hasDefault;
    }

    public void setHasDefault(boolean bl) {
        this._hasDefault = bl;
    }

    public ITypeInfo.eType getTemplateParameterType() {
        return ITypeInfo.t_undef;
    }

    public void setTemplateParameterType(ITypeInfo.eType eType2) {
        throw new UnsupportedOperationException();
    }

    public ISymbol getTypeSymbol() {
        return null;
    }

    public void setTypeSymbol(ISymbol iSymbol) {
        if (iSymbol != null) {
            throw new UnsupportedOperationException();
        }
    }

    public void setDefault(Object object) {
        if (object != null) {
            throw new UnsupportedOperationException();
        }
    }

    public Object getDefault() {
        return null;
    }
}

