/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.parser.pst.ContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TypeFilter;
import org.eclipse.cdt.internal.core.parser.scanner2.CharTable;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectMap;

public class DerivableContainerSymbol
extends ContainerSymbol
implements IDerivableContainerSymbol {
    private List _constructors = Collections.EMPTY_LIST;
    private List _parentScopes = Collections.EMPTY_LIST;
    private List _friends = Collections.EMPTY_LIST;

    protected DerivableContainerSymbol(ParserSymbolTable parserSymbolTable, char[] cArray) {
        super(parserSymbolTable, cArray);
    }

    protected DerivableContainerSymbol(ParserSymbolTable parserSymbolTable, char[] cArray, ITypeInfo.eType eType2) {
        super(parserSymbolTable, cArray, eType2);
    }

    public Object clone() {
        DerivableContainerSymbol derivableContainerSymbol = (DerivableContainerSymbol)super.clone();
        derivableContainerSymbol._parentScopes = this._parentScopes != Collections.EMPTY_LIST ? (List)((ArrayList)this._parentScopes).clone() : this._parentScopes;
        derivableContainerSymbol._constructors = this._constructors != Collections.EMPTY_LIST ? (List)((ArrayList)this._constructors).clone() : this._constructors;
        derivableContainerSymbol._friends = this._friends != Collections.EMPTY_LIST ? (List)((ArrayList)this._friends).clone() : this._friends;
        return derivableContainerSymbol;
    }

    public ISymbol instantiate(ITemplateSymbol iTemplateSymbol, ObjectMap objectMap) throws ParserSymbolTableException {
        if (!this.isTemplateMember()) {
            return null;
        }
        DerivableContainerSymbol derivableContainerSymbol = (DerivableContainerSymbol)super.instantiate(iTemplateSymbol, objectMap);
        List list = this.getParents();
        int n = list.size();
        derivableContainerSymbol.getParents().clear();
        ParentWrapper parentWrapper = null;
        int n2 = 0;
        while (n2 < n) {
            parentWrapper = (ParentWrapper)list.get(n2);
            ISymbol iSymbol = parentWrapper.getParent();
            if (iSymbol != null) {
                if (iSymbol instanceof IDeferredTemplateInstance) {
                    iTemplateSymbol.registerDeferredInstatiation(derivableContainerSymbol, iSymbol, ITemplateSymbol.DeferredKind.PARENT, objectMap);
                } else if (iSymbol.isType(ITypeInfo.t_templateParameter) && objectMap.containsKey(iSymbol)) {
                    ITypeInfo iTypeInfo = (ITypeInfo)objectMap.get(iSymbol);
                    iSymbol = iTypeInfo.getTypeSymbol();
                }
                derivableContainerSymbol.addParent(iSymbol, parentWrapper.isVirtual(), parentWrapper.getAccess(), parentWrapper.getOffset(), parentWrapper.getReferences());
            }
            ++n2;
        }
        return derivableContainerSymbol;
    }

    public void instantiateDeferredParent(ISymbol iSymbol, ITemplateSymbol iTemplateSymbol, ObjectMap objectMap) throws ParserSymbolTableException {
        List list = this.getParents();
        int n = list.size();
        ParentWrapper parentWrapper = null;
        int n2 = 0;
        while (n2 < n) {
            parentWrapper = (ParentWrapper)list.get(n2);
            if (parentWrapper.getParent() == iSymbol) {
                parentWrapper.setParent(iSymbol.instantiate(iTemplateSymbol, objectMap));
            }
            ++n2;
        }
    }

    public void discardDeferredParent(IDeferredTemplateInstance iDeferredTemplateInstance, ITemplateSymbol iTemplateSymbol, ObjectMap objectMap) {
        List list = this.getParents();
        int n = list.size();
        ParentWrapper parentWrapper = null;
        IContainerSymbol iContainerSymbol = iDeferredTemplateInstance.getTemplate().getTemplatedSymbol();
        int n2 = 0;
        while (n2 < n) {
            parentWrapper = (ParentWrapper)list.get(n2);
            ISymbol iSymbol = parentWrapper.getParent();
            if (iSymbol.getInstantiatedSymbol() == iContainerSymbol) {
                list.remove(n2);
                iTemplateSymbol.removeInstantiation((IContainerSymbol)iSymbol);
                break;
            }
            ++n2;
        }
    }

    protected void collectInstantiatedConstructor(IParameterizedSymbol iParameterizedSymbol) {
        if (iParameterizedSymbol.isType(ITypeInfo.t_constructor)) {
            this.addToConstructors(iParameterizedSymbol);
        }
    }

    public void addSymbol(ISymbol iSymbol) throws ParserSymbolTableException {
        super.addSymbol(iSymbol);
        if (iSymbol instanceof IParameterizedSymbol) {
            this.addThis((IParameterizedSymbol)iSymbol);
        }
    }

    public void addParent(ISymbol iSymbol) {
        this.addParent(iSymbol, false, ASTAccessVisibility.PUBLIC, -1, null);
    }

    public void addParent(ISymbol iSymbol, boolean bl, ASTAccessVisibility aSTAccessVisibility, int n, List list) {
        if (this._parentScopes == Collections.EMPTY_LIST) {
            this._parentScopes = new ArrayList(4);
        }
        ParentWrapper parentWrapper = new ParentWrapper(iSymbol, bl, aSTAccessVisibility, n, list);
        this._parentScopes.add(parentWrapper);
    }

    public List getParents() {
        return this._parentScopes;
    }

    public boolean hasParents() {
        return !this._parentScopes.isEmpty();
    }

    public void addConstructor(IParameterizedSymbol iParameterizedSymbol) throws ParserSymbolTableException {
        if (!iParameterizedSymbol.isType(ITypeInfo.t_constructor)) {
            throw new ParserSymbolTableException(1);
        }
        List list = this.getConstructors();
        if (list.size() != 0 && !ParserSymbolTable.isValidOverload(list, (ISymbol)iParameterizedSymbol)) {
            throw new ParserSymbolTableException(3);
        }
        this.addToConstructors(iParameterizedSymbol);
        iParameterizedSymbol.setContainingSymbol(this);
        iParameterizedSymbol.setIsTemplateMember(this.isTemplateMember() || this.getType() == ITypeInfo.t_template);
        this.addThis(iParameterizedSymbol);
        this.addToContents(iParameterizedSymbol);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCopyConstructor() throws ParserSymbolTableException {
        block6: {
            ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>(1);
            ISymbol iSymbol = this;
            if (this.getContainingSymbol() instanceof ITemplateSymbol) {
                iSymbol = TemplateEngine.instantiateWithinTemplateScope(this, (ITemplateSymbol)this.getContainingSymbol());
            }
            ITypeInfo iTypeInfo = this.getSymbolTable().getTypeInfoProvider().getTypeInfo(ITypeInfo.t_type);
            iTypeInfo.setType(ITypeInfo.t_type);
            iTypeInfo.setBit(true, 1024);
            iTypeInfo.setTypeSymbol(iSymbol);
            iTypeInfo.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference, false, false));
            arrayList.add(iTypeInfo);
            IParameterizedSymbol iParameterizedSymbol = null;
            try {
                try {
                    iParameterizedSymbol = this.lookupConstructor(arrayList);
                }
                catch (ParserSymbolTableException parserSymbolTableException) {}
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.getSymbolTable().getTypeInfoProvider().returnTypeInfo(iTypeInfo);
                throw throwable;
            }
            {
                Object var5_7 = null;
                this.getSymbolTable().getTypeInfoProvider().returnTypeInfo(iTypeInfo);
                if (iParameterizedSymbol != null) break block6;
                iParameterizedSymbol = this.getSymbolTable().newParameterizedSymbol(this.getName(), ITypeInfo.t_constructor);
                iParameterizedSymbol.addParameter(this, 1024, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_reference, false, false), false);
            }
            this.addConstructor(iParameterizedSymbol);
        }
    }

    public IParameterizedSymbol lookupConstructor(List list) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData lookupData = new ParserSymbolTable.LookupData(ParserSymbolTable.EMPTY_NAME_ARRAY, list){
            private final List params;
            {
                this.params = list;
            }

            public List getParameters() {
                return this.params;
            }

            public TypeFilter getFilter() {
                return ParserSymbolTable.LookupData.CONSTRUCTOR_FILTER;
            }
        };
        ArrayList arrayList = null;
        if (!this.getConstructors().isEmpty()) {
            arrayList = new ArrayList(this.getConstructors());
        }
        if (arrayList != null) {
            return this.getSymbolTable().resolveFunction(lookupData, arrayList);
        }
        return null;
    }

    public List getConstructors() {
        return this._constructors;
    }

    private void addToConstructors(IParameterizedSymbol iParameterizedSymbol) {
        if (this._constructors == Collections.EMPTY_LIST) {
            this._constructors = new ArrayList(4);
        }
        this._constructors.add(iParameterizedSymbol);
    }

    private boolean addThis(IParameterizedSymbol iParameterizedSymbol) {
        ITypeInfo iTypeInfo;
        IContainerSymbol iContainerSymbol;
        if (this.getSymbolTable().getLanguage() != ParserLanguage.CPP) {
            return false;
        }
        if (iParameterizedSymbol instanceof ITemplateSymbol) {
            iContainerSymbol = ((ITemplateSymbol)iParameterizedSymbol).getTemplatedSymbol();
            if (iContainerSymbol instanceof IParameterizedSymbol) {
                iParameterizedSymbol = (IParameterizedSymbol)iContainerSymbol;
            } else {
                return false;
            }
        }
        if ((iContainerSymbol = iParameterizedSymbol.getContainingSymbol()) instanceof ITemplateSymbol) {
            iContainerSymbol = iContainerSymbol.getContainingSymbol();
        }
        if (!(iTypeInfo = iParameterizedSymbol.getTypeInfo()).isType(ITypeInfo.t_function) && !iTypeInfo.isType(ITypeInfo.t_constructor) || iTypeInfo.checkBit(4)) {
            return false;
        }
        if (iContainerSymbol.isType(ITypeInfo.t_class, ITypeInfo.t_union)) {
            Object object;
            boolean bl = false;
            ParserSymbolTable.LookupData lookupData = new ParserSymbolTable.LookupData(ParserSymbolTable.THIS);
            try {
                object = ParserSymbolTable.lookupInContained(lookupData, iParameterizedSymbol);
                bl = object != null ? ((CharTable)object).containsKey(lookupData.name) : false;
            }
            catch (ParserSymbolTableException parserSymbolTableException) {
                return false;
            }
            if (!bl) {
                object = this.getSymbolTable().newSymbol(ParserSymbolTable.THIS, ITypeInfo.t_type);
                object.setTypeSymbol(iParameterizedSymbol.getContainingSymbol());
                ITypeInfo.PtrOp ptrOp = new ITypeInfo.PtrOp();
                ptrOp.setType(ITypeInfo.PtrOp.t_pointer);
                object.getTypeInfo().setBit(iParameterizedSymbol.getTypeInfo().checkBit(1024), 1024);
                object.getTypeInfo().setBit(iParameterizedSymbol.getTypeInfo().checkBit(2048), 2048);
                object.addPtrOperator(ptrOp);
                try {
                    iParameterizedSymbol.addSymbol((ISymbol)object);
                }
                catch (ParserSymbolTableException parserSymbolTableException) {
                    return false;
                }
            }
        }
        return true;
    }

    public void addFriend(ISymbol iSymbol) {
        IContainerSymbol iContainerSymbol = iSymbol.getContainingSymbol();
        if (iContainerSymbol == null) {
            IContainerSymbol iContainerSymbol2 = this.getContainingSymbol();
            boolean bl = iContainerSymbol2.isType(ITypeInfo.t_constructor) || iContainerSymbol2.isType(ITypeInfo.t_function) || iContainerSymbol2.isType(ITypeInfo.t_block);
            while (iContainerSymbol2 != null && !iContainerSymbol2.isType(ITypeInfo.t_namespace)) {
                iContainerSymbol2 = iContainerSymbol2.getContainingSymbol();
            }
            iSymbol.setIsInvisible(bl);
            iSymbol.setIsForwardDeclaration(true);
            try {
                iContainerSymbol2.addSymbol(iSymbol);
            }
            catch (ParserSymbolTableException parserSymbolTableException) {}
        }
        this.addToFriends(iSymbol);
    }

    public ISymbol lookupForFriendship(char[] cArray) throws ParserSymbolTableException {
        IContainerSymbol iContainerSymbol = this.getContainingSymbol();
        if (iContainerSymbol != null && iContainerSymbol.isType(ITypeInfo.t_namespace, ITypeInfo.t_union)) {
            while (iContainerSymbol != null && iContainerSymbol.getType() != ITypeInfo.t_namespace) {
                iContainerSymbol = iContainerSymbol.getContainingSymbol();
            }
        }
        IContainerSymbol iContainerSymbol2 = iContainerSymbol;
        ParserSymbolTable.LookupData lookupData = new ParserSymbolTable.LookupData(cArray, iContainerSymbol2){
            private final ISymbol stopAt;
            {
                this.stopAt = iSymbol;
            }

            public ISymbol getStopAt() {
                return this.stopAt;
            }

            public boolean shouldReturnInvisibleSymbols() {
                return true;
            }
        };
        ParserSymbolTable.lookup(lookupData, this);
        return this.getSymbolTable().resolveAmbiguities(lookupData);
    }

    public IParameterizedSymbol lookupFunctionForFriendship(char[] cArray, List list) throws ParserSymbolTableException {
        IContainerSymbol iContainerSymbol = this.getContainingSymbol();
        if (iContainerSymbol != null && iContainerSymbol.isType(ITypeInfo.t_namespace, ITypeInfo.t_union)) {
            while (iContainerSymbol != null && iContainerSymbol.getType() != ITypeInfo.t_namespace) {
                iContainerSymbol = iContainerSymbol.getContainingSymbol();
            }
        }
        IContainerSymbol iContainerSymbol2 = iContainerSymbol;
        ParserSymbolTable.LookupData lookupData = new ParserSymbolTable.LookupData(cArray, list, iContainerSymbol2){
            private final List params;
            final ISymbol stopAt;
            {
                this.params = list;
                this.stopAt = iSymbol;
            }

            public List getParameters() {
                return this.params;
            }

            public ISymbol getStopAt() {
                return this.stopAt;
            }
        };
        ParserSymbolTable.lookup(lookupData, this);
        return (IParameterizedSymbol)this.getSymbolTable().resolveAmbiguities(lookupData);
    }

    public List getFriends() {
        return this._friends;
    }

    private void addToFriends(ISymbol iSymbol) {
        if (this._friends == Collections.EMPTY_LIST) {
            this._friends = new ArrayList(4);
        }
        this._friends.add(iSymbol);
    }

    public class ParentWrapper
    implements IDerivableContainerSymbol.IParentSymbol {
        private boolean isVirtual = false;
        protected ISymbol parent = null;
        private final ASTAccessVisibility access;
        private final int offset;
        private final List references;

        public ParentWrapper(ISymbol iSymbol, boolean bl, ASTAccessVisibility aSTAccessVisibility, int n, List list) {
            this.parent = iSymbol;
            this.isVirtual = bl;
            this.access = aSTAccessVisibility;
            this.offset = n;
            this.references = list;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public void setParent(ISymbol iSymbol) {
            this.parent = iSymbol;
        }

        public ISymbol getParent() {
            return this.parent;
        }

        public boolean isVirtual() {
            return this.isVirtual;
        }

        public void setVirtual(boolean bl) {
            this.isVirtual = bl;
        }

        public ASTAccessVisibility getAccess() {
            return this.access;
        }

        public int getOffset() {
            return this.offset;
        }

        public List getReferences() {
            return this.references;
        }
    }
}

