/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.List;
import org.eclipse.cdt.core.parser.Enum;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfoProvider;

public interface ITypeInfo {
    public static final int isAuto = 1;
    public static final int isRegister = 2;
    public static final int isStatic = 4;
    public static final int isExtern = 8;
    public static final int isMutable = 16;
    public static final int isInline = 32;
    public static final int isVirtual = 64;
    public static final int isExplicit = 128;
    public static final int isTypedef = 256;
    public static final int isFriend = 512;
    public static final int isConst = 1024;
    public static final int isVolatile = 2048;
    public static final int isUnsigned = 4096;
    public static final int isShort = 8192;
    public static final int isLong = 16384;
    public static final int isForward = 32768;
    public static final int isComplex = 65536;
    public static final int isImaginary = 131072;
    public static final int isLongLong = 262144;
    public static final int isSigned = 524288;
    public static final eType t_any = new eType(-1);
    public static final eType t_undef = new eType(0);
    public static final eType t_type = new eType(1);
    public static final eType t_namespace = new eType(2);
    public static final eType t_class = new eType(3);
    public static final eType t_struct = new eType(4);
    public static final eType t_union = new eType(5);
    public static final eType t_enumeration = new eType(6);
    public static final eType t_constructor = new eType(7);
    public static final eType t_function = new eType(8);
    public static final eType t__Bool = new eType(9);
    public static final eType t_bool = new eType(10);
    public static final eType t_char = new eType(11);
    public static final eType t_wchar_t = new eType(12);
    public static final eType t_int = new eType(13);
    public static final eType t_float = new eType(14);
    public static final eType t_double = new eType(15);
    public static final eType t_void = new eType(16);
    public static final eType t_enumerator = new eType(17);
    public static final eType t_block = new eType(18);
    public static final eType t_template = new eType(19);
    public static final eType t_asm = new eType(20);
    public static final eType t_linkage = new eType(21);
    public static final eType t_templateParameter = new eType(22);
    public static final eType t_typeName = new eType(23);

    public void setBit(boolean var1, int var2);

    public boolean checkBit(int var1);

    public void setType(eType var1);

    public eType getType();

    public boolean isType(eType var1);

    public int getTypeBits();

    public void setTypeBits(int var1);

    public eType getTemplateParameterType();

    public void setTemplateParameterType(eType var1);

    public ITypeInfo getFinalType(TypeInfoProvider var1);

    public boolean isType(eType var1, eType var2);

    public ISymbol getTypeSymbol();

    public void setTypeSymbol(ISymbol var1);

    public boolean hasPtrOperators();

    public List getPtrOperators();

    public boolean hasSamePtrs(ITypeInfo var1);

    public void applyOperatorExpression(OperatorExpression var1);

    public void addPtrOperator(PtrOp var1);

    public void addPtrOperator(List var1);

    public void preparePtrOperators(int var1);

    public boolean getHasDefault();

    public void setHasDefault(boolean var1);

    public void setDefault(Object var1);

    public Object getDefault();

    public boolean canHold(ITypeInfo var1);

    public boolean equals(Object var1);

    public char[] toCharArray();

    public void clear();

    public void copy(ITypeInfo var1);

    public static class OperatorExpression
    extends Enum {
        public static final OperatorExpression indirection = new OperatorExpression(1);
        public static final OperatorExpression addressof = new OperatorExpression(0);
        public static final OperatorExpression subscript = new OperatorExpression(2);

        protected OperatorExpression(int n) {
            super(n);
        }
    }

    public static class PtrOp {
        public static final eType t_undef_ptr = new eType(0);
        public static final eType t_pointer = new eType(1);
        public static final eType t_reference = new eType(2);
        public static final eType t_array = new eType(3);
        public static final eType t_memberPointer = new eType(4);
        private eType type = t_undef_ptr;
        private boolean isConstPtr = false;
        private boolean isVolatilePtr = false;
        private ISymbol memberOf = null;

        public PtrOp(eType eType2) {
            this.type = eType2;
        }

        public PtrOp(eType eType2, boolean bl, boolean bl2) {
            this.type = eType2;
            this.isConstPtr = bl;
            this.isVolatilePtr = bl2;
        }

        public PtrOp(ISymbol iSymbol, boolean bl, boolean bl2) {
            this.type = t_memberPointer;
            this.isConstPtr = bl;
            this.isVolatilePtr = bl2;
            this.memberOf = iSymbol;
        }

        public PtrOp() {
        }

        public eType getType() {
            return this.type;
        }

        public void setType(eType eType2) {
            this.type = eType2;
        }

        public boolean isConst() {
            return this.isConstPtr;
        }

        public boolean isVolatile() {
            return this.isVolatilePtr;
        }

        public void setConst(boolean bl) {
            this.isConstPtr = bl;
        }

        public void setVolatile(boolean bl) {
            this.isVolatilePtr = bl;
        }

        public ISymbol getMemberOf() {
            return this.memberOf;
        }

        public void setMemberOf(ISymbol iSymbol) {
            this.memberOf = iSymbol;
        }

        public int compareCVTo(PtrOp ptrOp) {
            int n = (this.isConst() ? 1 : 0) + (this.isVolatile() ? 1 : 0);
            int n2 = (ptrOp.isConst() ? 1 : 0) + (ptrOp.isVolatile() ? 1 : 0);
            return n - n2;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof PtrOp)) {
                return false;
            }
            PtrOp ptrOp = (PtrOp)object;
            return this.isConst() == ptrOp.isConst() && this.isVolatile() == ptrOp.isVolatile() && this.getType() == ptrOp.getType();
        }
    }

    public static class eType
    extends Enum
    implements Comparable {
        protected eType(int n) {
            super(n);
        }

        public int compareTo(Object object) {
            eType eType2 = (eType)object;
            return this.getEnumValue() - eType2.getEnumValue();
        }

        public int toInt() {
            return this.getEnumValue();
        }
    }
}

