/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.internal.core.parser.pst.BasicSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfoProvider;
import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayObjectMap;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectMap;

public class ParameterizedSymbol
extends ContainerSymbol
implements IParameterizedSymbol {
    private List _parameterList = Collections.EMPTY_LIST;
    private CharArrayObjectMap _parameterMap = CharArrayObjectMap.EMPTY_MAP;
    private ISymbol _returnType;
    private boolean _hasVarArgs = false;

    protected ParameterizedSymbol(ParserSymbolTable parserSymbolTable, char[] cArray) {
        super(parserSymbolTable, cArray);
    }

    protected ParameterizedSymbol(ParserSymbolTable parserSymbolTable, char[] cArray, ITypeInfo.eType eType2) {
        super(parserSymbolTable, cArray, eType2);
    }

    public Object clone() {
        ParameterizedSymbol parameterizedSymbol = (ParameterizedSymbol)super.clone();
        parameterizedSymbol._parameterList = this._parameterList != Collections.EMPTY_LIST ? (List)((ArrayList)this._parameterList).clone() : this._parameterList;
        parameterizedSymbol._parameterMap = this._parameterMap != CharArrayObjectMap.EMPTY_MAP ? (CharArrayObjectMap)this._parameterMap.clone() : this._parameterMap;
        return parameterizedSymbol;
    }

    public ISymbol instantiate(ITemplateSymbol iTemplateSymbol, ObjectMap objectMap) throws ParserSymbolTableException {
        if (!this.isTemplateMember()) {
            return null;
        }
        ParameterizedSymbol parameterizedSymbol = (ParameterizedSymbol)super.instantiate(iTemplateSymbol, objectMap);
        if (this._returnType != null) {
            if (this._returnType.isType(ITypeInfo.t_templateParameter)) {
                if (objectMap.containsKey(this._returnType)) {
                    parameterizedSymbol.setReturnType(this.getSymbolTable().newSymbol(ParserSymbolTable.EMPTY_NAME_ARRAY));
                    parameterizedSymbol.getReturnType().setTypeInfo((ITypeInfo)objectMap.get(this._returnType));
                    parameterizedSymbol.getReturnType().setInstantiatedSymbol(this._returnType);
                }
            } else if (this._returnType instanceof IDeferredTemplateInstance) {
                iTemplateSymbol.registerDeferredInstatiation(parameterizedSymbol, this._returnType, ITemplateSymbol.DeferredKind.RETURN_TYPE, objectMap);
            } else {
                parameterizedSymbol.setReturnType(this._returnType.instantiate(iTemplateSymbol, objectMap));
            }
        }
        if (!this.isType(ITypeInfo.t_template)) {
            List list = this.getParameterList();
            int n = list.size();
            parameterizedSymbol.getParameterList().clear();
            parameterizedSymbol.getParameterMap().clear();
            ISymbol iSymbol = null;
            ISymbol iSymbol2 = null;
            int n2 = 0;
            while (n2 < n) {
                iSymbol = (ISymbol)list.get(n2);
                iSymbol2 = iSymbol.instantiate(iTemplateSymbol, objectMap);
                parameterizedSymbol.addParameter(iSymbol2);
                ++n2;
            }
        }
        return parameterizedSymbol;
    }

    public void instantiateDeferredReturnType(ISymbol iSymbol, ITemplateSymbol iTemplateSymbol, ObjectMap objectMap) throws ParserSymbolTableException {
        this.setReturnType(iSymbol.instantiate(iTemplateSymbol, objectMap));
    }

    public void discardDeferredReturnType(ISymbol iSymbol, TemplateSymbol templateSymbol, ObjectMap objectMap) {
        ISymbol iSymbol2 = this.getReturnType();
        this.setReturnType(null);
        templateSymbol.removeInstantiation((IContainerSymbol)iSymbol2);
    }

    public void prepareForParameters(int n) {
        if (this._parameterList == Collections.EMPTY_LIST) {
            this._parameterList = new ArrayList(n);
        } else {
            ((ArrayList)this._parameterList).ensureCapacity(n);
        }
    }

    public void addParameter(ISymbol iSymbol) {
        if (this._parameterList == Collections.EMPTY_LIST) {
            this._parameterList = new ArrayList(8);
        }
        this._parameterList.add(iSymbol);
        char[] cArray = iSymbol.getName();
        if (cArray != null && !cArray.equals(ParserSymbolTable.EMPTY_NAME_ARRAY)) {
            if (this._parameterMap == CharArrayObjectMap.EMPTY_MAP) {
                this._parameterMap = new CharArrayObjectMap(2);
            }
            if (!this._parameterMap.containsKey(cArray)) {
                this._parameterMap.put(cArray, iSymbol);
            }
        }
        iSymbol.setContainingSymbol(this);
        iSymbol.setIsTemplateMember(this.isTemplateMember() || this.getType() == ITypeInfo.t_template);
    }

    public void addParameter(ITypeInfo.eType eType2, int n, ITypeInfo.PtrOp ptrOp, boolean bl) {
        BasicSymbol basicSymbol = new BasicSymbol(this.getSymbolTable(), ParserSymbolTable.EMPTY_NAME_ARRAY);
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo(eType2, n, ptrOp, bl);
        basicSymbol.setTypeInfo(iTypeInfo);
        this.addParameter(basicSymbol);
    }

    public void addParameter(ISymbol iSymbol, int n, ITypeInfo.PtrOp ptrOp, boolean bl) {
        BasicSymbol basicSymbol = new BasicSymbol(this.getSymbolTable(), ParserSymbolTable.EMPTY_NAME_ARRAY);
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo(ITypeInfo.t_type, n, iSymbol, ptrOp, bl);
        basicSymbol.setTypeInfo(iTypeInfo);
        this.addParameter(basicSymbol);
    }

    public CharArrayObjectMap getParameterMap() {
        return this._parameterMap;
    }

    public List getParameterList() {
        return this._parameterList;
    }

    public boolean hasSameParameters(IParameterizedSymbol iParameterizedSymbol) {
        int n;
        if (iParameterizedSymbol.getType() != this.getType()) {
            return false;
        }
        int n2 = this.getParameterList() == null ? 0 : this.getParameterList().size();
        int n3 = n = iParameterizedSymbol.getParameterList() == null ? 0 : iParameterizedSymbol.getParameterList().size();
        if (n != n2) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        List list = this.getParameterList();
        List list2 = iParameterizedSymbol.getParameterList();
        ITypeInfo iTypeInfo = null;
        ITypeInfo iTypeInfo2 = null;
        TypeInfoProvider typeInfoProvider = this.getSymbolTable().getTypeInfoProvider();
        int n4 = 0;
        while (n4 < n2) {
            ISymbol iSymbol = (ISymbol)list.get(n4);
            ISymbol iSymbol2 = (ISymbol)list2.get(n4);
            iTypeInfo = iSymbol.getTypeInfo();
            iTypeInfo2 = iSymbol2.getTypeInfo();
            iTypeInfo = ParserSymbolTable.getFlatTypeInfo(iTypeInfo, typeInfoProvider);
            iTypeInfo2 = ParserSymbolTable.getFlatTypeInfo(iTypeInfo2, typeInfoProvider);
            ITypeInfo iTypeInfo3 = iTypeInfo;
            while (iTypeInfo3 != null) {
                ITypeInfo.PtrOp ptrOp;
                List list3 = iTypeInfo3.getPtrOperators();
                if (list3.size() > 0 && (ptrOp = (ITypeInfo.PtrOp)list3.get(0)).getType() == ITypeInfo.PtrOp.t_array) {
                    list3.set(0, new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer, ptrOp.isConst(), ptrOp.isVolatile()));
                }
                if (iTypeInfo3.isType(ITypeInfo.t_type) && iTypeInfo3.getTypeSymbol() != null && iTypeInfo3.getTypeSymbol().isType(ITypeInfo.t_function) && iTypeInfo3.getPtrOperators().size() == 0) {
                    iTypeInfo3.addPtrOperator(new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer));
                }
                if (iTypeInfo3.getPtrOperators().size() == 0) {
                    iTypeInfo3.setBit(false, 1024);
                    iTypeInfo3.setBit(false, 2048);
                } else {
                    ptrOp = (ITypeInfo.PtrOp)iTypeInfo3.getPtrOperators().get(iTypeInfo3.getPtrOperators().size() - 1);
                    ptrOp.setConst(false);
                    ptrOp.setVolatile(false);
                }
                if (iTypeInfo3 == iTypeInfo2) break;
                iTypeInfo3 = iTypeInfo2;
            }
            boolean bl = iTypeInfo.equals(iTypeInfo2);
            typeInfoProvider.returnTypeInfo(iTypeInfo);
            typeInfoProvider.returnTypeInfo(iTypeInfo2);
            if (!bl) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public void setReturnType(ISymbol iSymbol) {
        this._returnType = iSymbol;
        this._returnType.setContainingSymbol(this);
        this._returnType.setIsTemplateMember(this.isTemplateMember() || this.getType() == ITypeInfo.t_template);
    }

    public ISymbol getReturnType() {
        return this._returnType;
    }

    public void setHasVariableArgs(boolean bl) {
        this._hasVarArgs = bl;
    }

    public boolean hasVariableArgs() {
        return this._hasVarArgs;
    }
}

