/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectSet;

public class TypeFilter {
    private ObjectSet acceptedTypes = new ObjectSet(2);
    private ObjectSet acceptedKinds = new ObjectSet(2);
    private boolean lookingInThis = false;

    public TypeFilter() {
    }

    public TypeFilter(ITypeInfo.eType eType2) {
        this.acceptedTypes.put(eType2);
    }

    public TypeFilter(IASTNode.LookupKind lookupKind) {
        this.acceptedKinds.put(lookupKind);
        this.populatedAcceptedTypes(lookupKind);
    }

    public void addAcceptedType(ITypeInfo.eType eType2) {
        this.acceptedTypes.put(eType2);
    }

    public void addAcceptedType(IASTNode.LookupKind lookupKind) {
        this.populatedAcceptedTypes(lookupKind);
        this.acceptedKinds.put(lookupKind);
    }

    public boolean willAccept(ITypeInfo.eType eType2) {
        return this.acceptedTypes.containsKey(ITypeInfo.t_any) || this.acceptedTypes.containsKey(eType2);
    }

    public boolean shouldAccept(ISymbol iSymbol) {
        return this.shouldAccept(iSymbol, iSymbol.getTypeInfo());
    }

    public boolean shouldAccept(ISymbol iSymbol, ITypeInfo iTypeInfo) {
        boolean bl;
        if (this.acceptedTypes.containsKey(ITypeInfo.t_any)) {
            return true;
        }
        if (this.acceptedKinds.isEmpty()) {
            return this.acceptedTypes.containsKey(iTypeInfo.getType());
        }
        IContainerSymbol iContainerSymbol = iSymbol.getContainingSymbol();
        boolean bl2 = iContainerSymbol.isType(ITypeInfo.t_class, ITypeInfo.t_union);
        boolean bl3 = bl = iContainerSymbol.isType(ITypeInfo.t_constructor, ITypeInfo.t_function) || iContainerSymbol.isType(ITypeInfo.t_block);
        if (iTypeInfo.isType(ITypeInfo.t_function)) {
            return this.acceptedKinds.containsKey(IASTNode.LookupKind.FUNCTIONS) && !bl2 || this.acceptedKinds.containsKey(IASTNode.LookupKind.METHODS) && bl2;
        }
        if (iTypeInfo.isType(ITypeInfo.t_type) && iTypeInfo.checkBit(256)) {
            return this.acceptedKinds.containsKey(IASTNode.LookupKind.TYPEDEFS) || this.acceptedKinds.containsKey(IASTNode.LookupKind.TYPES);
        }
        if (iTypeInfo.isType(ITypeInfo.t_type) || iTypeInfo.isType(ITypeInfo.t__Bool, ITypeInfo.t_void)) {
            return this.acceptedKinds.containsKey(IASTNode.LookupKind.VARIABLES) && !bl2 && !bl || this.acceptedKinds.containsKey(IASTNode.LookupKind.LOCAL_VARIABLES) && !bl2 && bl || this.acceptedKinds.containsKey(IASTNode.LookupKind.FIELDS) && bl2;
        }
        return this.acceptedTypes.containsKey(iTypeInfo.getType());
    }

    private void populatedAcceptedTypes(IASTNode.LookupKind lookupKind) {
        if (lookupKind == IASTNode.LookupKind.ALL) {
            this.acceptedTypes.put(ITypeInfo.t_any);
        } else if (lookupKind == IASTNode.LookupKind.STRUCTURES) {
            this.acceptedTypes.put(ITypeInfo.t_class);
            this.acceptedTypes.put(ITypeInfo.t_struct);
            this.acceptedTypes.put(ITypeInfo.t_union);
        } else if (lookupKind == IASTNode.LookupKind.STRUCTS) {
            this.acceptedTypes.put(ITypeInfo.t_struct);
        } else if (lookupKind == IASTNode.LookupKind.UNIONS) {
            this.acceptedTypes.put(ITypeInfo.t_union);
        } else if (lookupKind == IASTNode.LookupKind.CLASSES) {
            this.acceptedTypes.put(ITypeInfo.t_class);
        } else if (lookupKind == IASTNode.LookupKind.CONSTRUCTORS) {
            this.acceptedTypes.put(ITypeInfo.t_constructor);
        } else if (lookupKind == IASTNode.LookupKind.NAMESPACES) {
            this.acceptedTypes.put(ITypeInfo.t_namespace);
        } else if (lookupKind == IASTNode.LookupKind.ENUMERATIONS) {
            this.acceptedTypes.put(ITypeInfo.t_enumeration);
        } else if (lookupKind == IASTNode.LookupKind.ENUMERATORS) {
            this.acceptedTypes.put(ITypeInfo.t_enumerator);
        } else if (lookupKind == IASTNode.LookupKind.TYPES) {
            this.acceptedTypes.put(ITypeInfo.t_class);
            this.acceptedTypes.put(ITypeInfo.t_struct);
            this.acceptedTypes.put(ITypeInfo.t_union);
            this.acceptedTypes.put(ITypeInfo.t_enumeration);
        }
    }

    public void setLookingInThis(boolean bl) {
        this.lookingInThis = bl;
    }

    public boolean isLookingInThis() {
        return this.lookingInThis;
    }
}

