/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import org.eclipse.cdt.internal.core.parser.pst.BasicTypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.TemplateParameterTypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class TypeInfoProvider {
    private static final int BASIC = 0;
    private static final int TYPE = 1;
    private static final int TEMPLATE = 2;
    private static final int POOL_SIZE = 16;
    private final ITypeInfo[][] pool = new ITypeInfo[16][3];
    private final boolean[][] free = new boolean[16][3];
    private final int[] firstFreeHint = new int[3];
    private ITypeInfo.eType type;
    private ISymbol typeSymbol;
    private int bits;
    private Object defaultObj;
    private boolean hasDef;
    private ITypeInfo.eType templateParamType;

    protected TypeInfoProvider() {
        int n = 0;
        while (n < 16) {
            this.pool[n] = new ITypeInfo[]{TypeInfoProvider.newInfo(ITypeInfo.t_void, true), TypeInfoProvider.newInfo(ITypeInfo.t_type, true), TypeInfoProvider.newInfo(ITypeInfo.t_templateParameter, true)};
            this.free[n] = new boolean[]{true, true, true};
            ++n;
        }
    }

    public ITypeInfo getTypeInfo(ITypeInfo.eType eType2) {
        int n = 0;
        if (eType2 == ITypeInfo.t_type || eType2 == ITypeInfo.t_enumerator) {
            n = 1;
        } else if (eType2 == ITypeInfo.t_templateParameter) {
            n = 2;
        }
        ITypeInfo iTypeInfo = null;
        int n2 = this.firstFreeHint[n];
        while (n2 < 16) {
            if (this.free[n2][n]) {
                this.free[n2][n] = false;
                this.firstFreeHint[n] = n2 + 1;
                iTypeInfo = this.pool[n2][n];
                break;
            }
            ++n2;
        }
        if (iTypeInfo == null) {
            iTypeInfo = eType2 == ITypeInfo.t_type ? new TypeInfo() : (eType2 == ITypeInfo.t_templateParameter ? new TemplateParameterTypeInfo() : new BasicTypeInfo());
        }
        iTypeInfo.setType(eType2);
        return iTypeInfo;
    }

    public void returnTypeInfo(ITypeInfo iTypeInfo) {
        int n = 0;
        if (iTypeInfo instanceof TemplateParameterTypeInfo) {
            n = 2;
        } else if (iTypeInfo instanceof TypeInfo) {
            n = 1;
        }
        int n2 = 0;
        while (n2 < 16) {
            if (this.pool[n2][n] == iTypeInfo) {
                iTypeInfo.clear();
                this.free[n2][n] = true;
                if (n2 < this.firstFreeHint[n]) {
                    this.firstFreeHint[n] = n2;
                }
                return;
            }
            ++n2;
        }
    }

    public int numAllocated() {
        int n = 0;
        int n2 = 0;
        while (n2 < 16) {
            n += (this.free[n2][0] ? 0 : 1) + (this.free[n2][1] ? 0 : 1) + (this.free[n2][2] ? 0 : 1);
            ++n2;
        }
        return n;
    }

    public static final ITypeInfo newTypeInfo(ITypeInfo iTypeInfo) {
        ITypeInfo iTypeInfo2 = TypeInfoProvider.newInfo(iTypeInfo.getType(), iTypeInfo.getDefault() != null);
        iTypeInfo2.copy(iTypeInfo);
        return iTypeInfo2;
    }

    public static final ITypeInfo newTypeInfo(ITypeInfo.eType eType2, int n, ISymbol iSymbol, ITypeInfo.PtrOp ptrOp, boolean bl) {
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo(eType2, n, ptrOp, bl);
        iTypeInfo.setTypeSymbol(iSymbol);
        return iTypeInfo;
    }

    public static final ITypeInfo newTypeInfo(ITypeInfo.eType eType2, int n, ISymbol iSymbol) {
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo(eType2);
        iTypeInfo.setTypeBits(n);
        iTypeInfo.setTypeSymbol(iSymbol);
        return iTypeInfo;
    }

    public static final ITypeInfo newTypeInfo(ITypeInfo.eType eType2, int n, ITypeInfo.PtrOp ptrOp, boolean bl) {
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo(eType2);
        iTypeInfo.setTypeBits(n);
        iTypeInfo.addPtrOperator(ptrOp);
        iTypeInfo.setHasDefault(bl);
        return iTypeInfo;
    }

    public static final ITypeInfo newTypeInfo(ITypeInfo.eType eType2) {
        ITypeInfo iTypeInfo = TypeInfoProvider.newInfo(eType2, false);
        iTypeInfo.setType(eType2);
        return iTypeInfo;
    }

    public static final ITypeInfo newTypeInfo(ITypeInfo.eType eType2, int n, ISymbol iSymbol, ITypeInfo.PtrOp ptrOp, Object object) {
        ITypeInfo iTypeInfo = TypeInfoProvider.newInfo(eType2, object != null);
        iTypeInfo.setType(eType2);
        iTypeInfo.setTypeBits(n);
        iTypeInfo.setDefault(object);
        iTypeInfo.setTypeSymbol(iSymbol);
        iTypeInfo.addPtrOperator(ptrOp);
        return iTypeInfo;
    }

    public static final ITypeInfo newTypeInfo() {
        return new BasicTypeInfo();
    }

    public void setType(ITypeInfo.eType eType2) {
        this.type = eType2;
    }

    public void setTypeSymbol(ISymbol iSymbol) {
        this.typeSymbol = iSymbol;
    }

    public void setTypeBits(int n) {
        this.bits = n;
    }

    public void setHasDef(boolean bl) {
        this.hasDef = bl;
    }

    public void setDefaultObj(Object object) {
        this.defaultObj = object;
    }

    public void setTemplateParameterType(ITypeInfo.eType eType2) {
        this.templateParamType = eType2;
    }

    public void setBit(boolean bl, int n) {
        this.bits = bl ? (this.bits |= n) : (this.bits &= ~n);
    }

    public void beginTypeConstruction() {
        this.type = ITypeInfo.t_undef;
        this.typeSymbol = null;
        this.bits = 0;
        this.defaultObj = null;
        this.templateParamType = null;
        this.hasDef = false;
    }

    public ITypeInfo completeConstruction() {
        ITypeInfo iTypeInfo = TypeInfoProvider.newTypeInfo(this.type, this.bits, this.typeSymbol, null, this.defaultObj);
        iTypeInfo.setHasDefault(this.hasDef);
        if (this.templateParamType != null) {
            iTypeInfo.setTemplateParameterType(this.templateParamType);
        }
        this.beginTypeConstruction();
        return iTypeInfo;
    }

    private static final ITypeInfo newInfo(ITypeInfo.eType eType2, boolean bl) {
        BasicTypeInfo basicTypeInfo = null;
        basicTypeInfo = eType2 == ITypeInfo.t_type || eType2 == ITypeInfo.t_enumerator ? (bl ? new TypeInfo(){
            private Object _defObj;

            public void copy(ITypeInfo iTypeInfo) {
                super.copy(iTypeInfo);
                this._defObj = iTypeInfo.getDefault();
            }

            public void setDefault(Object object) {
                this._defObj = object;
            }

            public Object getDefault() {
                return this._defObj;
            }
        } : new TypeInfo()) : (eType2 == ITypeInfo.t_templateParameter ? (bl ? new TemplateParameterTypeInfo(){
            private Object _defObj;

            public void copy(ITypeInfo iTypeInfo) {
                super.copy(iTypeInfo);
                this._defObj = iTypeInfo.getDefault();
            }

            public void setDefault(Object object) {
                this._defObj = object;
            }

            public Object getDefault() {
                return this._defObj;
            }
        } : new TemplateParameterTypeInfo()) : (bl ? new BasicTypeInfo(){
            private Object _defObj;

            public void copy(ITypeInfo iTypeInfo) {
                super.copy(iTypeInfo);
                this._defObj = iTypeInfo.getDefault();
            }

            public void setDefault(Object object) {
                this._defObj = object;
            }

            public Object getDefault() {
                return this._defObj;
            }
        } : new BasicTypeInfo()));
        return basicTypeInfo;
    }
}

