/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.internal.core.parser.scanner.ContextException;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerContext;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerContextInclusion;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerContextMacro;
import org.eclipse.cdt.internal.core.parser.util.TraceUtil;

public class ContextStack {
    private final IParserLogService log;
    private int current_size = 8;
    private int lastFileContext = 0;
    private IScannerContext[] cs = new IScannerContext[this.current_size];
    private int cs_pos = 0;
    private int currentInclusionArraySize = 16;
    private int currentInclusionIndex = 0;
    private String[] fileNames = new String[this.currentInclusionArraySize];
    private static final String EMPTY_STRING = "";
    private static IScannerContext sentinel = new SentinelContext();
    private IScanner scanner;

    public final String getInclusionFilename(int n) {
        try {
            return this.fileNames[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return EMPTY_STRING;
        }
    }

    private final void addInclusionFilename(String string) {
        try {
            this.fileNames[this.currentInclusionIndex++] = string;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n = this.currentInclusionArraySize * 2;
            String[] stringArray = new String[n];
            System.arraycopy(this.fileNames, 0, stringArray, 0, this.fileNames.length);
            stringArray[this.currentInclusionArraySize++] = string;
            this.currentInclusionArraySize = n;
            this.fileNames = stringArray;
        }
    }

    public final void cs_push(IScannerContext iScannerContext) {
        try {
            this.cs[this.cs_pos++] = iScannerContext;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n = this.current_size * 2;
            IScannerContext[] iScannerContextArray = new IScannerContext[n];
            System.arraycopy(this.cs, 0, iScannerContextArray, 0, this.cs.length);
            iScannerContextArray[this.current_size] = iScannerContext;
            this.current_size = n;
            this.cs = iScannerContextArray;
        }
        this.scanner.setScannerContext(iScannerContext);
    }

    public final IScannerContext cs_pop() {
        IScannerContext iScannerContext = this.cs[--this.cs_pos];
        this.scanner.setScannerContext(this.cs_pos == 0 ? sentinel : this.cs[this.cs_pos - 1]);
        return iScannerContext;
    }

    public ContextStack(IScanner iScanner, IParserLogService iParserLogService) {
        this.log = iParserLogService;
        this.scanner = iScanner;
        this.cs_push(sentinel);
        iScanner.setScannerContext(sentinel);
    }

    public void updateInclusionContext(CodeReader codeReader, IASTInclusion iASTInclusion, ISourceElementRequestor iSourceElementRequestor) throws ContextException {
        this.addInclusionFilename(new String(codeReader.filename));
        ScannerContextInclusion scannerContextInclusion = new ScannerContextInclusion(codeReader, iASTInclusion, this.currentInclusionIndex - 1);
        if (this.isCircularInclusion(scannerContextInclusion.getContextName())) {
            throw new ContextException(0x200000B);
        }
        TraceUtil.outputTrace(this.log, "Scanner::ContextStack: entering inclusion ", null, scannerContextInclusion.getContextName(), null, null);
        scannerContextInclusion.getExtension().enterScope(iSourceElementRequestor, null);
        this.cs_push(scannerContextInclusion);
        ++this.lastFileContext;
    }

    public void updateMacroContext(String string, String string2, ISourceElementRequestor iSourceElementRequestor, int n, int n2) throws ContextException {
        if (this.getCurrentContext().getKind() == IScannerContext.ContextKind.MACROEXPANSION) {
            n = ((ScannerContextMacro)this.getCurrentContext()).getOffset();
            n2 = ((ScannerContextMacro)this.getCurrentContext()).getMacroLength();
        }
        this.cs_push(new ScannerContextMacro(string, string2, n, n2));
    }

    protected void pushInitialContext(IScannerContext iScannerContext) throws ContextException {
        this.addInclusionFilename(iScannerContext.getContextName());
        ++this.lastFileContext;
        this.cs_push(iScannerContext);
    }

    public boolean rollbackContext(ISourceElementRequestor iSourceElementRequestor) {
        IScannerContext iScannerContext = this.getCurrentContext();
        iScannerContext.close();
        if (iScannerContext.getKind() == IScannerContext.ContextKind.INCLUSION) {
            TraceUtil.outputTrace(this.log, "Scanner::ContextStack: ending inclusion ", null, iScannerContext.getContextName(), null, null);
            ((ScannerContextInclusion)iScannerContext).getExtension().exitScope(iSourceElementRequestor, null);
            --this.lastFileContext;
        }
        this.cs_pop();
        return this.cs_pos != 0;
    }

    public void undoRollback(IScannerContext iScannerContext, ISourceElementRequestor iSourceElementRequestor) {
        while (this.getCurrentContext() != iScannerContext) {
            IScannerContext iScannerContext2;
            if ((iScannerContext2 = this.cs[this.cs_pos++]).getKind() == IScannerContext.ContextKind.INCLUSION) {
                ++this.lastFileContext;
            }
            this.scanner.setScannerContext(iScannerContext2);
        }
    }

    protected boolean shouldExpandDefinition(String string) {
        int n = this.cs_pos - 1;
        while (n >= 0) {
            if (this.cs[n].getKind() == IScannerContext.ContextKind.MACROEXPANSION && this.cs[n].getContextName().equals(string)) {
                return false;
            }
            --n;
        }
        return true;
    }

    protected boolean isCircularInclusion(String string) {
        int n = this.cs_pos - 1;
        while (n >= 0) {
            if (this.cs[n].getKind() == IScannerContext.ContextKind.INCLUSION && this.cs[n].getContextName().equals(string)) {
                return true;
            }
            --n;
        }
        return false;
    }

    public final IScannerContext getCurrentContext() {
        return this.cs[this.cs_pos - 1];
    }

    public ScannerContextInclusion getMostRelevantFileContext() {
        if (this.cs[this.lastFileContext] != null && this.cs[this.lastFileContext] instanceof ScannerContextInclusion) {
            return (ScannerContextInclusion)this.cs[this.lastFileContext];
        }
        return null;
    }

    public int getMostRelevantFileContextIndex() {
        return this.getMostRelevantFileContext().getFilenameIndex();
    }

    public int getCurrentLineNumber() {
        ScannerContextInclusion scannerContextInclusion = this.getMostRelevantFileContext();
        if (scannerContextInclusion != null) {
            return scannerContextInclusion.getLine();
        }
        return -1;
    }

    private static class SentinelContext
    implements IScannerContext {
        SentinelContext() {
        }

        public int getChar() {
            return 10;
        }

        public String getContextName() {
            return ContextStack.EMPTY_STRING;
        }

        public int getOffset() {
            return 0;
        }

        public void ungetChar(int n) {
        }

        public boolean isFinal() {
            return false;
        }

        public int getKind() {
            return IScannerContext.ContextKind.SENTINEL;
        }

        public void close() {
        }
    }
}

