/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.Arrays;
import org.eclipse.cdt.core.parser.IMacroDescriptor;
import org.eclipse.cdt.core.parser.IToken;

public class FunctionMacroDescriptor
implements IMacroDescriptor {
    private String name;
    private String[] identifierParameters;
    private IToken[] tokenizedExpansion;
    private String expansionSignature;

    public FunctionMacroDescriptor(String string, String[] stringArray, IToken[] iTokenArray, String string2) {
        this.name = string;
        this.identifierParameters = stringArray;
        this.tokenizedExpansion = iTokenArray;
        this.expansionSignature = string2;
    }

    public final String[] getParameters() {
        return this.identifierParameters;
    }

    public final IToken[] getTokenizedExpansion() {
        return this.tokenizedExpansion;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        int n = this.identifierParameters.length;
        stringBuffer.append("MacroDescriptor with name=" + this.getName() + "\n");
        stringBuffer.append("Number of parameters = " + n + "\n");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("Parameter #" + n2 + " with name=" + this.identifierParameters[n2] + "\n");
            ++n2;
        }
        n = this.tokenizedExpansion.length;
        stringBuffer.append("Number of tokens = " + n + "\n");
        n2 = 0;
        while (n2 < n) {
            stringBuffer.append("Token #" + n2++ + " is " + this.tokenizedExpansion[n2].toString() + "\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public final String getCompleteSignature() {
        StringBuffer stringBuffer = new StringBuffer("#define ");
        stringBuffer.append(this.name);
        stringBuffer.append('(');
        int n = 0;
        while (n < this.identifierParameters.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.identifierParameters[n]);
            ++n;
        }
        stringBuffer.append(") ");
        stringBuffer.append(this.expansionSignature);
        return stringBuffer.toString();
    }

    public boolean compatible(IMacroDescriptor iMacroDescriptor) {
        if (iMacroDescriptor.getName() == null) {
            return false;
        }
        if (iMacroDescriptor.getTokenizedExpansion() == null) {
            return false;
        }
        if (iMacroDescriptor.getParameters() == null) {
            return false;
        }
        if (iMacroDescriptor.getMacroType() != this.getMacroType()) {
            return false;
        }
        if (!this.name.equals(iMacroDescriptor.getName())) {
            return false;
        }
        if (iMacroDescriptor.getParameters().length != this.identifierParameters.length) {
            return false;
        }
        if (iMacroDescriptor.getTokenizedExpansion().length != this.tokenizedExpansion.length) {
            return false;
        }
        if (!this.equivalentArrayContents(iMacroDescriptor.getParameters(), this.getParameters())) {
            return false;
        }
        return this.equivalentArrayContents(iMacroDescriptor.getTokenizedExpansion(), this.getTokenizedExpansion());
    }

    private boolean equivalentArrayContents(Object[] objectArray, Object[] objectArray2) {
        if (Arrays.equals(objectArray, objectArray2)) {
            return true;
        }
        int n = 0;
        while (n < objectArray.length) {
            block4: {
                Object object = objectArray[n];
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    if (!object.equals(objectArray2[n2])) {
                        ++n2;
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    public IMacroDescriptor.MacroType getMacroType() {
        return IMacroDescriptor.MacroType.FUNCTION_LIKE;
    }

    public String getExpansionSignature() {
        return this.expansionSignature;
    }

    public boolean isCircular() {
        int n = 0;
        while (n < this.tokenizedExpansion.length) {
            IToken iToken = this.tokenizedExpansion[n];
            if (iToken.getType() == 1 && iToken.getImage().equals(this.getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

