/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.extension.IScannerExtension;
import org.eclipse.cdt.internal.core.parser.scanner.ContextException;
import org.eclipse.cdt.internal.core.parser.scanner.FunctionMacroDescriptor;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerContext;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerData;
import org.eclipse.cdt.internal.core.parser.scanner.ObjectMacroDescriptor;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerContextInclusion;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerUtility;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;
import org.eclipse.cdt.internal.core.parser.util.TraceUtil;

public class GCCScannerExtension
implements IScannerExtension {
    protected static final ObjectMacroDescriptor STDC_VERSION_MACRO = new ObjectMacroDescriptor("__STDC_VERSION__", "199001L");
    protected static final ObjectMacroDescriptor STDC_HOSTED_MACRO = new ObjectMacroDescriptor("__STDC_HOSTED__", "0");
    protected static final ObjectMacroDescriptor CPLUSPLUS_MACRO = new ObjectMacroDescriptor("__cplusplus", "1");
    private static final String[] simpleIdentifiersDeclSpec = new String[1];
    private static final String[] simpleIdentifiersAttribute;
    protected static final String POUND_IDENT = "#ident";
    protected static final String POUND_WARNING = "#warning";
    protected static final String POUND_INCLUDE_NEXT = "#include_next";
    private static final String __CONST__ = "__const__";
    protected static final ObjectMacroDescriptor __CONST__MACRO;
    private static final String __CONST = "__const";
    protected static final ObjectMacroDescriptor __CONST_MACRO;
    private static final String __INLINE__ = "__inline__";
    protected static final ObjectMacroDescriptor __INLINE__MACRO;
    private static final String __VOLATILE__ = "__volatile__";
    protected static final ObjectMacroDescriptor __VOLATILE__MACRO;
    private static final String __SIGNED__ = "__signed__";
    private static final ObjectMacroDescriptor __SIGNED__MACRO;
    private static final String __RESTRICT = "__restrict";
    private static final String __RESTRICT__ = "__restrict__";
    private static final ObjectMacroDescriptor __RESTRICT__MACRO;
    private static final String __ASM__ = "__asm__";
    protected static final ObjectMacroDescriptor __ASM__MACRO;
    private static final String __TYPEOF__ = "__typeof__";
    protected static final ObjectMacroDescriptor __TYPEOF__MACRO;
    private static final String __ATTRIBUTE__ = "__attribute__";
    private static final String __DECLSPEC = "__declspec";
    private static final IToken[] EMPTY_TOKEN_ARRAY;
    protected static final FunctionMacroDescriptor DECLSPEC_MACRO;
    protected static final FunctionMacroDescriptor ATTRIBUTE_MACRO;
    private static final String __EXTENSION__ = "__extension__";
    private static final String EMPTY_STRING = "";
    protected static final ObjectMacroDescriptor EXTENSION_MACRO;
    private static final Set directives;
    private static final Map additionalCPPKeywords;
    private static final Map additionalCKeywords;
    private static final Map additionalCPPOperators;
    private static final Map additionalCOperators;
    private static final String MAX_OPERATOR = ">?";
    private static final String MIN_OPERATOR = "<?";

    static {
        GCCScannerExtension.simpleIdentifiersDeclSpec[0] = "x";
        simpleIdentifiersAttribute = new String[1];
        GCCScannerExtension.simpleIdentifiersAttribute[0] = "xyz";
        __CONST__MACRO = new ObjectMacroDescriptor(__CONST__, "const");
        __CONST_MACRO = new ObjectMacroDescriptor(__CONST, "const");
        __INLINE__MACRO = new ObjectMacroDescriptor(__INLINE__, "inline");
        __VOLATILE__MACRO = new ObjectMacroDescriptor(__VOLATILE__, "volatile");
        __SIGNED__MACRO = new ObjectMacroDescriptor(__SIGNED__, "signed");
        __RESTRICT__MACRO = new ObjectMacroDescriptor(__RESTRICT__, "restrict");
        __ASM__MACRO = new ObjectMacroDescriptor(__ASM__, "asm");
        __TYPEOF__MACRO = new ObjectMacroDescriptor(__TYPEOF__, "typeof");
        EMPTY_TOKEN_ARRAY = new IToken[0];
        DECLSPEC_MACRO = new FunctionMacroDescriptor(__ATTRIBUTE__, simpleIdentifiersDeclSpec, EMPTY_TOKEN_ARRAY, EMPTY_STRING);
        ATTRIBUTE_MACRO = new FunctionMacroDescriptor(__ATTRIBUTE__, simpleIdentifiersAttribute, EMPTY_TOKEN_ARRAY, EMPTY_STRING);
        EXTENSION_MACRO = new ObjectMacroDescriptor(__EXTENSION__, EMPTY_STRING);
        directives = new HashSet();
        directives.add(POUND_INCLUDE_NEXT);
        directives.add(POUND_WARNING);
        directives.add(POUND_IDENT);
        additionalCKeywords = new HashMap();
        additionalCKeywords.put("__alignof__", new Integer(141));
        additionalCKeywords.put("typeof", new Integer(140));
        additionalCPPKeywords = new HashMap(additionalCKeywords);
        additionalCPPKeywords.put("restrict", new Integer(137));
        additionalCOperators = new HashMap();
        additionalCPPOperators = new HashMap();
        additionalCPPOperators.put(MAX_OPERATOR, new Integer(142));
        additionalCPPOperators.put(MIN_OPERATOR, new Integer(143));
    }

    public String initializeMacroValue(IScannerData iScannerData, String string) {
        if (string == null || string.trim().equals(EMPTY_STRING)) {
            return "1";
        }
        return string;
    }

    public void setupBuiltInMacros(IScannerData iScannerData) {
        if (iScannerData.getLanguage() == ParserLanguage.CPP && iScannerData.getScanner().getDefinition("__cplusplus") == null) {
            iScannerData.getScanner().addDefinition("__cplusplus", CPLUSPLUS_MACRO);
        }
        if (iScannerData.getScanner().getDefinition("__STDC_HOSTED__") == null) {
            iScannerData.getScanner().addDefinition("__STDC_HOSTED__", STDC_HOSTED_MACRO);
        }
        if (iScannerData.getScanner().getDefinition("__STDC_VERSION__") == null) {
            iScannerData.getScanner().addDefinition("__STDC_VERSION__", STDC_VERSION_MACRO);
        }
        if (iScannerData.getScanner().getDefinition(__ATTRIBUTE__) == null) {
            iScannerData.getPrivateDefinitions().put(__ATTRIBUTE__, ATTRIBUTE_MACRO);
        }
        if (iScannerData.getScanner().getDefinition(__DECLSPEC) == null) {
            iScannerData.getPrivateDefinitions().put(__DECLSPEC, DECLSPEC_MACRO);
        }
        if (iScannerData.getScanner().getDefinition(__EXTENSION__) == null) {
            iScannerData.getPrivateDefinitions().put(__EXTENSION__, EXTENSION_MACRO);
        }
        if (iScannerData.getScanner().getDefinition(__CONST__) == null) {
            iScannerData.getPrivateDefinitions().put(__CONST__, __CONST__MACRO);
        }
        if (iScannerData.getScanner().getDefinition(__CONST) == null) {
            iScannerData.getPrivateDefinitions().put(__CONST, __CONST_MACRO);
        }
        if (iScannerData.getScanner().getDefinition(__INLINE__) == null) {
            iScannerData.getPrivateDefinitions().put(__INLINE__, __INLINE__MACRO);
        }
        if (iScannerData.getScanner().getDefinition(__SIGNED__) == null) {
            iScannerData.getPrivateDefinitions().put(__SIGNED__, __SIGNED__MACRO);
        }
        if (iScannerData.getScanner().getDefinition(__VOLATILE__) == null) {
            iScannerData.getPrivateDefinitions().put(__VOLATILE__, __VOLATILE__MACRO);
        }
        ObjectMacroDescriptor objectMacroDescriptor = new ObjectMacroDescriptor(__RESTRICT, "restrict");
        if (iScannerData.getScanner().getDefinition(__RESTRICT) == null) {
            iScannerData.getPrivateDefinitions().put(__RESTRICT, objectMacroDescriptor);
        }
        if (iScannerData.getScanner().getDefinition(__RESTRICT__) == null) {
            iScannerData.getPrivateDefinitions().put(__RESTRICT__, __RESTRICT__MACRO);
        }
        if (iScannerData.getScanner().getDefinition(__TYPEOF__) == null) {
            iScannerData.getPrivateDefinitions().put(__TYPEOF__, __TYPEOF__MACRO);
        }
        if (iScannerData.getLanguage() == ParserLanguage.CPP && iScannerData.getScanner().getDefinition(__ASM__) == null) {
            iScannerData.getPrivateDefinitions().put(__ASM__, __ASM__MACRO);
        }
    }

    public boolean canHandlePreprocessorDirective(String string) {
        return directives.contains(string);
    }

    public void handlePreprocessorDirective(IScannerData iScannerData, String string, String string2) {
        if (string.equals(POUND_INCLUDE_NEXT)) {
            Object object;
            Object object2;
            TraceUtil.outputTrace(iScannerData.getLogService(), "GCCScannerExtension handling #include_next directive");
            IScannerContext iScannerContext = iScannerData.getContextStack().getCurrentContext();
            if (iScannerContext == null || iScannerContext.getKind() != IScannerContext.ContextKind.INCLUSION) {
                return;
            }
            String string3 = iScannerContext.getContextName();
            IASTInclusion iASTInclusion = ((ScannerContextInclusion)iScannerContext).getExtension();
            Iterator iterator = iScannerData.getIncludePathNames().iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object = ScannerUtility.createReconciledPath((String)object2, iASTInclusion.getName());
                if (((String)object).equals(string3)) break;
            }
            object2 = null;
            try {
                object2 = iScannerData.parseInclusionDirective(string2, iScannerData.getContextStack().getCurrentContext().getOffset());
            }
            catch (ScannerUtility.InclusionParseException inclusionParseException) {
                return;
            }
            object = null;
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                String string5 = ScannerUtility.createReconciledPath(string4, ((ScannerUtility.InclusionDirective)object2).getFilename());
                object = (CodeReader)iScannerData.getFileCache().get(string5);
                if (object == null && (object = ScannerUtility.createReaderDuple(string5, iScannerData.getClientRequestor(), iScannerData.getWorkingCopies())) != null && ((CodeReader)object).isFile()) {
                    iScannerData.getFileCache().put(((CodeReader)object).filename, object);
                }
                if (object != null) break;
            }
            if (object != null) {
                try {
                    iScannerData.getContextStack().updateInclusionContext((CodeReader)object, iASTInclusion, iScannerData.getClientRequestor());
                    TraceUtil.outputTrace(iScannerData.getLogService(), "GCCScannerExtension handling #include_next directive successfully pushed on new include file");
                }
                catch (ContextException contextException) {
                    return;
                }
            }
        } else if (string.equals(POUND_WARNING) || string.equals(POUND_IDENT)) {
            return;
        }
    }

    public boolean offersDifferentIdentifierCharacters() {
        return true;
    }

    public boolean isValidIdentifierStartCharacter(int n) {
        return Character.isLetter((char)n) || n == 95 || n == 36;
    }

    public boolean isValidIdentifierCharacter(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 95 || n == 36 || Character.isUnicodeIdentifierPart((char)n);
    }

    public boolean isExtensionKeyword(ParserLanguage parserLanguage, String string) {
        if (parserLanguage == ParserLanguage.CPP) {
            return additionalCPPKeywords.get(string) != null;
        }
        if (parserLanguage == ParserLanguage.C) {
            return additionalCKeywords.get(string) != null;
        }
        return false;
    }

    public IToken createExtensionToken(IScannerData iScannerData, String string) {
        Integer n = null;
        if (iScannerData.getLanguage() == ParserLanguage.CPP) {
            n = (Integer)additionalCPPKeywords.get(string);
            if (n == null) {
                n = (Integer)additionalCPPOperators.get(string);
            }
        } else if (iScannerData.getLanguage() == ParserLanguage.C && (n = (Integer)additionalCKeywords.get(string)) == null) {
            n = (Integer)additionalCOperators.get(string);
        }
        if (n == null) {
            return null;
        }
        return TokenFactory.createUniquelyImagedToken(n, string, iScannerData);
    }

    public boolean isExtensionOperator(ParserLanguage parserLanguage, String string) {
        if (parserLanguage == ParserLanguage.CPP) {
            return additionalCPPOperators.get(string) != null;
        }
        if (parserLanguage == ParserLanguage.C) {
            return additionalCOperators.get(string) != null;
        }
        return false;
    }
}

